/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.factories.TableFormatFactory;
import org.apache.flink.table.types.DataType;

@PublicEvolving
public abstract class TableFormatFactoryBase<T>
implements TableFormatFactory<T> {
    private static final String SCHEMA = "schema";
    private static final String SCHEMA_NAME = "name";
    private static final String SCHEMA_DATA_TYPE = "data-type";
    @Deprecated
    private static final String SCHEMA_TYPE = "type";
    private static final String SCHEMA_PROCTIME = "proctime";
    private static final String SCHEMA_FROM = "from";
    private static final String ROWTIME_TIMESTAMPS_TYPE = "rowtime.timestamps.type";
    private static final String ROWTIME_TIMESTAMPS_TYPE_VALUE_FROM_FIELD = "from-field";
    private static final String ROWTIME_TIMESTAMPS_FROM = "rowtime.timestamps.from";
    private static final String ROWTIME_TIMESTAMPS_CLASS = "rowtime.timestamps.class";
    private static final String ROWTIME_TIMESTAMPS_SERIALIZED = "rowtime.timestamps.serialized";
    private static final String ROWTIME_WATERMARKS_TYPE = "rowtime.watermarks.type";
    private static final String ROWTIME_WATERMARKS_CLASS = "rowtime.watermarks.class";
    private static final String ROWTIME_WATERMARKS_SERIALIZED = "rowtime.watermarks.serialized";
    private static final String ROWTIME_WATERMARKS_DELAY = "rowtime.watermarks.delay";
    private String type;
    private String version;
    private boolean supportsSchemaDerivation;

    public TableFormatFactoryBase(String type, int version, boolean supportsSchemaDerivation) {
        this.type = type;
        this.version = Integer.toString(version);
        this.supportsSchemaDerivation = supportsSchemaDerivation;
    }

    @Override
    public final Map<String, String> requiredContext() {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("format.type", this.type);
        context.put("format.property-version", this.version);
        context.putAll(this.requiredFormatContext());
        return context;
    }

    @Override
    public final boolean supportsSchemaDerivation() {
        return this.supportsSchemaDerivation;
    }

    @Override
    public final List<String> supportedProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        if (this.supportsSchemaDerivation) {
            properties.add("format.derive-schema");
            properties.add("schema.#.data-type");
            properties.add("schema.#.type");
            properties.add("schema.#.name");
            properties.add("schema.#.from");
            properties.add("schema.#.expr");
            properties.add("schema.#.proctime");
            properties.add("schema.#.rowtime.timestamps.type");
            properties.add("schema.#.rowtime.timestamps.from");
            properties.add("schema.#.rowtime.timestamps.class");
            properties.add("schema.#.rowtime.timestamps.serialized");
            properties.add("schema.#.rowtime.watermarks.type");
            properties.add("schema.#.rowtime.watermarks.class");
            properties.add("schema.#.rowtime.watermarks.serialized");
            properties.add("schema.#.rowtime.watermarks.delay");
            properties.add("schema.watermark.#.rowtime");
            properties.add("schema.watermark.#.strategy.expr");
            properties.add("schema.watermark.#.strategy.data-type");
        }
        properties.addAll(this.supportedFormatProperties());
        return properties;
    }

    protected Map<String, String> requiredFormatContext() {
        return Collections.emptyMap();
    }

    protected List<String> supportedFormatProperties() {
        return Collections.emptyList();
    }

    public static TableSchema deriveSchema(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = new DescriptorProperties();
        descriptorProperties.putProperties(properties);
        TableSchema.Builder builder = TableSchema.builder();
        TableSchema tableSchema = descriptorProperties.getTableSchema(SCHEMA);
        for (int i = 0; i < tableSchema.getFieldCount(); ++i) {
            String aliasName;
            TableColumn tableColumn = tableSchema.getTableColumns().get(i);
            String fieldName = tableColumn.getName();
            DataType dataType2 = tableColumn.getType();
            boolean isGeneratedColumn = tableColumn.isGenerated();
            if (isGeneratedColumn) continue;
            boolean isProctime = descriptorProperties.getOptionalBoolean("schema." + i + '.' + SCHEMA_PROCTIME).orElse(false);
            String timestampKey = "schema." + i + '.' + ROWTIME_TIMESTAMPS_TYPE;
            boolean isRowtime = descriptorProperties.containsKey(timestampKey);
            if (!isProctime && !isRowtime) {
                aliasName = descriptorProperties.getOptionalString("schema." + i + '.' + SCHEMA_FROM).orElse(fieldName);
                builder.field(aliasName, dataType2);
                continue;
            }
            if (!isRowtime || !descriptorProperties.isValue(timestampKey, ROWTIME_TIMESTAMPS_TYPE_VALUE_FROM_FIELD)) continue;
            aliasName = descriptorProperties.getString("schema." + i + '.' + ROWTIME_TIMESTAMPS_FROM);
            builder.field(aliasName, dataType2);
        }
        return builder.build();
    }
}

