/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions.resolver.rules;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.FunctionLookup;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.resolver.rules.ResolverRule;
import org.apache.flink.table.expressions.resolver.rules.RuleExpressionVisitor;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;

@Internal
class QualifyBuiltInFunctionsRule
implements ResolverRule {
    QualifyBuiltInFunctionsRule() {
    }

    @Override
    public List<Expression> apply(List<Expression> expression2, ResolverRule.ResolutionContext context) {
        return expression2.stream().map(expr -> expr.accept(new QualifyBuiltInFunctionVisitor(context))).collect(Collectors.toList());
    }

    private class QualifyBuiltInFunctionVisitor
    extends RuleExpressionVisitor<Expression> {
        QualifyBuiltInFunctionVisitor(ResolverRule.ResolutionContext resolutionContext) {
            super(resolutionContext);
        }

        @Override
        public Expression visit(UnresolvedCallExpression unresolvedCall) {
            if (!unresolvedCall.getFunctionIdentifier().isPresent() && unresolvedCall.getFunctionDefinition() instanceof BuiltInFunctionDefinition) {
                FunctionLookup.Result functionLookup = this.resolutionContext.functionLookup().lookupBuiltInFunction((BuiltInFunctionDefinition)unresolvedCall.getFunctionDefinition());
                return new UnresolvedCallExpression(functionLookup.getFunctionIdentifier(), functionLookup.getFunctionDefinition(), unresolvedCall.getChildren().stream().map(c -> c.accept(this)).collect(Collectors.toList()));
            }
            return unresolvedCall;
        }

        @Override
        protected Expression defaultMethod(Expression expression2) {
            return expression2;
        }
    }
}

