/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataview;

import java.io.IOException;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerUtil;
import org.apache.flink.api.common.typeutils.LegacySerializerSnapshotTransformer;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.CollectionSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.base.ListSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.api.dataview.ListView;
import org.apache.flink.table.dataview.ListViewSerializerSnapshot;

@Internal
public class ListViewSerializer<T>
extends TypeSerializer<ListView<T>>
implements LegacySerializerSnapshotTransformer<ListView<T>> {
    private static final long serialVersionUID = -2030398712359267867L;
    private final TypeSerializer<List<T>> listSerializer;

    public ListViewSerializer(TypeSerializer<List<T>> listSerializer) {
        this.listSerializer = listSerializer;
    }

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<ListView<T>> duplicate() {
        return new ListViewSerializer<T>(this.listSerializer.duplicate());
    }

    public ListView<T> createInstance() {
        return new ListView();
    }

    public ListView<T> copy(ListView<T> from) {
        return new ListView(null, (List)this.listSerializer.copy(from.list));
    }

    public ListView<T> copy(ListView<T> from, ListView<T> reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(ListView<T> record, DataOutputView target) throws IOException {
        this.listSerializer.serialize(record.list, target);
    }

    public ListView<T> deserialize(DataInputView source) throws IOException {
        return new ListView(null, (List)this.listSerializer.deserialize(source));
    }

    public ListView<T> deserialize(ListView<T> reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.listSerializer.copy(source, target);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ListViewSerializer) {
            ListViewSerializer other = (ListViewSerializer)((Object)obj);
            return this.listSerializer.equals(other.listSerializer);
        }
        return false;
    }

    public int hashCode() {
        return this.listSerializer.hashCode();
    }

    public TypeSerializerSnapshot<ListView<T>> snapshotConfiguration() {
        return new ListViewSerializerSnapshot(this);
    }

    public <U> TypeSerializerSnapshot<ListView<T>> transformLegacySerializerSnapshot(TypeSerializerSnapshot<U> legacySnapshot) {
        if (legacySnapshot instanceof ListViewSerializerSnapshot) {
            return legacySnapshot;
        }
        if (legacySnapshot instanceof CollectionSerializerConfigSnapshot) {
            ListSerializerSnapshot transformedNestedListSerializerSnapshot = new ListSerializerSnapshot();
            CollectionSerializerConfigSnapshot snapshot = (CollectionSerializerConfigSnapshot)legacySnapshot;
            CompositeTypeSerializerUtil.setNestedSerializersSnapshots((CompositeTypeSerializerSnapshot)transformedNestedListSerializerSnapshot, (TypeSerializerSnapshot[])new TypeSerializerSnapshot[]{(TypeSerializerSnapshot)snapshot.getSingleNestedSerializerAndConfig().f1});
            ListViewSerializerSnapshot transformedListViewSerializerSnapshot = new ListViewSerializerSnapshot();
            CompositeTypeSerializerUtil.setNestedSerializersSnapshots(transformedListViewSerializerSnapshot, (TypeSerializerSnapshot[])new TypeSerializerSnapshot[]{transformedNestedListSerializerSnapshot});
            return transformedListViewSerializerSnapshot;
        }
        throw new UnsupportedOperationException(legacySnapshot.getClass().getCanonicalName() + " is not supported.");
    }

    public TypeSerializer<List<T>> getListSerializer() {
        return this.listSerializer;
    }
}

