/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.List;
import java.util.Optional;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.calcite.FlinkTypeFactory;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.FunctionLookup;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.functions.AggregateFunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.ScalarFunctionDefinition;
import org.apache.flink.table.functions.TableFunctionDefinition;
import org.apache.flink.table.functions.utils.UserDefinedFunctionUtils;

@Internal
public class FunctionCatalogOperatorTable
implements SqlOperatorTable {
    private final FunctionCatalog functionCatalog;
    private final FlinkTypeFactory typeFactory;

    public FunctionCatalogOperatorTable(FunctionCatalog functionCatalog, FlinkTypeFactory typeFactory) {
        this.functionCatalog = functionCatalog;
        this.typeFactory = typeFactory;
    }

    @Override
    public void lookupOperatorOverloads(SqlIdentifier opName, SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList, SqlNameMatcher nameMatcher) {
        if (!opName.isSimple()) {
            return;
        }
        if (this.isNotUserFunction(category)) {
            return;
        }
        String name = opName.getSimple();
        Optional<FunctionLookup.Result> candidateFunction = this.functionCatalog.lookupFunction(UnresolvedIdentifier.of(name));
        candidateFunction.flatMap(lookupResult -> this.convertToSqlFunction(category, name, lookupResult.getFunctionDefinition())).ifPresent(operatorList::add);
    }

    private boolean isNotUserFunction(SqlFunctionCategory category) {
        return category != null && !category.isUserDefinedNotSpecificFunction();
    }

    private Optional<SqlFunction> convertToSqlFunction(SqlFunctionCategory category, String name, FunctionDefinition functionDefinition) {
        if (functionDefinition instanceof AggregateFunctionDefinition) {
            return this.convertAggregateFunction(name, (AggregateFunctionDefinition)functionDefinition);
        }
        if (functionDefinition instanceof ScalarFunctionDefinition) {
            return this.convertScalarFunction(name, (ScalarFunctionDefinition)functionDefinition);
        }
        if (functionDefinition instanceof TableFunctionDefinition && category != null && category.isTableFunction()) {
            return this.convertTableFunction(name, (TableFunctionDefinition)functionDefinition);
        }
        return Optional.empty();
    }

    private Optional<SqlFunction> convertAggregateFunction(String name, AggregateFunctionDefinition functionDefinition) {
        SqlFunction aggregateFunction = UserDefinedFunctionUtils.createAggregateSqlFunction(name, name, functionDefinition.getAggregateFunction(), functionDefinition.getResultTypeInfo(), functionDefinition.getAccumulatorTypeInfo(), this.typeFactory);
        return Optional.of(aggregateFunction);
    }

    private Optional<SqlFunction> convertScalarFunction(String name, ScalarFunctionDefinition functionDefinition) {
        SqlFunction scalarFunction = UserDefinedFunctionUtils.createScalarSqlFunction(name, name, functionDefinition.getScalarFunction(), this.typeFactory);
        return Optional.of(scalarFunction);
    }

    private Optional<SqlFunction> convertTableFunction(String name, TableFunctionDefinition functionDefinition) {
        SqlFunction tableFunction = UserDefinedFunctionUtils.createTableSqlFunction(name, name, functionDefinition.getTableFunction(), functionDefinition.getResultType(), this.typeFactory);
        return Optional.of(tableFunction);
    }

    @Override
    public List<SqlOperator> getOperatorList() {
        throw new UnsupportedOperationException("This should never be called");
    }
}

