/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.AbstractCatalogTable;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sources.DefinedProctimeAttribute;
import org.apache.flink.table.sources.DefinedRowtimeAttributes;
import org.apache.flink.table.sources.RowtimeAttributeDescriptor;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;

@Internal
public class ConnectorCatalogTable<T1, T2>
extends AbstractCatalogTable {
    private final TableSource<T1> tableSource;
    private final TableSink<T2> tableSink;
    private final boolean isBatch;

    public static <T1> ConnectorCatalogTable<T1, ?> source(TableSource<T1> source, boolean isBatch) {
        TableSchema tableSchema = ConnectorCatalogTable.calculateSourceSchema(source, isBatch);
        return new ConnectorCatalogTable(source, null, tableSchema, isBatch);
    }

    public static <T2> ConnectorCatalogTable<?, T2> sink(TableSink<T2> sink, boolean isBatch) {
        return new ConnectorCatalogTable(null, sink, sink.getTableSchema(), isBatch);
    }

    public static <T1, T2> ConnectorCatalogTable<T1, T2> sourceAndSink(TableSource<T1> source, TableSink<T2> sink, boolean isBatch) {
        TableSchema tableSchema = ConnectorCatalogTable.calculateSourceSchema(source, isBatch);
        return new ConnectorCatalogTable<T1, T2>(source, sink, tableSchema, isBatch);
    }

    @VisibleForTesting
    protected ConnectorCatalogTable(TableSource<T1> tableSource, TableSink<T2> tableSink, TableSchema tableSchema, boolean isBatch) {
        super(tableSchema, Collections.emptyMap(), "");
        this.tableSource = tableSource;
        this.tableSink = tableSink;
        this.isBatch = isBatch;
    }

    public Optional<TableSource<T1>> getTableSource() {
        return Optional.ofNullable(this.tableSource);
    }

    public Optional<TableSink<T2>> getTableSink() {
        return Optional.ofNullable(this.tableSink);
    }

    public boolean isBatch() {
        return this.isBatch;
    }

    @Override
    public Map<String, String> toProperties() {
        throw new UnsupportedOperationException("ConnectorCatalogTable cannot be converted to properties");
    }

    @Override
    public CatalogBaseTable copy() {
        return this;
    }

    @Override
    public Optional<String> getDescription() {
        return Optional.empty();
    }

    @Override
    public Optional<String> getDetailedDescription() {
        return Optional.empty();
    }

    private static <T1> TableSchema calculateSourceSchema(TableSource<T1> source, boolean isBatch) {
        TableSchema tableSchema = source.getTableSchema();
        if (isBatch) {
            return tableSchema;
        }
        DataType[] types = Arrays.copyOf(tableSchema.getFieldDataTypes(), tableSchema.getFieldCount());
        String[] fieldNames = tableSchema.getFieldNames();
        if (source instanceof DefinedRowtimeAttributes) {
            ConnectorCatalogTable.updateRowtimeIndicators((DefinedRowtimeAttributes)((Object)source), fieldNames, types);
        }
        if (source instanceof DefinedProctimeAttribute) {
            ConnectorCatalogTable.updateProctimeIndicator((DefinedProctimeAttribute)((Object)source), fieldNames, types);
        }
        return TableSchema.builder().fields(fieldNames, types).build();
    }

    private static void updateRowtimeIndicators(DefinedRowtimeAttributes source, String[] fieldNames, DataType[] types) {
        List rowtimeAttributes = source.getRowtimeAttributeDescriptors().stream().map(RowtimeAttributeDescriptor::getAttributeName).collect(Collectors.toList());
        for (int i = 0; i < fieldNames.length; ++i) {
            if (!rowtimeAttributes.contains(fieldNames[i])) continue;
            types[i] = new AtomicDataType(new TimestampType(true, TimestampKind.ROWTIME, 3)).bridgedTo(Timestamp.class);
        }
    }

    private static void updateProctimeIndicator(DefinedProctimeAttribute source, String[] fieldNames, DataType[] types) {
        String proctimeAttribute = source.getProctimeAttribute();
        for (int i = 0; i < fieldNames.length; ++i) {
            if (!fieldNames[i].equals(proctimeAttribute)) continue;
            types[i] = new AtomicDataType(new TimestampType(true, TimestampKind.PROCTIME, 3)).bridgedTo(Timestamp.class);
            break;
        }
    }
}

