/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.Objects;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;

public class WatermarkSpec {
    private final String rowtimeAttribute;
    private final String watermarkExpressionString;
    private final DataType watermarkExprOutputType;

    public WatermarkSpec(String rowtimeAttribute, String watermarkExpressionString, DataType watermarkExprOutputType) {
        this.rowtimeAttribute = (String)Preconditions.checkNotNull((Object)rowtimeAttribute);
        this.watermarkExpressionString = (String)Preconditions.checkNotNull((Object)watermarkExpressionString);
        this.watermarkExprOutputType = (DataType)Preconditions.checkNotNull((Object)watermarkExprOutputType);
    }

    public String getRowtimeAttribute() {
        return this.rowtimeAttribute;
    }

    public String getWatermarkExpr() {
        return this.watermarkExpressionString;
    }

    public DataType getWatermarkExprOutputType() {
        return this.watermarkExprOutputType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatermarkSpec that = (WatermarkSpec)o;
        return Objects.equals(this.rowtimeAttribute, that.rowtimeAttribute) && Objects.equals(this.watermarkExpressionString, that.watermarkExpressionString) && Objects.equals(this.watermarkExprOutputType, that.watermarkExprOutputType);
    }

    public int hashCode() {
        return Objects.hash(this.rowtimeAttribute, this.watermarkExpressionString, this.watermarkExprOutputType);
    }

    public String toString() {
        return "rowtime: '" + this.rowtimeAttribute + '\'' + ", watermark: '" + this.watermarkExpressionString + '\'';
    }
}

