/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.calcite.sql.ExtendedSqlRowTypeNameSpec;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.dialect.AnsiSqlDialect;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.ExtendedSqlNode;
import org.apache.flink.sql.parser.ddl.SqlTableColumn;
import org.apache.flink.sql.parser.ddl.SqlWatermark;
import org.apache.flink.sql.parser.error.SqlValidateException;

public class SqlCreateTable
extends SqlCreate
implements ExtendedSqlNode {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE TABLE", SqlKind.CREATE_TABLE);
    private final SqlIdentifier tableName;
    private final SqlNodeList columnList;
    private final SqlNodeList propertyList;
    private final SqlNodeList primaryKeyList;
    private final List<SqlNodeList> uniqueKeysList;
    private final SqlNodeList partitionKeyList;
    @Nullable
    private final SqlWatermark watermark;
    @Nullable
    private final SqlCharStringLiteral comment;

    public SqlCreateTable(SqlParserPos pos, SqlIdentifier tableName, SqlNodeList columnList, SqlNodeList primaryKeyList, List<SqlNodeList> uniqueKeysList, SqlNodeList propertyList, SqlNodeList partitionKeyList, SqlWatermark watermark, SqlCharStringLiteral comment) {
        super(OPERATOR, pos, false, false);
        this.tableName = Objects.requireNonNull(tableName, "tableName should not be null");
        this.columnList = Objects.requireNonNull(columnList, "columnList should not be null");
        this.primaryKeyList = Objects.requireNonNull(primaryKeyList, "primayKeyList should not be null");
        this.uniqueKeysList = Objects.requireNonNull(uniqueKeysList, "uniqueKeysList should not be null");
        this.propertyList = Objects.requireNonNull(propertyList, "propertyList should not be null");
        this.partitionKeyList = Objects.requireNonNull(partitionKeyList, "partitionKeyList should not be null");
        this.watermark = watermark;
        this.comment = comment;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.tableName, this.columnList, this.primaryKeyList, this.propertyList, this.partitionKeyList, this.watermark, this.comment);
    }

    public SqlIdentifier getTableName() {
        return this.tableName;
    }

    public SqlNodeList getColumnList() {
        return this.columnList;
    }

    public SqlNodeList getPropertyList() {
        return this.propertyList;
    }

    public SqlNodeList getPartitionKeyList() {
        return this.partitionKeyList;
    }

    public SqlNodeList getPrimaryKeyList() {
        return this.primaryKeyList;
    }

    public List<SqlNodeList> getUniqueKeysList() {
        return this.uniqueKeysList;
    }

    public Optional<SqlWatermark> getWatermark() {
        return Optional.ofNullable(this.watermark);
    }

    public Optional<SqlCharStringLiteral> getComment() {
        return Optional.ofNullable(this.comment);
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    @Override
    public void validate() throws SqlValidateException {
        String rowtimeField;
        ColumnValidator validator = new ColumnValidator();
        for (SqlNode column : this.columnList) {
            validator.addColumn(column);
        }
        for (SqlNode primaryKeyNode : this.primaryKeyList) {
            String primaryKey = ((SqlIdentifier)primaryKeyNode).getSimple();
            if (validator.contains(primaryKey)) continue;
            throw new SqlValidateException(primaryKeyNode.getParserPosition(), "Primary key [" + (String)primaryKey + "] not defined in columns, at " + primaryKeyNode.getParserPosition());
        }
        for (SqlNodeList uniqueKeys : this.uniqueKeysList) {
            for (SqlNode uniqueKeyNode : uniqueKeys) {
                String uniqueKey = ((SqlIdentifier)uniqueKeyNode).getSimple();
                if (validator.contains(uniqueKey)) continue;
                throw new SqlValidateException(uniqueKeyNode.getParserPosition(), "Unique key [" + uniqueKey + "] not defined in columns, at " + uniqueKeyNode.getParserPosition());
            }
        }
        for (SqlNode partitionKeyNode : this.partitionKeyList.getList()) {
            String partitionKey = ((SqlIdentifier)partitionKeyNode).getSimple();
            if (validator.contains(partitionKey)) continue;
            throw new SqlValidateException(partitionKeyNode.getParserPosition(), "Partition column [" + partitionKey + "] not defined in columns, at " + partitionKeyNode.getParserPosition());
        }
        if (this.watermark != null && !validator.contains(rowtimeField = this.watermark.getEventTimeColumnName().toString())) {
            throw new SqlValidateException(this.watermark.getEventTimeColumnName().getParserPosition(), "The rowtime attribute field \"" + rowtimeField + "\" is not defined in columns, at " + this.watermark.getEventTimeColumnName().getParserPosition());
        }
    }

    public boolean containsComputedColumn() {
        for (SqlNode column : this.columnList) {
            if (!(column instanceof SqlBasicCall)) continue;
            return true;
        }
        return false;
    }

    public String getColumnSqlString() {
        SqlPrettyWriter writer = new SqlPrettyWriter(AnsiSqlDialect.DEFAULT);
        writer.setAlwaysUseParentheses(true);
        writer.setSelectListItemsOnSeparateLines(false);
        writer.setIndentation(0);
        writer.startList("", "");
        for (SqlNode column : this.columnList) {
            writer.sep(",");
            if (column instanceof SqlTableColumn) {
                SqlTableColumn tableColumn = (SqlTableColumn)column;
                tableColumn.getName().unparse(writer, 0, 0);
                continue;
            }
            column.unparse(writer, 0, 0);
        }
        return writer.toString();
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE TABLE");
        this.tableName.unparse(writer, leftPrec, rightPrec);
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.create("sds"), "(", ")");
        for (SqlNode column : this.columnList) {
            this.printIndent(writer);
            if (column instanceof SqlBasicCall) {
                SqlCall call = (SqlCall)column;
                SqlCall newCall = call.getOperator().createCall(SqlParserPos.ZERO, new SqlNode[]{call.operand(1), call.operand(0)});
                newCall.unparse(writer, leftPrec, rightPrec);
                continue;
            }
            column.unparse(writer, leftPrec, rightPrec);
        }
        if (this.primaryKeyList.size() > 0) {
            this.printIndent(writer);
            writer.keyword("PRIMARY KEY");
            SqlWriter.Frame keyFrame = writer.startList("(", ")");
            this.primaryKeyList.unparse(writer, leftPrec, rightPrec);
            writer.endList(keyFrame);
        }
        if (this.uniqueKeysList.size() > 0) {
            this.printIndent(writer);
            for (SqlNodeList uniqueKeyList : this.uniqueKeysList) {
                writer.keyword("UNIQUE");
                SqlWriter.Frame keyFrame = writer.startList("(", ")");
                uniqueKeyList.unparse(writer, leftPrec, rightPrec);
                writer.endList(keyFrame);
            }
        }
        if (this.watermark != null) {
            this.printIndent(writer);
            this.watermark.unparse(writer, leftPrec, rightPrec);
        }
        writer.newlineAndIndent();
        writer.endList(frame);
        if (this.comment != null) {
            writer.newlineAndIndent();
            writer.keyword("COMMENT");
            this.comment.unparse(writer, leftPrec, rightPrec);
        }
        if (this.partitionKeyList.size() > 0) {
            writer.newlineAndIndent();
            writer.keyword("PARTITIONED BY");
            SqlWriter.Frame partitionedByFrame = writer.startList("(", ")");
            this.partitionKeyList.unparse(writer, leftPrec, rightPrec);
            writer.endList(partitionedByFrame);
            writer.newlineAndIndent();
        }
        if (this.propertyList.size() > 0) {
            writer.keyword("WITH");
            SqlWriter.Frame withFrame = writer.startList("(", ")");
            for (SqlNode property : this.propertyList) {
                this.printIndent(writer);
                property.unparse(writer, leftPrec, rightPrec);
            }
            writer.newlineAndIndent();
            writer.endList(withFrame);
        }
    }

    private void printIndent(SqlWriter writer) {
        writer.sep(",", false);
        writer.newlineAndIndent();
        writer.print("  ");
    }

    public String[] fullTableName() {
        return this.tableName.names.toArray(new String[0]);
    }

    private static final class ColumnValidator {
        private final Set<String> allColumnNames = new HashSet<String>();

        private ColumnValidator() {
        }

        public void addColumn(SqlNode column) throws SqlValidateException {
            String columnName;
            if (column instanceof SqlTableColumn) {
                SqlTableColumn tableColumn = (SqlTableColumn)column;
                columnName = tableColumn.getName().getSimple();
                this.addNestedColumn(columnName, tableColumn.getType());
            } else if (column instanceof SqlBasicCall) {
                SqlBasicCall tableColumn = (SqlBasicCall)column;
                columnName = tableColumn.getOperands()[1].toString();
            } else {
                throw new UnsupportedOperationException("Unsupported column:" + column);
            }
            this.addColumnName(columnName, column.getParserPosition());
        }

        public boolean contains(String columnName) {
            return this.allColumnNames.contains(columnName);
        }

        private void addNestedColumn(String columnName, SqlDataTypeSpec columnType) throws SqlValidateException {
            SqlTypeNameSpec typeName = columnType.getTypeNameSpec();
            if (typeName instanceof ExtendedSqlRowTypeNameSpec) {
                ExtendedSqlRowTypeNameSpec rowType = (ExtendedSqlRowTypeNameSpec)typeName;
                for (int i = 0; i < rowType.getFieldNames().size(); ++i) {
                    SqlIdentifier fieldName = rowType.getFieldNames().get(i);
                    String fullName = columnName + "." + fieldName;
                    this.addColumnName(fullName, fieldName.getParserPosition());
                    SqlDataTypeSpec fieldType = rowType.getFieldTypes().get(i);
                    this.addNestedColumn(fullName, fieldType);
                }
            }
        }

        private void addColumnName(String columnName, SqlParserPos pos) throws SqlValidateException {
            if (!this.allColumnNames.add(columnName)) {
                throw new SqlValidateException(pos, "Duplicate column name [" + columnName + "], at " + pos);
            }
        }
    }

    public static class TableCreationContext {
        public List<SqlNode> columnList = new ArrayList<SqlNode>();
        public SqlNodeList primaryKeyList = SqlNodeList.EMPTY;
        public List<SqlNodeList> uniqueKeysList = new ArrayList<SqlNodeList>();
        @Nullable
        public SqlWatermark watermark;
    }
}

