/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.dialect;

import org.apache.calcite.config.NullCollation;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;

public class HiveSqlDialect
extends SqlDialect {
    public static final SqlDialect DEFAULT = new HiveSqlDialect(EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.HIVE).withNullCollation(NullCollation.LOW));
    private final boolean emulateNullDirection;

    public HiveSqlDialect(SqlDialect.Context context) {
        super(context);
        this.emulateNullDirection = context.databaseMajorVersion() < 2 || context.databaseMajorVersion() == 2 && context.databaseMinorVersion() < 1;
    }

    @Override
    protected boolean allowsAs() {
        return false;
    }

    @Override
    public void unparseOffsetFetch(SqlWriter writer, SqlNode offset, SqlNode fetch) {
        this.unparseFetchUsingLimit(writer, offset, fetch);
    }

    @Override
    public SqlNode emulateNullDirection(SqlNode node, boolean nullsFirst, boolean desc) {
        if (this.emulateNullDirection) {
            return this.emulateNullDirectionWithIsNull(node, nullsFirst, desc);
        }
        return null;
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        switch (call.getKind()) {
            case POSITION: {
                SqlWriter.Frame frame = writer.startFunCall("INSTR");
                writer.sep(",");
                ((SqlNode)call.operand(1)).unparse(writer, leftPrec, rightPrec);
                writer.sep(",");
                ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
                if (3 == call.operandCount()) {
                    throw new RuntimeException("3rd operand Not Supported for Function INSTR in Hive");
                }
                writer.endFunCall(frame);
                break;
            }
            case MOD: {
                SqlBinaryOperator op = SqlStdOperatorTable.PERCENT_REMAINDER;
                SqlSyntax.BINARY.unparse(writer, op, call, leftPrec, rightPrec);
                break;
            }
            case TRIM: {
                this.unparseTrim(writer, call, leftPrec, rightPrec);
                break;
            }
            default: {
                super.unparseCall(writer, call, leftPrec, rightPrec);
            }
        }
    }

    private void unparseTrim(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        String operatorName;
        assert (call.operand(0) instanceof SqlLiteral) : call.operand(0);
        SqlLiteral flag = (SqlLiteral)call.operand(0);
        switch (flag.getValueAs(SqlTrimFunction.Flag.class)) {
            case LEADING: {
                operatorName = "LTRIM";
                break;
            }
            case TRAILING: {
                operatorName = "RTRIM";
                break;
            }
            default: {
                operatorName = call.getOperator().getName();
            }
        }
        SqlWriter.Frame frame = writer.startFunCall(operatorName);
        ((SqlNode)call.operand(2)).unparse(writer, leftPrec, rightPrec);
        writer.endFunCall(frame);
    }

    @Override
    public boolean supportsCharSet() {
        return false;
    }
}

