/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.util.ArrayList;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableFilter;
import org.apache.calcite.adapter.enumerable.EnumerableHashJoin;
import org.apache.calcite.adapter.enumerable.EnumerableNestedLoopJoin;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;

class EnumerableJoinRule
extends ConverterRule {
    EnumerableJoinRule() {
        super(LogicalJoin.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableJoinRule");
    }

    @Override
    public RelNode convert(RelNode rel) {
        LogicalJoin join = (LogicalJoin)rel;
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
        for (RelNode input : join.getInputs()) {
            if (!(input.getConvention() instanceof EnumerableConvention)) {
                input = EnumerableJoinRule.convert(input, input.getTraitSet().replace(EnumerableConvention.INSTANCE));
            }
            newInputs.add(input);
        }
        RelOptCluster cluster = join.getCluster();
        RelNode left = (RelNode)newInputs.get(0);
        RelNode right = (RelNode)newInputs.get(1);
        JoinInfo info = join.analyzeCondition();
        if (!info.isEqui() && join.getJoinType() != JoinRelType.INNER) {
            boolean hasEquiKeys = !info.leftKeys.isEmpty() && !info.rightKeys.isEmpty();
            Join newRel = hasEquiKeys ? EnumerableHashJoin.create(left, right, join.getCondition(), join.getVariablesSet(), join.getJoinType()) : EnumerableNestedLoopJoin.create(left, right, join.getCondition(), join.getVariablesSet(), join.getJoinType());
            return newRel;
        }
        AbstractRelNode newRel = EnumerableHashJoin.create(left, right, info.getEquiCondition(left, right, cluster.getRexBuilder()), join.getVariablesSet(), join.getJoinType());
        if (!info.isEqui()) {
            RexNode nonEqui = RexUtil.composeConjunction(cluster.getRexBuilder(), info.nonEquiConditions);
            newRel = new EnumerableFilter(cluster, newRel.getTraitSet(), newRel, nonEqui);
        }
        return newRel;
    }
}

