/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeStrategy;

@Internal
class ArrayTypeStrategy
implements TypeStrategy {
    ArrayTypeStrategy() {
    }

    @Override
    public Optional<DataType> inferType(CallContext callContext) {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        if (argumentDataTypes.size() < 1) {
            return Optional.empty();
        }
        return Optional.of(DataTypes.ARRAY(argumentDataTypes.get(0)).notNull());
    }
}

