/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.util.Preconditions;

@Internal
public final class SequenceInputTypeStrategy
implements InputTypeStrategy {
    private final List<? extends ArgumentTypeStrategy> argumentStrategies;
    @Nullable
    private final List<String> argumentNames;

    public SequenceInputTypeStrategy(List<? extends ArgumentTypeStrategy> argumentStrategies, @Nullable List<String> argumentNames) {
        Preconditions.checkArgument((argumentNames == null || argumentNames.size() == argumentStrategies.size() ? 1 : 0) != 0);
        this.argumentStrategies = argumentStrategies;
        this.argumentNames = argumentNames;
    }

    @Override
    public ArgumentCount getArgumentCount() {
        return ConstantArgumentCount.of(this.argumentStrategies.size());
    }

    @Override
    public Optional<List<DataType>> inferInputTypes(CallContext callContext, boolean throwOnFailure) {
        List<DataType> dataTypes = callContext.getArgumentDataTypes();
        if (dataTypes.size() != this.argumentStrategies.size()) {
            return Optional.empty();
        }
        ArrayList<DataType> inferredDataTypes = new ArrayList<DataType>(dataTypes.size());
        for (int i = 0; i < this.argumentStrategies.size(); ++i) {
            ArgumentTypeStrategy argumentTypeStrategy = this.argumentStrategies.get(i);
            Optional<DataType> inferredDataType = argumentTypeStrategy.inferArgumentType(callContext, i, throwOnFailure);
            if (!inferredDataType.isPresent()) {
                return Optional.empty();
            }
            inferredDataTypes.add(inferredDataType.get());
        }
        return Optional.of(inferredDataTypes);
    }

    @Override
    public List<Signature> getExpectedSignatures(FunctionDefinition definition) {
        ArrayList<Signature.Argument> arguments = new ArrayList<Signature.Argument>();
        for (int i = 0; i < this.argumentStrategies.size(); ++i) {
            if (this.argumentNames == null) {
                arguments.add(this.argumentStrategies.get(i).getExpectedArgument(definition, i));
                continue;
            }
            arguments.add(Signature.Argument.of(this.argumentNames.get(i), this.argumentStrategies.get(i).getExpectedArgument(definition, i).getType()));
        }
        return Collections.singletonList(Signature.of(arguments));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SequenceInputTypeStrategy that = (SequenceInputTypeStrategy)o;
        return Objects.equals(this.argumentStrategies, that.argumentStrategies) && Objects.equals(this.argumentNames, that.argumentNames);
    }

    public int hashCode() {
        return Objects.hash(this.argumentStrategies, this.argumentNames);
    }
}

