/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.Arrays;
import java.util.Optional;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.module.Module;
import org.apache.flink.table.module.ModuleEntry;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.types.AbstractDataType;

@PublicEvolving
public interface TableEnvironment {
    public static TableEnvironment create(EnvironmentSettings settings) {
        return TableEnvironmentImpl.create(settings);
    }

    public static TableEnvironment create(Configuration configuration) {
        return TableEnvironmentImpl.create(configuration);
    }

    default public Table fromValues(Object ... values) {
        return this.fromValues(Arrays.asList(values));
    }

    default public Table fromValues(AbstractDataType<?> rowType, Object ... values) {
        return this.fromValues(rowType, Arrays.asList(values));
    }

    public Table fromValues(Expression ... var1);

    public Table fromValues(AbstractDataType<?> var1, Expression ... var2);

    public Table fromValues(Iterable<?> var1);

    public Table fromValues(AbstractDataType<?> var1, Iterable<?> var2);

    @Deprecated
    public Table fromTableSource(TableSource<?> var1);

    public void registerCatalog(String var1, Catalog var2);

    public Optional<Catalog> getCatalog(String var1);

    public void loadModule(String var1, Module var2);

    public void useModules(String ... var1);

    public void unloadModule(String var1);

    @Deprecated
    public void registerFunction(String var1, ScalarFunction var2);

    public void createTemporarySystemFunction(String var1, Class<? extends UserDefinedFunction> var2);

    public void createTemporarySystemFunction(String var1, UserDefinedFunction var2);

    public boolean dropTemporarySystemFunction(String var1);

    public void createFunction(String var1, Class<? extends UserDefinedFunction> var2);

    public void createFunction(String var1, Class<? extends UserDefinedFunction> var2, boolean var3);

    public boolean dropFunction(String var1);

    public void createTemporaryFunction(String var1, Class<? extends UserDefinedFunction> var2);

    public void createTemporaryFunction(String var1, UserDefinedFunction var2);

    public boolean dropTemporaryFunction(String var1);

    public void createTemporaryTable(String var1, TableDescriptor var2);

    public void createTable(String var1, TableDescriptor var2);

    @Deprecated
    public void registerTable(String var1, Table var2);

    public void createTemporaryView(String var1, Table var2);

    @Deprecated
    public Table scan(String ... var1);

    public Table from(String var1);

    public Table from(TableDescriptor var1);

    @Deprecated
    public void insertInto(Table var1, String var2, String ... var3);

    @Deprecated
    public void insertInto(String var1, Table var2);

    public String[] listCatalogs();

    public String[] listModules();

    public ModuleEntry[] listFullModules();

    public String[] listDatabases();

    public String[] listTables();

    public String[] listViews();

    public String[] listTemporaryTables();

    public String[] listTemporaryViews();

    public String[] listUserDefinedFunctions();

    public String[] listFunctions();

    public boolean dropTemporaryTable(String var1);

    public boolean dropTemporaryView(String var1);

    @Deprecated
    public String explain(Table var1);

    @Deprecated
    public String explain(Table var1, boolean var2);

    @Deprecated
    public String explain(boolean var1);

    public String explainSql(String var1, ExplainDetail ... var2);

    @Deprecated
    public String[] getCompletionHints(String var1, int var2);

    public Table sqlQuery(String var1);

    public TableResult executeSql(String var1);

    @Deprecated
    public void sqlUpdate(String var1);

    public String getCurrentCatalog();

    public void useCatalog(String var1);

    public String getCurrentDatabase();

    public void useDatabase(String var1);

    public TableConfig getConfig();

    @Deprecated
    public JobExecutionResult execute(String var1) throws Exception;

    public StatementSet createStatementSet();
}

