/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import org.apache.flink.table.operations.ShowOperation;

public class ShowFunctionsOperation
implements ShowOperation {
    private final FunctionScope functionScope;

    public ShowFunctionsOperation() {
        this.functionScope = FunctionScope.ALL;
    }

    public ShowFunctionsOperation(FunctionScope functionScope) {
        this.functionScope = functionScope;
    }

    @Override
    public String asSummaryString() {
        if (this.functionScope == FunctionScope.ALL) {
            return "SHOW FUNCTIONS";
        }
        return String.format("SHOW %s FUNCTIONS", new Object[]{this.functionScope});
    }

    public FunctionScope getFunctionScope() {
        return this.functionScope;
    }

    public static enum FunctionScope {
        USER,
        ALL;

    }
}

