/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.QueryOperationVisitor;

@Internal
public class CalculatedQueryOperation
implements QueryOperation {
    private final FunctionDefinition functionDefinition;
    @Nullable
    private final FunctionIdentifier functionIdentifier;
    private final List<ResolvedExpression> arguments;
    private final TableSchema tableSchema;

    public CalculatedQueryOperation(FunctionDefinition functionDefinition, @Nullable FunctionIdentifier functionIdentifier, List<ResolvedExpression> arguments, TableSchema tableSchema) {
        this.functionDefinition = functionDefinition;
        this.functionIdentifier = functionIdentifier;
        this.arguments = arguments;
        this.tableSchema = tableSchema;
    }

    public FunctionDefinition getFunctionDefinition() {
        return this.functionDefinition;
    }

    public Optional<FunctionIdentifier> getFunctionIdentifier() {
        return Optional.ofNullable(this.functionIdentifier);
    }

    public List<ResolvedExpression> getArguments() {
        return this.arguments;
    }

    @Override
    public TableSchema getTableSchema() {
        return this.tableSchema;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        if (this.functionIdentifier != null) {
            args.put("function", this.functionIdentifier);
        } else {
            args.put("function", this.functionDefinition.toString());
        }
        args.put("arguments", this.arguments);
        return OperationUtils.formatWithChildren("CalculatedTable", args, this.getChildren(), Operation::asSummaryString);
    }

    @Override
    public List<QueryOperation> getChildren() {
        return Collections.emptyList();
    }

    public <U> U accept(QueryOperationVisitor<U> visitor) {
        return visitor.visit(this);
    }
}

