/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.List;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.AlterTableOperation;

public class DropPartitionsOperation
extends AlterTableOperation {
    private final boolean ifExists;
    private final List<CatalogPartitionSpec> partitionSpecs;

    public DropPartitionsOperation(ObjectIdentifier tableIdentifier, boolean ifExists, List<CatalogPartitionSpec> partitionSpecs) {
        super(tableIdentifier);
        this.ifExists = ifExists;
        this.partitionSpecs = partitionSpecs;
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    public List<CatalogPartitionSpec> getPartitionSpecs() {
        return this.partitionSpecs;
    }

    @Override
    public String asSummaryString() {
        StringBuilder builder = new StringBuilder(String.format("ALTER TABLE %s DROP", this.tableIdentifier.asSummaryString()));
        if (this.ifExists) {
            builder.append(" IF EXISTS");
        }
        for (CatalogPartitionSpec spec : this.partitionSpecs) {
            builder.append(String.format(" PARTITION (%s)", OperationUtils.formatPartitionSpec(spec)));
        }
        return builder.toString();
    }
}

