/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions.resolver.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.delegation.PlannerTypeInferenceUtil;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.TypeLiteralExpression;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.expressions.resolver.rules.ResolverRule;
import org.apache.flink.table.expressions.resolver.rules.RuleExpressionVisitor;
import org.apache.flink.table.functions.AggregateFunctionDefinition;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.ScalarFunctionDefinition;
import org.apache.flink.table.functions.TableAggregateFunctionDefinition;
import org.apache.flink.table.functions.TableFunctionDefinition;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeInferenceUtil;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.util.Preconditions;

@Internal
final class ResolveCallByArgumentsRule
implements ResolverRule {
    ResolveCallByArgumentsRule() {
    }

    @Override
    public List<Expression> apply(List<Expression> expression, ResolverRule.ResolutionContext context) {
        return expression.stream().flatMap(expr -> ((List)expr.accept((ExpressionVisitor)new ResolvingCallVisitor(context, null))).stream()).collect(Collectors.toList());
    }

    private static class TableApiCallContext
    implements CallContext {
        private final DataTypeFactory typeFactory;
        private final String name;
        private final FunctionDefinition definition;
        private final List<ResolvedExpression> resolvedArgs;

        public TableApiCallContext(DataTypeFactory typeFactory, String name, FunctionDefinition definition, List<ResolvedExpression> resolvedArgs) {
            this.typeFactory = typeFactory;
            this.name = name;
            this.definition = definition;
            this.resolvedArgs = resolvedArgs;
        }

        public DataTypeFactory getDataTypeFactory() {
            return this.typeFactory;
        }

        public FunctionDefinition getFunctionDefinition() {
            return this.definition;
        }

        public boolean isArgumentLiteral(int pos) {
            ResolvedExpression arg = this.getArgument(pos);
            return arg instanceof ValueLiteralExpression || arg instanceof TypeLiteralExpression;
        }

        public boolean isArgumentNull(int pos) {
            Preconditions.checkArgument((boolean)this.isArgumentLiteral(pos), (String)"Argument at position %s is not a literal.", (Object[])new Object[]{pos});
            ResolvedExpression arg = this.getArgument(pos);
            if (arg instanceof TypeLiteralExpression) {
                return false;
            }
            ValueLiteralExpression literal = (ValueLiteralExpression)this.getArgument(pos);
            return literal.isNull();
        }

        public <T> Optional<T> getArgumentValue(int pos, Class<T> clazz) {
            Preconditions.checkArgument((boolean)this.isArgumentLiteral(pos), (String)"Argument at position %s is not a literal.", (Object[])new Object[]{pos});
            ResolvedExpression arg = this.getArgument(pos);
            if (arg instanceof TypeLiteralExpression) {
                if (!DataType.class.isAssignableFrom(clazz)) {
                    return Optional.empty();
                }
                return Optional.of(arg.getOutputDataType());
            }
            ValueLiteralExpression literal = (ValueLiteralExpression)this.getArgument(pos);
            return literal.getValueAs(clazz);
        }

        public String getName() {
            return this.name;
        }

        public List<DataType> getArgumentDataTypes() {
            return this.resolvedArgs.stream().map(ResolvedExpression::getOutputDataType).collect(Collectors.toList());
        }

        public Optional<DataType> getOutputDataType() {
            return Optional.empty();
        }

        private ResolvedExpression getArgument(int pos) {
            if (pos >= this.resolvedArgs.size()) {
                throw new IndexOutOfBoundsException(String.format("Not enough arguments to access literal at position %d for function '%s'.", pos, this.name));
            }
            return this.resolvedArgs.get(pos);
        }
    }

    private static class ResolvingCallVisitor
    extends RuleExpressionVisitor<List<ResolvedExpression>> {
        @Nullable
        private TypeInferenceUtil.SurroundingInfo surroundingInfo;

        ResolvingCallVisitor(ResolverRule.ResolutionContext context, @Nullable TypeInferenceUtil.SurroundingInfo surroundingInfo) {
            super(context);
            this.surroundingInfo = surroundingInfo;
        }

        @Override
        public List<ResolvedExpression> visit(UnresolvedCallExpression unresolvedCall) {
            FunctionDefinition definition = !unresolvedCall.getFunctionIdentifier().isPresent() ? this.prepareInlineUserDefinedFunction(unresolvedCall.getFunctionDefinition()) : unresolvedCall.getFunctionDefinition();
            String name = unresolvedCall.getFunctionIdentifier().map(FunctionIdentifier::toString).orElseGet(definition::toString);
            Optional<TypeInference> typeInference = this.getOptionalTypeInference(definition);
            ArrayList<ResolvedExpression> resolvedArgs = new ArrayList<ResolvedExpression>();
            int argCount = unresolvedCall.getChildren().size();
            for (int i = 0; i < argCount; ++i) {
                int currentPos = i;
                ResolvingCallVisitor childResolver = new ResolvingCallVisitor(this.resolutionContext, typeInference.map(inference -> new TypeInferenceUtil.SurroundingInfo(name, definition, inference, argCount, currentPos)).orElse(null));
                resolvedArgs.addAll((Collection)unresolvedCall.getChildren().get(i).accept((ExpressionVisitor)childResolver));
            }
            if (definition == BuiltInFunctionDefinitions.FLATTEN) {
                return this.executeFlatten(resolvedArgs);
            }
            return Collections.singletonList(typeInference.map(newInference -> this.runTypeInference(name, unresolvedCall, (TypeInference)newInference, (List<ResolvedExpression>)resolvedArgs, this.surroundingInfo)).orElseGet(() -> this.runLegacyTypeInference(unresolvedCall, resolvedArgs)));
        }

        @Override
        protected List<ResolvedExpression> defaultMethod(Expression expression) {
            if (expression instanceof ResolvedExpression) {
                return Collections.singletonList((ResolvedExpression)expression);
            }
            throw new TableException("Unexpected unresolved expression: " + expression);
        }

        private List<ResolvedExpression> executeFlatten(List<ResolvedExpression> args) {
            if (args.size() != 1) {
                throw new ValidationException("Invalid number of arguments for flattening.");
            }
            ResolvedExpression composite = args.get(0);
            TypeInformation resultType = TypeConversions.fromDataTypeToLegacyInfo((DataType)composite.getOutputDataType());
            if (resultType instanceof CompositeType) {
                return this.flattenCompositeType(composite, (CompositeType)resultType);
            }
            return Collections.singletonList(composite);
        }

        private List<ResolvedExpression> flattenCompositeType(ResolvedExpression composite, CompositeType<?> resultType) {
            return IntStream.range(0, resultType.getArity()).mapToObj(idx -> this.resolutionContext.postResolutionFactory().get(composite, ApiExpressionUtils.valueLiteral(resultType.getFieldNames()[idx]), TypeConversions.fromLegacyInfoToDataType((TypeInformation)resultType.getTypeAt(idx)))).collect(Collectors.toList());
        }

        private Optional<TypeInference> getOptionalTypeInference(FunctionDefinition definition) {
            if (definition instanceof ScalarFunctionDefinition || definition instanceof TableFunctionDefinition || definition instanceof AggregateFunctionDefinition || definition instanceof TableAggregateFunctionDefinition) {
                return Optional.empty();
            }
            TypeInference inference = definition.getTypeInference(this.resolutionContext.typeFactory());
            if (inference.getOutputTypeStrategy() != TypeStrategies.MISSING) {
                return Optional.of(inference);
            }
            return Optional.empty();
        }

        private ResolvedExpression runTypeInference(String name, UnresolvedCallExpression unresolvedCall, TypeInference inference, List<ResolvedExpression> resolvedArgs, @Nullable TypeInferenceUtil.SurroundingInfo surroundingInfo) {
            TypeInferenceUtil.Result inferenceResult = TypeInferenceUtil.runTypeInference((TypeInference)inference, (CallContext)new TableApiCallContext(this.resolutionContext.typeFactory(), name, unresolvedCall.getFunctionDefinition(), resolvedArgs), (TypeInferenceUtil.SurroundingInfo)surroundingInfo);
            List<ResolvedExpression> adaptedArguments = this.adaptArguments(inferenceResult, resolvedArgs);
            return unresolvedCall.resolve(adaptedArguments, inferenceResult.getOutputDataType());
        }

        private ResolvedExpression runLegacyTypeInference(UnresolvedCallExpression unresolvedCall, List<ResolvedExpression> resolvedArgs) {
            PlannerTypeInferenceUtil util = this.resolutionContext.functionLookup().getPlannerTypeInferenceUtil();
            TypeInferenceUtil.Result inferenceResult = util.runTypeInference(unresolvedCall, resolvedArgs);
            List<ResolvedExpression> adaptedArguments = this.adaptArguments(inferenceResult, resolvedArgs);
            return unresolvedCall.resolve(adaptedArguments, inferenceResult.getOutputDataType());
        }

        private List<ResolvedExpression> adaptArguments(TypeInferenceUtil.Result inferenceResult, List<ResolvedExpression> resolvedArgs) {
            return IntStream.range(0, resolvedArgs.size()).mapToObj(pos -> {
                ResolvedExpression argument = (ResolvedExpression)resolvedArgs.get(pos);
                DataType argumentType = argument.getOutputDataType();
                DataType expectedType = (DataType)inferenceResult.getExpectedArgumentTypes().get(pos);
                if (!LogicalTypeCasts.supportsAvoidingCast((LogicalType)argumentType.getLogicalType(), (LogicalType)expectedType.getLogicalType())) {
                    return this.resolutionContext.postResolutionFactory().cast(argument, expectedType);
                }
                return argument;
            }).collect(Collectors.toList());
        }

        private FunctionDefinition prepareInlineUserDefinedFunction(FunctionDefinition definition) {
            if (definition instanceof ScalarFunctionDefinition) {
                ScalarFunctionDefinition sf = (ScalarFunctionDefinition)definition;
                UserDefinedFunctionHelper.prepareInstance((ReadableConfig)this.resolutionContext.configuration(), (UserDefinedFunction)sf.getScalarFunction());
                return new ScalarFunctionDefinition(sf.getName(), sf.getScalarFunction());
            }
            if (definition instanceof TableFunctionDefinition) {
                TableFunctionDefinition tf = (TableFunctionDefinition)definition;
                UserDefinedFunctionHelper.prepareInstance((ReadableConfig)this.resolutionContext.configuration(), (UserDefinedFunction)tf.getTableFunction());
                return new TableFunctionDefinition(tf.getName(), tf.getTableFunction(), tf.getResultType());
            }
            if (definition instanceof AggregateFunctionDefinition) {
                AggregateFunctionDefinition af = (AggregateFunctionDefinition)definition;
                UserDefinedFunctionHelper.prepareInstance((ReadableConfig)this.resolutionContext.configuration(), (UserDefinedFunction)af.getAggregateFunction());
                return new AggregateFunctionDefinition(af.getName(), af.getAggregateFunction(), af.getResultTypeInfo(), af.getAccumulatorTypeInfo());
            }
            if (definition instanceof TableAggregateFunctionDefinition) {
                TableAggregateFunctionDefinition taf = (TableAggregateFunctionDefinition)definition;
                UserDefinedFunctionHelper.prepareInstance((ReadableConfig)this.resolutionContext.configuration(), (UserDefinedFunction)taf.getTableAggregateFunction());
                return new TableAggregateFunctionDefinition(taf.getName(), taf.getTableAggregateFunction(), taf.getResultTypeInfo(), taf.getAccumulatorTypeInfo());
            }
            if (definition instanceof UserDefinedFunction) {
                UserDefinedFunctionHelper.prepareInstance((ReadableConfig)this.resolutionContext.configuration(), (UserDefinedFunction)((UserDefinedFunction)definition));
            }
            return definition;
        }
    }
}

