/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.util.Preconditions;

public abstract class AbstractCatalogTable
implements CatalogTable {
    private final TableSchema tableSchema;
    private final List<String> partitionKeys;
    private final Map<String, String> properties;
    private final String comment;

    public AbstractCatalogTable(TableSchema tableSchema, Map<String, String> properties, String comment) {
        this(tableSchema, new ArrayList<String>(), properties, comment);
    }

    public AbstractCatalogTable(TableSchema tableSchema, List<String> partitionKeys, Map<String, String> properties, String comment) {
        this.tableSchema = (TableSchema)Preconditions.checkNotNull((Object)tableSchema, (String)"tableSchema cannot be null");
        this.partitionKeys = (List)Preconditions.checkNotNull(partitionKeys, (String)"partitionKeys cannot be null");
        this.properties = (Map)Preconditions.checkNotNull(properties, (String)"properties cannot be null");
        Preconditions.checkArgument((boolean)properties.entrySet().stream().allMatch(e -> e.getKey() != null && e.getValue() != null), (Object)"properties cannot have null keys or values");
        this.comment = comment;
    }

    public boolean isPartitioned() {
        return !this.partitionKeys.isEmpty();
    }

    public List<String> getPartitionKeys() {
        return this.partitionKeys;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public TableSchema getSchema() {
        return this.tableSchema;
    }

    public String getComment() {
        return this.comment;
    }
}

