/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.utils;

import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.SetQueryOperation;

@Internal
final class SetOperationFactory {
    private final boolean isStreamingMode;

    public SetOperationFactory(boolean isStreamingMode) {
        this.isStreamingMode = isStreamingMode;
    }

    QueryOperation create(SetQueryOperation.SetQueryOperationType type, QueryOperation left, QueryOperation right, boolean all) {
        this.failIfStreaming(type, all);
        this.validateSetOperation(type, left, right);
        return new SetQueryOperation(left, right, type, all);
    }

    private void validateSetOperation(SetQueryOperation.SetQueryOperationType operationType, QueryOperation left, QueryOperation right) {
        TableSchema rightSchema;
        int rightFieldCount;
        TableSchema leftSchema = left.getTableSchema();
        int leftFieldCount = leftSchema.getFieldCount();
        if (leftFieldCount != (rightFieldCount = (rightSchema = right.getTableSchema()).getFieldCount())) {
            throw new ValidationException(String.format("The %s operation on two tables of different column sizes: %d and %d is not supported", operationType.toString().toLowerCase(), leftFieldCount, rightFieldCount));
        }
        TypeInformation[] leftFieldTypes = leftSchema.getFieldTypes();
        TypeInformation[] rightFieldTypes = rightSchema.getFieldTypes();
        boolean sameSchema = IntStream.range(0, leftFieldCount).allMatch(idx -> leftFieldTypes[idx].equals((Object)rightFieldTypes[idx]));
        if (!sameSchema) {
            throw new ValidationException(String.format("The %s operation on two tables of different schemas: %s and %s is not supported.", operationType.toString().toLowerCase(), leftSchema, rightSchema));
        }
    }

    private void failIfStreaming(SetQueryOperation.SetQueryOperationType type, boolean all) {
        boolean shouldFailInCaseOfStreaming;
        boolean bl = shouldFailInCaseOfStreaming = !all || type != SetQueryOperation.SetQueryOperationType.UNION;
        if (this.isStreamingMode && shouldFailInCaseOfStreaming) {
            throw new ValidationException(String.format("The %s operation on two unbounded tables is currently not supported.", new Object[]{type}));
        }
    }
}

