/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.ResultKind;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.WatermarkSpec;
import org.apache.flink.table.api.internal.CatalogTableSchemaResolver;
import org.apache.flink.table.api.internal.Registration;
import org.apache.flink.table.api.internal.SelectTableSink;
import org.apache.flink.table.api.internal.StatementSetImpl;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.ConnectorCatalogTable;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.QueryOperationCatalogView;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotEmptyException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.ExecutorFactory;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.delegation.PlannerFactory;
import org.apache.flink.table.descriptors.ConnectTableDescriptor;
import org.apache.flink.table.descriptors.ConnectorDescriptor;
import org.apache.flink.table.descriptors.StreamTableDescriptor;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.factories.CatalogFactory;
import org.apache.flink.table.factories.ComponentFactoryService;
import org.apache.flink.table.factories.TableFactoryService;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.module.Module;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.operations.CatalogQueryOperation;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.operations.DescribeTableOperation;
import org.apache.flink.table.operations.ExplainOperation;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.ShowCatalogsOperation;
import org.apache.flink.table.operations.ShowDatabasesOperation;
import org.apache.flink.table.operations.ShowFunctionsOperation;
import org.apache.flink.table.operations.ShowTablesOperation;
import org.apache.flink.table.operations.ShowViewsOperation;
import org.apache.flink.table.operations.TableSourceQueryOperation;
import org.apache.flink.table.operations.UnregisteredSinkModifyOperation;
import org.apache.flink.table.operations.UseCatalogOperation;
import org.apache.flink.table.operations.UseDatabaseOperation;
import org.apache.flink.table.operations.ddl.AddPartitionsOperation;
import org.apache.flink.table.operations.ddl.AlterCatalogFunctionOperation;
import org.apache.flink.table.operations.ddl.AlterDatabaseOperation;
import org.apache.flink.table.operations.ddl.AlterPartitionPropertiesOperation;
import org.apache.flink.table.operations.ddl.AlterTableAddConstraintOperation;
import org.apache.flink.table.operations.ddl.AlterTableDropConstraintOperation;
import org.apache.flink.table.operations.ddl.AlterTableOperation;
import org.apache.flink.table.operations.ddl.AlterTablePropertiesOperation;
import org.apache.flink.table.operations.ddl.AlterTableRenameOperation;
import org.apache.flink.table.operations.ddl.AlterTableSchemaOperation;
import org.apache.flink.table.operations.ddl.AlterViewAsOperation;
import org.apache.flink.table.operations.ddl.AlterViewOperation;
import org.apache.flink.table.operations.ddl.AlterViewPropertiesOperation;
import org.apache.flink.table.operations.ddl.AlterViewRenameOperation;
import org.apache.flink.table.operations.ddl.CreateCatalogFunctionOperation;
import org.apache.flink.table.operations.ddl.CreateCatalogOperation;
import org.apache.flink.table.operations.ddl.CreateDatabaseOperation;
import org.apache.flink.table.operations.ddl.CreateTableOperation;
import org.apache.flink.table.operations.ddl.CreateTempSystemFunctionOperation;
import org.apache.flink.table.operations.ddl.CreateViewOperation;
import org.apache.flink.table.operations.ddl.DropCatalogFunctionOperation;
import org.apache.flink.table.operations.ddl.DropCatalogOperation;
import org.apache.flink.table.operations.ddl.DropDatabaseOperation;
import org.apache.flink.table.operations.ddl.DropPartitionsOperation;
import org.apache.flink.table.operations.ddl.DropTableOperation;
import org.apache.flink.table.operations.ddl.DropTempSystemFunctionOperation;
import org.apache.flink.table.operations.ddl.DropViewOperation;
import org.apache.flink.table.operations.utils.OperationTreeBuilder;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.TableSourceValidation;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.utils.TableSchemaUtils;
import org.apache.flink.types.Row;

@Internal
public class TableEnvironmentImpl
implements TableEnvironmentInternal {
    private static final boolean IS_STREAM_TABLE = true;
    private final CatalogManager catalogManager;
    private final ModuleManager moduleManager;
    private final OperationTreeBuilder operationTreeBuilder;
    private final List<ModifyOperation> bufferedModifyOperations = new ArrayList<ModifyOperation>();
    protected final TableConfig tableConfig;
    protected final Executor execEnv;
    protected final FunctionCatalog functionCatalog;
    protected final Planner planner;
    protected final Parser parser;
    private final boolean isStreamingMode;
    private final ClassLoader userClassLoader;
    private static final String UNSUPPORTED_QUERY_IN_SQL_UPDATE_MSG = "Unsupported SQL query! sqlUpdate() only accepts a single SQL statement of type INSERT, CREATE TABLE, DROP TABLE, ALTER TABLE, USE CATALOG, USE [CATALOG.]DATABASE, CREATE DATABASE, DROP DATABASE, ALTER DATABASE, CREATE FUNCTION, DROP FUNCTION, ALTER FUNCTION, CREATE CATALOG, DROP CATALOG, CREATE VIEW, DROP VIEW.";
    private static final String UNSUPPORTED_QUERY_IN_EXECUTE_SQL_MSG = "Unsupported SQL query! executeSql() only accepts a single SQL statement of type CREATE TABLE, DROP TABLE, ALTER TABLE, CREATE DATABASE, DROP DATABASE, ALTER DATABASE, CREATE FUNCTION, DROP FUNCTION, ALTER FUNCTION, CREATE CATALOG, DROP CATALOG, USE CATALOG, USE [CATALOG.]DATABASE, SHOW CATALOGS, SHOW DATABASES, SHOW TABLES, SHOW FUNCTIONS, CREATE VIEW, DROP VIEW, SHOW VIEWS, INSERT, DESCRIBE.";
    private final Registration registration = new Registration(){

        @Override
        public void createTemporaryTable(String path, CatalogBaseTable table) {
            UnresolvedIdentifier unresolvedIdentifier = TableEnvironmentImpl.this.parser.parseIdentifier(path);
            ObjectIdentifier objectIdentifier = TableEnvironmentImpl.this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
            TableEnvironmentImpl.this.catalogManager.createTemporaryTable(table, objectIdentifier, false);
        }
    };

    protected TableEnvironmentImpl(CatalogManager catalogManager, ModuleManager moduleManager, TableConfig tableConfig, Executor executor, FunctionCatalog functionCatalog, Planner planner, boolean isStreamingMode, ClassLoader userClassLoader) {
        this.catalogManager = catalogManager;
        this.catalogManager.setCatalogTableSchemaResolver(new CatalogTableSchemaResolver(planner.getParser(), isStreamingMode));
        this.moduleManager = moduleManager;
        this.execEnv = executor;
        this.tableConfig = tableConfig;
        this.functionCatalog = functionCatalog;
        this.planner = planner;
        this.parser = planner.getParser();
        this.isStreamingMode = isStreamingMode;
        this.userClassLoader = userClassLoader;
        this.operationTreeBuilder = OperationTreeBuilder.create(tableConfig, functionCatalog.asLookup(this.parser::parseIdentifier), catalogManager.getDataTypeFactory(), path -> {
            try {
                UnresolvedIdentifier unresolvedIdentifier = this.parser.parseIdentifier(path);
                Optional<CatalogQueryOperation> catalogQueryOperation = this.scanInternal(unresolvedIdentifier);
                return catalogQueryOperation.map(t -> ApiExpressionUtils.tableRef(path, t));
            }
            catch (SqlParserException ex) {
                return Optional.empty();
            }
        }, isStreamingMode);
    }

    public static TableEnvironmentImpl create(EnvironmentSettings settings) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        TableConfig tableConfig = new TableConfig();
        ModuleManager moduleManager = new ModuleManager();
        CatalogManager catalogManager = CatalogManager.newBuilder().classLoader(classLoader).config((ReadableConfig)tableConfig.getConfiguration()).defaultCatalog(settings.getBuiltInCatalogName(), (Catalog)new GenericInMemoryCatalog(settings.getBuiltInCatalogName(), settings.getBuiltInDatabaseName())).build();
        FunctionCatalog functionCatalog = new FunctionCatalog(tableConfig, catalogManager, moduleManager);
        Map<String, String> executorProperties = settings.toExecutorProperties();
        Executor executor = ComponentFactoryService.find(ExecutorFactory.class, executorProperties).create(executorProperties);
        Map<String, String> plannerProperties = settings.toPlannerProperties();
        Planner planner = ComponentFactoryService.find(PlannerFactory.class, plannerProperties).create(plannerProperties, executor, tableConfig, functionCatalog, catalogManager);
        return new TableEnvironmentImpl(catalogManager, moduleManager, tableConfig, executor, functionCatalog, planner, settings.isStreamingMode(), classLoader);
    }

    @Override
    public Table fromValues(Object ... values) {
        return this.fromValues(Arrays.asList(values));
    }

    @Override
    public Table fromValues(AbstractDataType<?> rowType, Object ... values) {
        return this.fromValues(rowType, Arrays.asList(values));
    }

    @Override
    public Table fromValues(Expression ... values) {
        return this.createTable(this.operationTreeBuilder.values(values));
    }

    @Override
    public Table fromValues(AbstractDataType<?> rowType, Expression ... values) {
        DataType resolvedDataType = this.catalogManager.getDataTypeFactory().createDataType(rowType);
        return this.createTable(this.operationTreeBuilder.values(resolvedDataType, values));
    }

    @Override
    public Table fromValues(Iterable<?> values) {
        Expression[] exprs = (Expression[])StreamSupport.stream(values.spliterator(), false).map(ApiExpressionUtils::objectToExpression).toArray(Expression[]::new);
        return this.fromValues(exprs);
    }

    @Override
    public Table fromValues(AbstractDataType<?> rowType, Iterable<?> values) {
        Expression[] exprs = (Expression[])StreamSupport.stream(values.spliterator(), false).map(ApiExpressionUtils::objectToExpression).toArray(Expression[]::new);
        return this.fromValues(rowType, exprs);
    }

    @VisibleForTesting
    public Planner getPlanner() {
        return this.planner;
    }

    @Override
    public Table fromTableSource(TableSource<?> source) {
        return this.createTable(new TableSourceQueryOperation(source, false));
    }

    @Override
    public void registerCatalog(String catalogName, Catalog catalog) {
        this.catalogManager.registerCatalog(catalogName, catalog);
    }

    @Override
    public Optional<Catalog> getCatalog(String catalogName) {
        return this.catalogManager.getCatalog(catalogName);
    }

    @Override
    public void loadModule(String moduleName, Module module) {
        this.moduleManager.loadModule(moduleName, module);
    }

    @Override
    public void unloadModule(String moduleName) {
        this.moduleManager.unloadModule(moduleName);
    }

    @Override
    public void registerFunction(String name, ScalarFunction function) {
        this.functionCatalog.registerTempSystemScalarFunction(name, function);
    }

    @Override
    public void createTemporarySystemFunction(String name, Class<? extends UserDefinedFunction> functionClass) {
        UserDefinedFunction functionInstance = UserDefinedFunctionHelper.instantiateFunction(functionClass);
        this.createTemporarySystemFunction(name, functionInstance);
    }

    @Override
    public void createTemporarySystemFunction(String name, UserDefinedFunction functionInstance) {
        this.functionCatalog.registerTemporarySystemFunction(name, (FunctionDefinition)functionInstance, false);
    }

    @Override
    public boolean dropTemporarySystemFunction(String name) {
        return this.functionCatalog.dropTemporarySystemFunction(name, true);
    }

    @Override
    public void createFunction(String path, Class<? extends UserDefinedFunction> functionClass) {
        this.createFunction(path, functionClass, false);
    }

    @Override
    public void createFunction(String path, Class<? extends UserDefinedFunction> functionClass, boolean ignoreIfExists) {
        UnresolvedIdentifier unresolvedIdentifier = this.parser.parseIdentifier(path);
        this.functionCatalog.registerCatalogFunction(unresolvedIdentifier, functionClass, ignoreIfExists);
    }

    @Override
    public boolean dropFunction(String path) {
        UnresolvedIdentifier unresolvedIdentifier = this.parser.parseIdentifier(path);
        return this.functionCatalog.dropCatalogFunction(unresolvedIdentifier, true);
    }

    @Override
    public void createTemporaryFunction(String path, Class<? extends UserDefinedFunction> functionClass) {
        UserDefinedFunction functionInstance = UserDefinedFunctionHelper.instantiateFunction(functionClass);
        this.createTemporaryFunction(path, functionInstance);
    }

    @Override
    public void createTemporaryFunction(String path, UserDefinedFunction functionInstance) {
        UnresolvedIdentifier unresolvedIdentifier = this.parser.parseIdentifier(path);
        this.functionCatalog.registerTemporaryCatalogFunction(unresolvedIdentifier, (FunctionDefinition)functionInstance, false);
    }

    @Override
    public boolean dropTemporaryFunction(String path) {
        UnresolvedIdentifier unresolvedIdentifier = this.parser.parseIdentifier(path);
        return this.functionCatalog.dropTemporaryCatalogFunction(unresolvedIdentifier, true);
    }

    @Override
    public void registerTable(String name, Table table) {
        UnresolvedIdentifier identifier = UnresolvedIdentifier.of((String[])new String[]{name});
        this.createTemporaryView(identifier, table);
    }

    @Override
    public void createTemporaryView(String path, Table view) {
        UnresolvedIdentifier identifier = this.parser.parseIdentifier(path);
        this.createTemporaryView(identifier, view);
    }

    private void createTemporaryView(UnresolvedIdentifier identifier, Table view) {
        if (((TableImpl)view).getTableEnvironment() != this) {
            throw new TableException("Only table API objects that belong to this TableEnvironment can be registered.");
        }
        ObjectIdentifier tableIdentifier = this.catalogManager.qualifyIdentifier(identifier);
        QueryOperation queryOperation = this.qualifyQueryOperation(tableIdentifier, view.getQueryOperation());
        QueryOperationCatalogView tableTable = new QueryOperationCatalogView(queryOperation);
        this.catalogManager.createTemporaryTable((CatalogBaseTable)tableTable, tableIdentifier, false);
    }

    @Override
    public void registerTableSource(String name, TableSource<?> tableSource) {
        this.registerTableSourceInternal(name, tableSource);
    }

    @Override
    public void registerTableSink(String name, String[] fieldNames, TypeInformation<?>[] fieldTypes, TableSink<?> tableSink) {
        this.registerTableSink(name, tableSink.configure(fieldNames, fieldTypes));
    }

    @Override
    public void registerTableSink(String name, TableSink<?> configuredSink) {
        if (configuredSink.getTableSchema().getFieldCount() == 0) {
            throw new TableException("Table schema cannot be empty.");
        }
        this.registerTableSinkInternal(name, configuredSink);
    }

    @Override
    public Table scan(String ... tablePath) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])tablePath);
        return this.scanInternal(unresolvedIdentifier).map(this::createTable).orElseThrow(() -> new ValidationException(String.format("Table %s was not found.", unresolvedIdentifier)));
    }

    @Override
    public Table from(String path) {
        UnresolvedIdentifier unresolvedIdentifier = this.parser.parseIdentifier(path);
        return this.scanInternal(unresolvedIdentifier).map(this::createTable).orElseThrow(() -> new ValidationException(String.format("Table %s was not found.", unresolvedIdentifier)));
    }

    @Override
    public void insertInto(String targetPath, Table table) {
        UnresolvedIdentifier unresolvedIdentifier = this.parser.parseIdentifier(targetPath);
        this.insertIntoInternal(unresolvedIdentifier, table);
    }

    @Override
    public void insertInto(Table table, String sinkPath, String ... sinkPathContinued) {
        ArrayList<String> fullPath = new ArrayList<String>(Arrays.asList(sinkPathContinued));
        fullPath.add(0, sinkPath);
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of(fullPath);
        this.insertIntoInternal(unresolvedIdentifier, table);
    }

    private void insertIntoInternal(UnresolvedIdentifier unresolvedIdentifier, Table table) {
        ObjectIdentifier objectIdentifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        List<ModifyOperation> modifyOperations = Collections.singletonList(new CatalogSinkModifyOperation(objectIdentifier, table.getQueryOperation()));
        this.buffer(modifyOperations);
    }

    private Optional<CatalogQueryOperation> scanInternal(UnresolvedIdentifier identifier) {
        ObjectIdentifier tableIdentifier = this.catalogManager.qualifyIdentifier(identifier);
        return this.catalogManager.getTable(tableIdentifier).map(t -> new CatalogQueryOperation(tableIdentifier, t.getResolvedSchema()));
    }

    @Override
    public ConnectTableDescriptor connect(ConnectorDescriptor connectorDescriptor) {
        return new StreamTableDescriptor(this.registration, connectorDescriptor);
    }

    @Override
    public String[] listCatalogs() {
        return (String[])this.catalogManager.listCatalogs().stream().sorted().toArray(String[]::new);
    }

    @Override
    public String[] listModules() {
        return this.moduleManager.listModules().toArray(new String[0]);
    }

    @Override
    public String[] listDatabases() {
        return this.catalogManager.getCatalog(this.catalogManager.getCurrentCatalog()).get().listDatabases().toArray(new String[0]);
    }

    @Override
    public String[] listTables() {
        return (String[])this.catalogManager.listTables().stream().sorted().toArray(String[]::new);
    }

    @Override
    public String[] listViews() {
        return (String[])this.catalogManager.listViews().stream().sorted().toArray(String[]::new);
    }

    @Override
    public String[] listTemporaryTables() {
        return (String[])this.catalogManager.listTemporaryTables().stream().sorted().toArray(String[]::new);
    }

    @Override
    public String[] listTemporaryViews() {
        return (String[])this.catalogManager.listTemporaryViews().stream().sorted().toArray(String[]::new);
    }

    @Override
    public boolean dropTemporaryTable(String path) {
        UnresolvedIdentifier unresolvedIdentifier = this.parser.parseIdentifier(path);
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        try {
            this.catalogManager.dropTemporaryTable(identifier, false);
            return true;
        }
        catch (ValidationException e) {
            return false;
        }
    }

    @Override
    public boolean dropTemporaryView(String path) {
        UnresolvedIdentifier unresolvedIdentifier = this.parser.parseIdentifier(path);
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        try {
            this.catalogManager.dropTemporaryView(identifier, false);
            return true;
        }
        catch (ValidationException e) {
            return false;
        }
    }

    @Override
    public String[] listUserDefinedFunctions() {
        return this.functionCatalog.getUserDefinedFunctions();
    }

    @Override
    public String[] listFunctions() {
        return this.functionCatalog.getFunctions();
    }

    @Override
    public String explain(Table table) {
        return this.explain(table, false);
    }

    @Override
    public String explain(Table table, boolean extended) {
        return this.planner.explain(Collections.singletonList(table.getQueryOperation()), this.getExplainDetails(extended));
    }

    @Override
    public String explain(boolean extended) {
        List<Operation> operations = this.bufferedModifyOperations.stream().map(o -> o).collect(Collectors.toList());
        return this.planner.explain(operations, this.getExplainDetails(extended));
    }

    @Override
    public String explainSql(String statement, ExplainDetail ... extraDetails) {
        List<Operation> operations = this.parser.parse(statement);
        if (operations.size() != 1) {
            throw new TableException("Unsupported SQL query! explainSql() only accepts a single SQL query.");
        }
        return this.planner.explain(operations, extraDetails);
    }

    @Override
    public String explainInternal(List<Operation> operations, ExplainDetail ... extraDetails) {
        return this.planner.explain(operations, extraDetails);
    }

    @Override
    public String[] getCompletionHints(String statement, int position) {
        return this.planner.getCompletionHints(statement, position);
    }

    @Override
    public Table sqlQuery(String query) {
        List<Operation> operations = this.parser.parse(query);
        if (operations.size() != 1) {
            throw new ValidationException("Unsupported SQL query! sqlQuery() only accepts a single SQL query.");
        }
        Operation operation = operations.get(0);
        if (operation instanceof QueryOperation && !(operation instanceof ModifyOperation)) {
            return this.createTable((QueryOperation)operation);
        }
        throw new ValidationException("Unsupported SQL query! sqlQuery() only accepts a single SQL query of type SELECT, UNION, INTERSECT, EXCEPT, VALUES, and ORDER_BY.");
    }

    @Override
    public TableResult executeSql(String statement) {
        List<Operation> operations = this.parser.parse(statement);
        if (operations.size() != 1) {
            throw new TableException(UNSUPPORTED_QUERY_IN_EXECUTE_SQL_MSG);
        }
        return this.executeOperation(operations.get(0));
    }

    @Override
    public StatementSet createStatementSet() {
        return new StatementSetImpl(this);
    }

    @Override
    public TableResult executeInternal(List<ModifyOperation> operations) {
        List<Transformation<?>> transformations = this.translate(operations);
        List<String> sinkIdentifierNames = this.extractSinkIdentifierNames(operations);
        String jobName = this.getJobName("insert-into_" + String.join((CharSequence)",", sinkIdentifierNames));
        Pipeline pipeline = this.execEnv.createPipeline(transformations, this.tableConfig, jobName);
        try {
            JobClient jobClient = this.execEnv.executeAsync(pipeline);
            TableSchema.Builder builder = TableSchema.builder();
            Object[] affectedRowCounts = new Long[operations.size()];
            for (int i = 0; i < operations.size(); ++i) {
                builder.field(sinkIdentifierNames.get(i), DataTypes.BIGINT());
                affectedRowCounts[i] = -1L;
            }
            return TableResultImpl.builder().jobClient(jobClient).resultKind(ResultKind.SUCCESS_WITH_CONTENT).tableSchema(builder.build()).data(Collections.singletonList(Row.of((Object[])affectedRowCounts))).build();
        }
        catch (Exception e) {
            throw new TableException("Failed to execute sql", (Throwable)e);
        }
    }

    @Override
    public TableResult executeInternal(QueryOperation operation) {
        TableSchema tableSchema = operation.getTableSchema();
        SelectTableSink tableSink = this.planner.createSelectTableSink(tableSchema);
        UnregisteredSinkModifyOperation<Row> sinkOperation = new UnregisteredSinkModifyOperation<Row>(tableSink, operation);
        List<Transformation<?>> transformations = this.translate(Collections.singletonList(sinkOperation));
        String jobName = this.getJobName("collect");
        Pipeline pipeline = this.execEnv.createPipeline(transformations, this.tableConfig, jobName);
        try {
            JobClient jobClient = this.execEnv.executeAsync(pipeline);
            tableSink.setJobClient(jobClient);
            return TableResultImpl.builder().jobClient(jobClient).resultKind(ResultKind.SUCCESS_WITH_CONTENT).tableSchema(tableSchema).data(tableSink.getResultIterator()).setPrintStyle(TableResultImpl.PrintStyle.tableau(30, "(NULL)", true)).build();
        }
        catch (Exception e) {
            throw new TableException("Failed to execute sql", (Throwable)e);
        }
    }

    @Override
    public void sqlUpdate(String stmt) {
        List<Operation> operations = this.parser.parse(stmt);
        if (operations.size() != 1) {
            throw new TableException(UNSUPPORTED_QUERY_IN_SQL_UPDATE_MSG);
        }
        Operation operation = operations.get(0);
        if (operation instanceof ModifyOperation) {
            this.buffer(Collections.singletonList((ModifyOperation)operation));
        } else if (operation instanceof CreateTableOperation || operation instanceof DropTableOperation || operation instanceof AlterTableOperation || operation instanceof CreateViewOperation || operation instanceof DropViewOperation || operation instanceof CreateDatabaseOperation || operation instanceof DropDatabaseOperation || operation instanceof AlterDatabaseOperation || operation instanceof CreateCatalogFunctionOperation || operation instanceof CreateTempSystemFunctionOperation || operation instanceof DropCatalogFunctionOperation || operation instanceof DropTempSystemFunctionOperation || operation instanceof AlterCatalogFunctionOperation || operation instanceof CreateCatalogOperation || operation instanceof DropCatalogOperation || operation instanceof UseCatalogOperation || operation instanceof UseDatabaseOperation) {
            this.executeOperation(operation);
        } else {
            throw new TableException(UNSUPPORTED_QUERY_IN_SQL_UPDATE_MSG);
        }
    }

    private TableResult executeOperation(Operation operation) {
        if (operation instanceof ModifyOperation) {
            return this.executeInternal(Collections.singletonList((ModifyOperation)operation));
        }
        if (operation instanceof CreateTableOperation) {
            CreateTableOperation createTableOperation = (CreateTableOperation)operation;
            if (createTableOperation.isTemporary()) {
                this.catalogManager.createTemporaryTable((CatalogBaseTable)createTableOperation.getCatalogTable(), createTableOperation.getTableIdentifier(), createTableOperation.isIgnoreIfExists());
            } else {
                this.catalogManager.createTable((CatalogBaseTable)createTableOperation.getCatalogTable(), createTableOperation.getTableIdentifier(), createTableOperation.isIgnoreIfExists());
            }
            return TableResultImpl.TABLE_RESULT_OK;
        }
        if (operation instanceof DropTableOperation) {
            DropTableOperation dropTableOperation = (DropTableOperation)operation;
            if (dropTableOperation.isTemporary()) {
                this.catalogManager.dropTemporaryTable(dropTableOperation.getTableIdentifier(), dropTableOperation.isIfExists());
            } else {
                this.catalogManager.dropTable(dropTableOperation.getTableIdentifier(), dropTableOperation.isIfExists());
            }
            return TableResultImpl.TABLE_RESULT_OK;
        }
        if (operation instanceof AlterTableOperation) {
            AlterTableOperation alterTableOperation = (AlterTableOperation)operation;
            Catalog catalog = this.getCatalogOrThrowException(alterTableOperation.getTableIdentifier().getCatalogName());
            String exMsg = this.getDDLOpExecuteErrorMsg(alterTableOperation.asSummaryString());
            try {
                if (alterTableOperation instanceof AlterTableRenameOperation) {
                    AlterTableRenameOperation alterTableRenameOp = (AlterTableRenameOperation)operation;
                    catalog.renameTable(alterTableRenameOp.getTableIdentifier().toObjectPath(), alterTableRenameOp.getNewTableIdentifier().getObjectName(), false);
                } else if (alterTableOperation instanceof AlterTablePropertiesOperation) {
                    AlterTablePropertiesOperation alterTablePropertiesOp = (AlterTablePropertiesOperation)operation;
                    catalog.alterTable(alterTablePropertiesOp.getTableIdentifier().toObjectPath(), (CatalogBaseTable)alterTablePropertiesOp.getCatalogTable(), false);
                } else if (alterTableOperation instanceof AlterTableAddConstraintOperation) {
                    AlterTableAddConstraintOperation addConstraintOP = (AlterTableAddConstraintOperation)operation;
                    CatalogTable oriTable = (CatalogTable)this.catalogManager.getTable(addConstraintOP.getTableIdentifier()).get().getTable();
                    TableSchema.Builder builder = TableSchemaUtils.builderWithGivenSchema((TableSchema)oriTable.getSchema());
                    if (addConstraintOP.getConstraintName().isPresent()) {
                        builder.primaryKey(addConstraintOP.getConstraintName().get(), addConstraintOP.getColumnNames());
                    } else {
                        builder.primaryKey(addConstraintOP.getColumnNames());
                    }
                    CatalogTableImpl newTable = new CatalogTableImpl(builder.build(), oriTable.getPartitionKeys(), oriTable.getOptions(), oriTable.getComment());
                    catalog.alterTable(addConstraintOP.getTableIdentifier().toObjectPath(), (CatalogBaseTable)newTable, false);
                } else if (alterTableOperation instanceof AlterTableDropConstraintOperation) {
                    AlterTableDropConstraintOperation dropConstraintOperation = (AlterTableDropConstraintOperation)operation;
                    CatalogTable oriTable = (CatalogTable)this.catalogManager.getTable(dropConstraintOperation.getTableIdentifier()).get().getTable();
                    CatalogTableImpl newTable = new CatalogTableImpl(TableSchemaUtils.dropConstraint((TableSchema)oriTable.getSchema(), (String)dropConstraintOperation.getConstraintName()), oriTable.getPartitionKeys(), oriTable.getOptions(), oriTable.getComment());
                    catalog.alterTable(dropConstraintOperation.getTableIdentifier().toObjectPath(), (CatalogBaseTable)newTable, false);
                } else if (alterTableOperation instanceof AlterPartitionPropertiesOperation) {
                    AlterPartitionPropertiesOperation alterPartPropsOp = (AlterPartitionPropertiesOperation)operation;
                    catalog.alterPartition(alterPartPropsOp.getTableIdentifier().toObjectPath(), alterPartPropsOp.getPartitionSpec(), alterPartPropsOp.getCatalogPartition(), false);
                } else if (alterTableOperation instanceof AlterTableSchemaOperation) {
                    AlterTableSchemaOperation alterTableSchemaOperation = (AlterTableSchemaOperation)alterTableOperation;
                    catalog.alterTable(alterTableSchemaOperation.getTableIdentifier().toObjectPath(), (CatalogBaseTable)alterTableSchemaOperation.getCatalogTable(), false);
                } else if (alterTableOperation instanceof AddPartitionsOperation) {
                    AddPartitionsOperation addPartitionsOperation = (AddPartitionsOperation)alterTableOperation;
                    List<CatalogPartitionSpec> specs = addPartitionsOperation.getPartitionSpecs();
                    List<CatalogPartition> partitions = addPartitionsOperation.getCatalogPartitions();
                    boolean ifNotExists = addPartitionsOperation.ifNotExists();
                    ObjectPath tablePath = addPartitionsOperation.getTableIdentifier().toObjectPath();
                    for (int i = 0; i < specs.size(); ++i) {
                        catalog.createPartition(tablePath, specs.get(i), partitions.get(i), ifNotExists);
                    }
                } else if (alterTableOperation instanceof DropPartitionsOperation) {
                    DropPartitionsOperation dropPartitionsOperation = (DropPartitionsOperation)alterTableOperation;
                    ObjectPath tablePath = dropPartitionsOperation.getTableIdentifier().toObjectPath();
                    boolean ifExists = dropPartitionsOperation.ifExists();
                    for (CatalogPartitionSpec spec : dropPartitionsOperation.getPartitionSpecs()) {
                        catalog.dropPartition(tablePath, spec, ifExists);
                    }
                }
                return TableResultImpl.TABLE_RESULT_OK;
            }
            catch (TableAlreadyExistException | TableNotExistException e) {
                throw new ValidationException(exMsg, e);
            }
            catch (Exception e) {
                throw new TableException(exMsg, (Throwable)e);
            }
        }
        if (operation instanceof CreateViewOperation) {
            CreateViewOperation createViewOperation = (CreateViewOperation)operation;
            if (createViewOperation.isTemporary()) {
                this.catalogManager.createTemporaryTable((CatalogBaseTable)createViewOperation.getCatalogView(), createViewOperation.getViewIdentifier(), createViewOperation.isIgnoreIfExists());
            } else {
                this.catalogManager.createTable((CatalogBaseTable)createViewOperation.getCatalogView(), createViewOperation.getViewIdentifier(), createViewOperation.isIgnoreIfExists());
            }
            return TableResultImpl.TABLE_RESULT_OK;
        }
        if (operation instanceof DropViewOperation) {
            DropViewOperation dropViewOperation = (DropViewOperation)operation;
            if (dropViewOperation.isTemporary()) {
                this.catalogManager.dropTemporaryView(dropViewOperation.getViewIdentifier(), dropViewOperation.isIfExists());
            } else {
                this.catalogManager.dropView(dropViewOperation.getViewIdentifier(), dropViewOperation.isIfExists());
            }
            return TableResultImpl.TABLE_RESULT_OK;
        }
        if (operation instanceof AlterViewOperation) {
            AlterViewOperation alterViewOperation = (AlterViewOperation)operation;
            Catalog catalog = this.getCatalogOrThrowException(alterViewOperation.getViewIdentifier().getCatalogName());
            String exMsg = this.getDDLOpExecuteErrorMsg(alterViewOperation.asSummaryString());
            try {
                if (alterViewOperation instanceof AlterViewRenameOperation) {
                    AlterViewRenameOperation alterTableRenameOp = (AlterViewRenameOperation)operation;
                    catalog.renameTable(alterTableRenameOp.getViewIdentifier().toObjectPath(), alterTableRenameOp.getNewViewIdentifier().getObjectName(), false);
                } else if (alterViewOperation instanceof AlterViewPropertiesOperation) {
                    AlterViewPropertiesOperation alterTablePropertiesOp = (AlterViewPropertiesOperation)operation;
                    catalog.alterTable(alterTablePropertiesOp.getViewIdentifier().toObjectPath(), (CatalogBaseTable)alterTablePropertiesOp.getCatalogView(), false);
                } else if (alterViewOperation instanceof AlterViewAsOperation) {
                    AlterViewAsOperation alterViewAsOperation = (AlterViewAsOperation)alterViewOperation;
                    catalog.alterTable(alterViewAsOperation.getViewIdentifier().toObjectPath(), (CatalogBaseTable)alterViewAsOperation.getNewView(), false);
                }
                return TableResultImpl.TABLE_RESULT_OK;
            }
            catch (TableAlreadyExistException | TableNotExistException e) {
                throw new ValidationException(exMsg, e);
            }
            catch (Exception e) {
                throw new TableException(exMsg, (Throwable)e);
            }
        }
        if (operation instanceof CreateDatabaseOperation) {
            CreateDatabaseOperation createDatabaseOperation = (CreateDatabaseOperation)operation;
            Catalog catalog = this.getCatalogOrThrowException(createDatabaseOperation.getCatalogName());
            String exMsg = this.getDDLOpExecuteErrorMsg(createDatabaseOperation.asSummaryString());
            try {
                catalog.createDatabase(createDatabaseOperation.getDatabaseName(), createDatabaseOperation.getCatalogDatabase(), createDatabaseOperation.isIgnoreIfExists());
                return TableResultImpl.TABLE_RESULT_OK;
            }
            catch (DatabaseAlreadyExistException e) {
                throw new ValidationException(exMsg, (Throwable)e);
            }
            catch (Exception e) {
                throw new TableException(exMsg, (Throwable)e);
            }
        }
        if (operation instanceof DropDatabaseOperation) {
            DropDatabaseOperation dropDatabaseOperation = (DropDatabaseOperation)operation;
            Catalog catalog = this.getCatalogOrThrowException(dropDatabaseOperation.getCatalogName());
            String exMsg = this.getDDLOpExecuteErrorMsg(dropDatabaseOperation.asSummaryString());
            try {
                catalog.dropDatabase(dropDatabaseOperation.getDatabaseName(), dropDatabaseOperation.isIfExists(), dropDatabaseOperation.isCascade());
                return TableResultImpl.TABLE_RESULT_OK;
            }
            catch (DatabaseNotEmptyException | DatabaseNotExistException e) {
                throw new ValidationException(exMsg, e);
            }
            catch (Exception e) {
                throw new TableException(exMsg, (Throwable)e);
            }
        }
        if (operation instanceof AlterDatabaseOperation) {
            AlterDatabaseOperation alterDatabaseOperation = (AlterDatabaseOperation)operation;
            Catalog catalog = this.getCatalogOrThrowException(alterDatabaseOperation.getCatalogName());
            String exMsg = this.getDDLOpExecuteErrorMsg(alterDatabaseOperation.asSummaryString());
            try {
                catalog.alterDatabase(alterDatabaseOperation.getDatabaseName(), alterDatabaseOperation.getCatalogDatabase(), false);
                return TableResultImpl.TABLE_RESULT_OK;
            }
            catch (DatabaseNotExistException e) {
                throw new ValidationException(exMsg, (Throwable)e);
            }
            catch (Exception e) {
                throw new TableException(exMsg, (Throwable)e);
            }
        }
        if (operation instanceof CreateCatalogFunctionOperation) {
            return this.createCatalogFunction((CreateCatalogFunctionOperation)operation);
        }
        if (operation instanceof CreateTempSystemFunctionOperation) {
            return this.createSystemFunction((CreateTempSystemFunctionOperation)operation);
        }
        if (operation instanceof DropCatalogFunctionOperation) {
            return this.dropCatalogFunction((DropCatalogFunctionOperation)operation);
        }
        if (operation instanceof DropTempSystemFunctionOperation) {
            return this.dropSystemFunction((DropTempSystemFunctionOperation)operation);
        }
        if (operation instanceof AlterCatalogFunctionOperation) {
            return this.alterCatalogFunction((AlterCatalogFunctionOperation)operation);
        }
        if (operation instanceof CreateCatalogOperation) {
            return this.createCatalog((CreateCatalogOperation)operation);
        }
        if (operation instanceof DropCatalogOperation) {
            DropCatalogOperation dropCatalogOperation = (DropCatalogOperation)operation;
            String exMsg = this.getDDLOpExecuteErrorMsg(dropCatalogOperation.asSummaryString());
            try {
                this.catalogManager.unregisterCatalog(dropCatalogOperation.getCatalogName(), dropCatalogOperation.isIfExists());
                return TableResultImpl.TABLE_RESULT_OK;
            }
            catch (CatalogException e) {
                throw new ValidationException(exMsg, (Throwable)e);
            }
        }
        if (operation instanceof UseCatalogOperation) {
            UseCatalogOperation useCatalogOperation = (UseCatalogOperation)operation;
            this.catalogManager.setCurrentCatalog(useCatalogOperation.getCatalogName());
            return TableResultImpl.TABLE_RESULT_OK;
        }
        if (operation instanceof UseDatabaseOperation) {
            UseDatabaseOperation useDatabaseOperation = (UseDatabaseOperation)operation;
            this.catalogManager.setCurrentCatalog(useDatabaseOperation.getCatalogName());
            this.catalogManager.setCurrentDatabase(useDatabaseOperation.getDatabaseName());
            return TableResultImpl.TABLE_RESULT_OK;
        }
        if (operation instanceof ShowCatalogsOperation) {
            return this.buildShowResult("catalog name", this.listCatalogs());
        }
        if (operation instanceof ShowDatabasesOperation) {
            return this.buildShowResult("database name", this.listDatabases());
        }
        if (operation instanceof ShowTablesOperation) {
            return this.buildShowResult("table name", this.listTables());
        }
        if (operation instanceof ShowFunctionsOperation) {
            return this.buildShowResult("function name", this.listFunctions());
        }
        if (operation instanceof ShowViewsOperation) {
            return this.buildShowResult("view name", this.listViews());
        }
        if (operation instanceof ExplainOperation) {
            String explanation = this.planner.explain(Collections.singletonList(((ExplainOperation)operation).getChild()), new ExplainDetail[0]);
            return TableResultImpl.builder().resultKind(ResultKind.SUCCESS_WITH_CONTENT).tableSchema(TableSchema.builder().field("result", DataTypes.STRING()).build()).data(Collections.singletonList(Row.of((Object[])new Object[]{explanation}))).setPrintStyle(TableResultImpl.PrintStyle.rawContent()).build();
        }
        if (operation instanceof DescribeTableOperation) {
            DescribeTableOperation describeTableOperation = (DescribeTableOperation)operation;
            Optional<CatalogManager.TableLookupResult> result = this.catalogManager.getTable(describeTableOperation.getSqlIdentifier());
            if (result.isPresent()) {
                return this.buildDescribeResult(result.get().getResolvedSchema());
            }
            throw new ValidationException(String.format("Tables or views with the identifier '%s' doesn't exist", describeTableOperation.getSqlIdentifier().asSummaryString()));
        }
        if (operation instanceof QueryOperation) {
            return this.executeInternal((QueryOperation)operation);
        }
        throw new TableException(UNSUPPORTED_QUERY_IN_EXECUTE_SQL_MSG);
    }

    private TableResult createCatalog(CreateCatalogOperation operation) {
        String exMsg = this.getDDLOpExecuteErrorMsg(operation.asSummaryString());
        try {
            String catalogName = operation.getCatalogName();
            Map<String, String> properties = operation.getProperties();
            CatalogFactory factory = (CatalogFactory)TableFactoryService.find(CatalogFactory.class, properties, (ClassLoader)this.userClassLoader);
            Catalog catalog = factory.createCatalog(catalogName, properties);
            this.catalogManager.registerCatalog(catalogName, catalog);
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (CatalogException e) {
            throw new ValidationException(exMsg, (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    private TableResult buildShowResult(String columnName, String[] objects) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private TableResult buildDescribeResult(TableSchema schema) {
        Map<String, String> fieldToWatermark = schema.getWatermarkSpecs().stream().collect(Collectors.toMap(WatermarkSpec::getRowtimeAttribute, WatermarkSpec::getWatermarkExpr));
        HashMap fieldToPrimaryKey = new HashMap();
        schema.getPrimaryKey().ifPresent(p -> {
            List columns = p.getColumns();
            columns.forEach(c -> fieldToPrimaryKey.put(c, String.format("PRI(%s)", String.join((CharSequence)", ", columns))));
        });
        Object[][] rows = (Object[][])schema.getTableColumns().stream().map(c -> {
            LogicalType logicalType = c.getType().getLogicalType();
            return new Object[]{c.getName(), StringUtils.removeEnd((String)logicalType.toString(), (String)" NOT NULL"), logicalType.isNullable(), fieldToPrimaryKey.getOrDefault(c.getName(), null), c.getExpr().orElse(null), fieldToWatermark.getOrDefault(c.getName(), null)};
        }).toArray(x$0 -> new Object[x$0][]);
        return this.buildResult(new String[]{"name", "type", "null", "key", "computed column", "watermark"}, new DataType[]{DataTypes.STRING(), DataTypes.STRING(), DataTypes.BOOLEAN(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()}, rows);
    }

    private TableResult buildResult(String[] headers, DataType[] types, Object[][] rows) {
        return TableResultImpl.builder().resultKind(ResultKind.SUCCESS_WITH_CONTENT).tableSchema(TableSchema.builder().fields(headers, types).build()).data(Arrays.stream(rows).map(Row::of).collect(Collectors.toList())).setPrintStyle(TableResultImpl.PrintStyle.tableau(Integer.MAX_VALUE, "", false)).build();
    }

    private List<String> extractSinkIdentifierNames(List<ModifyOperation> operations) {
        ArrayList<String> tableNames = new ArrayList<String>(operations.size());
        HashMap<String, Integer> tableNameToCount = new HashMap<String, Integer>();
        for (ModifyOperation operation : operations) {
            if (operation instanceof CatalogSinkModifyOperation) {
                ObjectIdentifier identifier = ((CatalogSinkModifyOperation)operation).getTableIdentifier();
                String fullName = identifier.asSummaryString();
                tableNames.add(fullName);
                tableNameToCount.put(fullName, tableNameToCount.getOrDefault(fullName, 0) + 1);
                continue;
            }
            throw new UnsupportedOperationException("Unsupported operation: " + operation);
        }
        HashMap tableNameToIndex = new HashMap();
        return tableNames.stream().map(tableName -> {
            if ((Integer)tableNameToCount.get(tableName) == 1) {
                return tableName;
            }
            Integer index = tableNameToIndex.getOrDefault(tableName, 0) + 1;
            tableNameToIndex.put(tableName, index);
            return tableName + "_" + index;
        }).collect(Collectors.toList());
    }

    private String getJobName(String defaultJobName) {
        return this.tableConfig.getConfiguration().getString(PipelineOptions.NAME, defaultJobName);
    }

    private Catalog getCatalogOrThrowException(String catalogName) {
        return this.getCatalog(catalogName).orElseThrow(() -> new ValidationException(String.format("Catalog %s does not exist", catalogName)));
    }

    private String getDDLOpExecuteErrorMsg(String action) {
        return String.format("Could not execute %s", action);
    }

    @Override
    public String getCurrentCatalog() {
        return this.catalogManager.getCurrentCatalog();
    }

    @Override
    public void useCatalog(String catalogName) {
        this.catalogManager.setCurrentCatalog(catalogName);
    }

    @Override
    public String getCurrentDatabase() {
        return this.catalogManager.getCurrentDatabase();
    }

    @Override
    public void useDatabase(String databaseName) {
        this.catalogManager.setCurrentDatabase(databaseName);
    }

    @Override
    public TableConfig getConfig() {
        return this.tableConfig;
    }

    @Override
    public JobExecutionResult execute(String jobName) throws Exception {
        Pipeline pipeline = this.execEnv.createPipeline(this.translateAndClearBuffer(), this.tableConfig, jobName);
        return this.execEnv.execute(pipeline);
    }

    @Override
    public Parser getParser() {
        return this.parser;
    }

    @Override
    public CatalogManager getCatalogManager() {
        return this.catalogManager;
    }

    protected QueryOperation qualifyQueryOperation(ObjectIdentifier identifier, QueryOperation queryOperation) {
        return queryOperation;
    }

    protected void validateTableSource(TableSource<?> tableSource) {
        TableSourceValidation.validateTableSource(tableSource, (TableSchema)tableSource.getTableSchema());
    }

    protected List<Transformation<?>> translateAndClearBuffer() {
        List<Transformation<?>> transformations;
        try {
            transformations = this.translate(this.bufferedModifyOperations);
        }
        finally {
            this.bufferedModifyOperations.clear();
        }
        return transformations;
    }

    private List<Transformation<?>> translate(List<ModifyOperation> modifyOperations) {
        return this.planner.translate(modifyOperations);
    }

    private void buffer(List<ModifyOperation> modifyOperations) {
        this.bufferedModifyOperations.addAll(modifyOperations);
    }

    @VisibleForTesting
    protected ExplainDetail[] getExplainDetails(boolean extended) {
        if (extended) {
            if (this.isStreamingMode) {
                return new ExplainDetail[]{ExplainDetail.ESTIMATED_COST, ExplainDetail.CHANGELOG_MODE};
            }
            return new ExplainDetail[]{ExplainDetail.ESTIMATED_COST};
        }
        return new ExplainDetail[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void registerTableSourceInternal(String name, TableSource<?> tableSource) {
        this.validateTableSource(tableSource);
        ObjectIdentifier objectIdentifier = this.catalogManager.qualifyIdentifier(UnresolvedIdentifier.of((String[])new String[]{name}));
        Optional<CatalogBaseTable> table = this.getTemporaryTable(objectIdentifier);
        if (table.isPresent()) {
            if (!(table.get() instanceof ConnectorCatalogTable)) throw new ValidationException(String.format("Table '%s' already exists. Please choose a different name.", name));
            ConnectorCatalogTable sourceSinkTable = (ConnectorCatalogTable)table.get();
            if (sourceSinkTable.getTableSource().isPresent()) {
                throw new ValidationException(String.format("Table '%s' already exists. Please choose a different name.", name));
            }
            ConnectorCatalogTable sourceAndSink = ConnectorCatalogTable.sourceAndSink(tableSource, sourceSinkTable.getTableSink().get(), false);
            this.catalogManager.dropTemporaryTable(objectIdentifier, false);
            this.catalogManager.createTemporaryTable((CatalogBaseTable)sourceAndSink, objectIdentifier, false);
            return;
        } else {
            ConnectorCatalogTable<?, ?> source = ConnectorCatalogTable.source(tableSource, false);
            this.catalogManager.createTemporaryTable((CatalogBaseTable)source, objectIdentifier, false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void registerTableSinkInternal(String name, TableSink<?> tableSink) {
        ObjectIdentifier objectIdentifier = this.catalogManager.qualifyIdentifier(UnresolvedIdentifier.of((String[])new String[]{name}));
        Optional<CatalogBaseTable> table = this.getTemporaryTable(objectIdentifier);
        if (table.isPresent()) {
            if (!(table.get() instanceof ConnectorCatalogTable)) throw new ValidationException(String.format("Table '%s' already exists. Please choose a different name.", name));
            ConnectorCatalogTable sourceSinkTable = (ConnectorCatalogTable)table.get();
            if (sourceSinkTable.getTableSink().isPresent()) {
                throw new ValidationException(String.format("Table '%s' already exists. Please choose a different name.", name));
            }
            ConnectorCatalogTable sourceAndSink = ConnectorCatalogTable.sourceAndSink(sourceSinkTable.getTableSource().get(), tableSink, false);
            this.catalogManager.dropTemporaryTable(objectIdentifier, false);
            this.catalogManager.createTemporaryTable((CatalogBaseTable)sourceAndSink, objectIdentifier, false);
            return;
        } else {
            ConnectorCatalogTable<?, ?> sink = ConnectorCatalogTable.sink(tableSink, false);
            this.catalogManager.createTemporaryTable((CatalogBaseTable)sink, objectIdentifier, false);
        }
    }

    private Optional<CatalogBaseTable> getTemporaryTable(ObjectIdentifier identifier) {
        return this.catalogManager.getTable(identifier).filter(CatalogManager.TableLookupResult::isTemporary).map(CatalogManager.TableLookupResult::getTable);
    }

    private TableResult createCatalogFunction(CreateCatalogFunctionOperation createCatalogFunctionOperation) {
        String exMsg = this.getDDLOpExecuteErrorMsg(createCatalogFunctionOperation.asSummaryString());
        try {
            if (createCatalogFunctionOperation.isTemporary()) {
                this.functionCatalog.registerTemporaryCatalogFunction(UnresolvedIdentifier.of((List)createCatalogFunctionOperation.getFunctionIdentifier().toList()), createCatalogFunctionOperation.getCatalogFunction(), createCatalogFunctionOperation.isIgnoreIfExists());
            } else {
                Catalog catalog = this.getCatalogOrThrowException(createCatalogFunctionOperation.getFunctionIdentifier().getCatalogName());
                catalog.createFunction(createCatalogFunctionOperation.getFunctionIdentifier().toObjectPath(), createCatalogFunctionOperation.getCatalogFunction(), createCatalogFunctionOperation.isIgnoreIfExists());
            }
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (FunctionAlreadyExistException e) {
            throw new ValidationException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new TableException(exMsg, (Throwable)e);
        }
    }

    private TableResult alterCatalogFunction(AlterCatalogFunctionOperation alterCatalogFunctionOperation) {
        String exMsg = this.getDDLOpExecuteErrorMsg(alterCatalogFunctionOperation.asSummaryString());
        try {
            CatalogFunction function = alterCatalogFunctionOperation.getCatalogFunction();
            if (alterCatalogFunctionOperation.isTemporary()) {
                throw new ValidationException("Alter temporary catalog function is not supported");
            }
            Catalog catalog = this.getCatalogOrThrowException(alterCatalogFunctionOperation.getFunctionIdentifier().getCatalogName());
            catalog.alterFunction(alterCatalogFunctionOperation.getFunctionIdentifier().toObjectPath(), function, alterCatalogFunctionOperation.isIfExists());
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (FunctionNotExistException e) {
            throw new ValidationException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new TableException(exMsg, (Throwable)e);
        }
    }

    private TableResult dropCatalogFunction(DropCatalogFunctionOperation dropCatalogFunctionOperation) {
        String exMsg = this.getDDLOpExecuteErrorMsg(dropCatalogFunctionOperation.asSummaryString());
        try {
            if (dropCatalogFunctionOperation.isTemporary()) {
                this.functionCatalog.dropTempCatalogFunction(dropCatalogFunctionOperation.getFunctionIdentifier(), dropCatalogFunctionOperation.isIfExists());
            } else {
                Catalog catalog = this.getCatalogOrThrowException(dropCatalogFunctionOperation.getFunctionIdentifier().getCatalogName());
                catalog.dropFunction(dropCatalogFunctionOperation.getFunctionIdentifier().toObjectPath(), dropCatalogFunctionOperation.isIfExists());
            }
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (FunctionNotExistException e) {
            throw new ValidationException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new TableException(exMsg, (Throwable)e);
        }
    }

    private TableResult createSystemFunction(CreateTempSystemFunctionOperation operation) {
        String exMsg = this.getDDLOpExecuteErrorMsg(operation.asSummaryString());
        try {
            this.functionCatalog.registerTemporarySystemFunction(operation.getFunctionName(), operation.getFunctionClass(), operation.getFunctionLanguage(), operation.isIgnoreIfExists());
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TableException(exMsg, (Throwable)e);
        }
    }

    private TableResult dropSystemFunction(DropTempSystemFunctionOperation operation) {
        try {
            this.functionCatalog.dropTemporarySystemFunction(operation.getFunctionName(), operation.isIfExists());
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TableException(this.getDDLOpExecuteErrorMsg(operation.asSummaryString()), (Throwable)e);
        }
    }

    protected TableImpl createTable(QueryOperation tableOperation) {
        return TableImpl.createTable(this, tableOperation, this.operationTreeBuilder, this.functionCatalog.asLookup(this.parser::parseIdentifier));
    }

    private static /* synthetic */ String[][] lambda$buildShowResult$14(int x$0) {
        return new String[x$0][];
    }
}

