/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentInformation {
    private static final Logger LOG = LoggerFactory.getLogger(EnvironmentInformation.class);
    public static final String UNKNOWN = "<unknown>";

    public static String getVersion() {
        String version = EnvironmentInformation.class.getPackage().getImplementationVersion();
        return version != null ? version : UNKNOWN;
    }

    public static RevisionInformation getRevisionInformation() {
        String revision = UNKNOWN;
        String commitDate = UNKNOWN;
        try (InputStream propFile = EnvironmentInformation.class.getClassLoader().getResourceAsStream(".version.properties");){
            if (propFile != null) {
                Properties properties = new Properties();
                properties.load(propFile);
                String propRevision = properties.getProperty("git.commit.id.abbrev");
                String propCommitDate = properties.getProperty("git.commit.time");
                revision = propRevision != null ? propRevision : UNKNOWN;
                commitDate = propCommitDate != null ? propCommitDate : UNKNOWN;
            }
        }
        catch (Throwable t) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot determine code revision: Unable to read version property file.", t);
            }
            LOG.info("Cannot determine code revision: Unable to read version property file.");
        }
        return new RevisionInformation(revision, commitDate);
    }

    public static String getUserRunning() {
        try {
            return UserGroupInformation.getCurrentUser().getShortUserName();
        }
        catch (LinkageError e) {
            LOG.debug("Cannot determine user/group information using Hadoop utils. Hadoop classes not loaded or compatible", (Throwable)e);
        }
        catch (Throwable t) {
            LOG.warn("Error while accessing user/group information via Hadoop utils.", t);
        }
        String user = System.getProperty("user.name");
        if (user == null) {
            user = UNKNOWN;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot determine user/group information for the current user.");
            }
        }
        return user;
    }

    public static long getMaxJvmHeapMemory() {
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory == Long.MAX_VALUE) {
            try {
                OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
                Class<?> clazz = Class.forName("com.sun.management.OperatingSystemMXBean");
                Method method = clazz.getMethod("getTotalPhysicalMemorySize", new Class[0]);
                maxMemory = (Long)method.invoke((Object)operatingSystemMXBean, new Object[0]) / 4L;
            }
            catch (Throwable e) {
                throw new RuntimeException("Could not determine the amount of free memory.\nPlease set the maximum memory for the JVM, e.g. -Xmx512M for 512 megabytes.");
            }
        }
        return maxMemory;
    }

    public static long getSizeOfFreeHeapMemoryWithDefrag() {
        System.gc();
        return EnvironmentInformation.getSizeOfFreeHeapMemory();
    }

    public static long getSizeOfFreeHeapMemory() {
        Runtime r = Runtime.getRuntime();
        return EnvironmentInformation.getMaxJvmHeapMemory() - r.totalMemory() + r.freeMemory();
    }

    public static String getJvmVersion() {
        try {
            RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
            return bean.getVmName() + " - " + bean.getVmVendor() + " - " + bean.getSpecVersion() + '/' + bean.getVmVersion();
        }
        catch (Throwable t) {
            return UNKNOWN;
        }
    }

    public static String getJvmStartupOptions() {
        try {
            RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
            StringBuilder bld = new StringBuilder();
            for (String s : bean.getInputArguments()) {
                bld.append(s).append(' ');
            }
            return bld.toString();
        }
        catch (Throwable t) {
            return UNKNOWN;
        }
    }

    public static String[] getJvmStartupOptionsArray() {
        try {
            RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
            List<String> options = bean.getInputArguments();
            return options.toArray(new String[options.size()]);
        }
        catch (Throwable t) {
            return new String[0];
        }
    }

    public static String getTemporaryFileDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    public static long getOpenFileHandlesLimit() {
        Class<?> sunBeanClass;
        try {
            sunBeanClass = Class.forName("com.sun.management.UnixOperatingSystemMXBean");
        }
        catch (ClassNotFoundException e) {
            return -1L;
        }
        try {
            Method fhLimitMethod = sunBeanClass.getMethod("getMaxFileDescriptorCount", new Class[0]);
            Object result = fhLimitMethod.invoke((Object)ManagementFactory.getOperatingSystemMXBean(), new Object[0]);
            return (Long)result;
        }
        catch (Throwable t) {
            LOG.warn("Unexpected error when accessing file handle limit", t);
            return -1L;
        }
    }

    public static void logEnvironmentInfo(Logger log, String componentName, String[] commandLineArgs) {
        if (log.isInfoEnabled()) {
            RevisionInformation rev = EnvironmentInformation.getRevisionInformation();
            String version = EnvironmentInformation.getVersion();
            String user = EnvironmentInformation.getUserRunning();
            String jvmVersion = EnvironmentInformation.getJvmVersion();
            String[] options = EnvironmentInformation.getJvmStartupOptionsArray();
            String javaHome = System.getenv("JAVA_HOME");
            long maxHeapMegabytes = EnvironmentInformation.getMaxJvmHeapMemory() >>> 20;
            log.info("--------------------------------------------------------------------------------");
            log.info(" Starting " + componentName + " (Version: " + version + ", Rev:" + rev.commitId + ", Date:" + rev.commitDate + ")");
            log.info(" Current user: " + user);
            log.info(" JVM: " + jvmVersion);
            log.info(" Maximum heap size: " + maxHeapMegabytes + " MiBytes");
            log.info(" JAVA_HOME: " + (javaHome == null ? "(not set)" : javaHome));
            log.info(" Hadoop version: " + VersionInfo.getVersion());
            if (options.length == 0) {
                log.info(" JVM Options: (none)");
            } else {
                log.info(" JVM Options:");
                for (String s : options) {
                    log.info("    " + s);
                }
            }
            if (commandLineArgs == null || commandLineArgs.length == 0) {
                log.info(" Program Arguments: (none)");
            } else {
                log.info(" Program Arguments:");
                for (String s : commandLineArgs) {
                    log.info("    " + s);
                }
            }
            log.info(" Classpath: " + System.getProperty("java.class.path"));
            log.info("--------------------------------------------------------------------------------");
        }
    }

    private EnvironmentInformation() {
    }

    public static class RevisionInformation {
        public final String commitId;
        public final String commitDate;

        public RevisionInformation(String commitId, String commitDate) {
            this.commitId = commitId;
            this.commitDate = commitDate;
        }
    }
}

