/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.memory;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.api.common.state.FoldingState;
import org.apache.flink.api.common.state.FoldingStateDescriptor;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.ReducingState;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.AbstractStateBackend;
import org.apache.flink.runtime.state.StateHandle;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.apache.flink.runtime.state.memory.MemFoldingState;
import org.apache.flink.runtime.state.memory.MemListState;
import org.apache.flink.runtime.state.memory.MemReducingState;
import org.apache.flink.runtime.state.memory.MemValueState;
import org.apache.flink.runtime.state.memory.SerializedStateHandle;

public class MemoryStateBackend
extends AbstractStateBackend {
    private static final long serialVersionUID = 4109305377809414635L;
    private static final int DEFAULT_MAX_STATE_SIZE = 0x500000;
    private final int maxStateSize;

    public MemoryStateBackend() {
        this(0x500000);
    }

    public MemoryStateBackend(int maxStateSize) {
        this.maxStateSize = maxStateSize;
    }

    @Override
    public void disposeAllStateForCurrentJob() {
    }

    @Override
    public void close() {
    }

    public <N, V> ValueState<V> createValueState(TypeSerializer<N> namespaceSerializer, ValueStateDescriptor<V> stateDesc) throws Exception {
        return new MemValueState(this.keySerializer, namespaceSerializer, stateDesc);
    }

    @Override
    public <N, T> ListState<T> createListState(TypeSerializer<N> namespaceSerializer, ListStateDescriptor<T> stateDesc) throws Exception {
        return new MemListState(this.keySerializer, namespaceSerializer, stateDesc);
    }

    @Override
    public <N, T> ReducingState<T> createReducingState(TypeSerializer<N> namespaceSerializer, ReducingStateDescriptor<T> stateDesc) throws Exception {
        return new MemReducingState(this.keySerializer, namespaceSerializer, stateDesc);
    }

    @Override
    public <N, T, ACC> FoldingState<T, ACC> createFoldingState(TypeSerializer<N> namespaceSerializer, FoldingStateDescriptor<T, ACC> stateDesc) throws Exception {
        return new MemFoldingState(this.keySerializer, namespaceSerializer, stateDesc);
    }

    @Override
    public <S extends Serializable> StateHandle<S> checkpointStateSerializable(S state, long checkpointID, long timestamp) throws Exception {
        SerializedStateHandle<S> handle = new SerializedStateHandle<S>(state);
        MemoryStateBackend.checkSize(handle.getSizeOfSerializedState(), this.maxStateSize);
        return new SerializedStateHandle<S>(state);
    }

    @Override
    public AbstractStateBackend.CheckpointStateOutputStream createCheckpointStateOutputStream(long checkpointID, long timestamp) throws Exception {
        return new MemoryCheckpointOutputStream(this.maxStateSize);
    }

    public String toString() {
        return "MemoryStateBackend (data in heap memory / checkpoints to JobManager)";
    }

    static void checkSize(int size, int maxSize) throws IOException {
        if (size > maxSize) {
            throw new IOException("Size of the state is larger than the maximum permitted memory-backed state. Size=" + size + " , maxSize=" + maxSize + " . Consider using a different state backend, like the File System State backend.");
        }
    }

    public static MemoryStateBackend create() {
        return new MemoryStateBackend();
    }

    public static final class MemoryCheckpointOutputStream
    extends AbstractStateBackend.CheckpointStateOutputStream {
        private final ByteArrayOutputStream os = new ByteArrayOutputStream();
        private final int maxSize;
        private boolean closed;

        public MemoryCheckpointOutputStream(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public void write(int b) {
            this.os.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.os.write(b, off, len);
        }

        @Override
        public void close() {
            this.closed = true;
            this.os.reset();
        }

        @Override
        public StreamStateHandle closeAndGetHandle() throws IOException {
            return new ByteStreamStateHandle(this.closeAndGetBytes());
        }

        public byte[] closeAndGetBytes() throws IOException {
            if (!this.closed) {
                MemoryStateBackend.checkSize(this.os.size(), this.maxSize);
                byte[] bytes = this.os.toByteArray();
                this.close();
                return bytes;
            }
            throw new IllegalStateException("stream has already been closed");
        }
    }
}

