/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.memory;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.runtime.state.KvState;
import org.apache.flink.runtime.state.KvStateSnapshot;
import org.apache.flink.runtime.state.memory.MemoryStateBackend;
import org.apache.flink.runtime.util.DataInputDeserializer;

public abstract class AbstractMemStateSnapshot<K, N, SV, S extends State, SD extends StateDescriptor<S, ?>>
implements KvStateSnapshot<K, N, S, SD, MemoryStateBackend> {
    private static final long serialVersionUID = 1L;
    protected final TypeSerializer<K> keySerializer;
    protected final TypeSerializer<N> namespaceSerializer;
    protected final TypeSerializer<SV> stateSerializer;
    protected final SD stateDesc;
    private final byte[] data;
    private transient boolean closed;

    public AbstractMemStateSnapshot(TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, TypeSerializer<SV> stateSerializer, SD stateDesc, byte[] data) {
        this.keySerializer = keySerializer;
        this.namespaceSerializer = namespaceSerializer;
        this.stateSerializer = stateSerializer;
        this.stateDesc = stateDesc;
        this.data = data;
    }

    public abstract KvState<K, N, S, SD, MemoryStateBackend> createMemState(HashMap<N, Map<K, SV>> var1);

    @Override
    public KvState<K, N, S, SD, MemoryStateBackend> restoreState(MemoryStateBackend stateBackend, TypeSerializer<K> keySerializer, ClassLoader classLoader) throws Exception {
        if (!this.keySerializer.equals(keySerializer)) {
            throw new IllegalArgumentException("Cannot restore the state from the snapshot with the given serializers. State (K/V) was serialized with (" + this.keySerializer + ") now is (" + keySerializer + ")");
        }
        if (this.closed) {
            throw new IOException("snapshot has been closed");
        }
        DataInputDeserializer inView = new DataInputDeserializer(this.data, 0, this.data.length);
        int numKeys = inView.readInt();
        HashMap stateMap = new HashMap(numKeys);
        for (int i = 0; i < numKeys && !this.closed; ++i) {
            Object namespace = this.namespaceSerializer.deserialize((DataInputView)inView);
            int numValues = inView.readInt();
            HashMap<Object, Object> namespaceMap = new HashMap<Object, Object>(numValues);
            stateMap.put(namespace, namespaceMap);
            for (int j = 0; j < numValues; ++j) {
                Object key = keySerializer.deserialize((DataInputView)inView);
                Object value = this.stateSerializer.deserialize((DataInputView)inView);
                namespaceMap.put(key, value);
            }
        }
        if (this.closed) {
            throw new IOException("snapshot has been closed");
        }
        return this.createMemState(stateMap);
    }

    @Override
    public void discardState() {
    }

    @Override
    public long getStateSize() {
        return this.data.length;
    }

    @Override
    public void close() {
        this.closed = true;
    }
}

