/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.memory;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.AbstractHeapState;
import org.apache.flink.runtime.state.KvStateSnapshot;
import org.apache.flink.runtime.state.memory.MemoryStateBackend;
import org.apache.flink.runtime.util.DataOutputSerializer;

public abstract class AbstractMemState<K, N, SV, S extends State, SD extends StateDescriptor<S, ?>>
extends AbstractHeapState<K, N, SV, S, SD, MemoryStateBackend> {
    public AbstractMemState(TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, TypeSerializer<SV> stateSerializer, SD stateDesc) {
        super(keySerializer, namespaceSerializer, stateSerializer, stateDesc);
    }

    public AbstractMemState(TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, TypeSerializer<SV> stateSerializer, SD stateDesc, HashMap<N, Map<K, SV>> state) {
        super(keySerializer, namespaceSerializer, stateSerializer, stateDesc, state);
    }

    public abstract KvStateSnapshot<K, N, S, SD, MemoryStateBackend> createHeapSnapshot(byte[] var1);

    @Override
    public KvStateSnapshot<K, N, S, SD, MemoryStateBackend> snapshot(long checkpointId, long timestamp) throws Exception {
        DataOutputSerializer out = new DataOutputSerializer(Math.max(this.size() * 16, 16));
        out.writeInt(this.state.size());
        for (Map.Entry namespaceState : this.state.entrySet()) {
            Object namespace = namespaceState.getKey();
            this.namespaceSerializer.serialize(namespace, (DataOutputView)out);
            out.writeInt(((Map)namespaceState.getValue()).size());
            for (Map.Entry entry : ((Map)namespaceState.getValue()).entrySet()) {
                this.keySerializer.serialize(entry.getKey(), (DataOutputView)out);
                this.stateSerializer.serialize(entry.getValue(), (DataOutputView)out);
            }
        }
        byte[] bytes = out.getCopyOfBuffer();
        return this.createHeapSnapshot(bytes);
    }
}

