/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.StateBackendFactory;
import org.apache.flink.runtime.state.filesystem.FsStateBackend;

public class FsStateBackendFactory
implements StateBackendFactory<FsStateBackend> {
    public static final String CHECKPOINT_DIRECTORY_URI_CONF_KEY = "state.backend.fs.checkpointdir";
    public static final String MEMORY_THRESHOLD_CONF_KEY = "state.backend.fs.memory-threshold";

    @Override
    public FsStateBackend createFromConfig(Configuration config) throws Exception {
        String checkpointDirURI = config.getString(CHECKPOINT_DIRECTORY_URI_CONF_KEY, null);
        int memoryThreshold = config.getInteger(MEMORY_THRESHOLD_CONF_KEY, 1024);
        if (checkpointDirURI == null) {
            throw new IllegalConfigurationException("Cannot create the file system state backend: The configuration does not specify the checkpoint directory 'state.backend.fs.checkpointdir'");
        }
        try {
            Path path = new Path(checkpointDirURI);
            return new FsStateBackend(path.toUri(), memoryThreshold);
        }
        catch (IllegalArgumentException e) {
            throw new Exception("Cannot initialize File System State Backend with URI '" + checkpointDirURI + '.', e);
        }
    }
}

