/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.Props;
import akka.actor.Props$;
import com.typesafe.config.Config;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logger$;
import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.runtime.akka.AkkaUtils$;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.ZooKeeperCheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointStore;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointStoreFactory;
import org.apache.flink.runtime.clusterframework.FlinkResourceManager;
import org.apache.flink.runtime.clusterframework.standalone.StandaloneResourceManager;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.execution.librarycache.BlobLibraryCacheManager;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategyFactory;
import org.apache.flink.runtime.instance.Hardware;
import org.apache.flink.runtime.instance.InstanceManager;
import org.apache.flink.runtime.jobmanager.JobManager;
import org.apache.flink.runtime.jobmanager.JobManager$;
import org.apache.flink.runtime.jobmanager.JobManagerCliOptions;
import org.apache.flink.runtime.jobmanager.JobManagerMode;
import org.apache.flink.runtime.jobmanager.MemoryArchivist;
import org.apache.flink.runtime.jobmanager.RecoveryMode;
import org.apache.flink.runtime.jobmanager.StandaloneSubmittedJobGraphStore;
import org.apache.flink.runtime.jobmanager.SubmittedJobGraphStore;
import org.apache.flink.runtime.jobmanager.scheduler.Scheduler;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderelection.StandaloneLeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.process.ProcessReaper;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.apache.flink.runtime.taskmanager.TaskManager$;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.ExecutorUtils;
import org.apache.flink.runtime.util.LeaderRetrievalUtils;
import org.apache.flink.runtime.util.NamedThreadFactory;
import org.apache.flink.runtime.util.SignalHandler;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.runtime.webmonitor.WebMonitor;
import org.apache.flink.runtime.webmonitor.WebMonitorUtils;
import org.apache.flink.shaded.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.util.NetUtils;
import org.jboss.netty.channel.ChannelException;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple12;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;
import scopt.OptionParser;
import scopt.Read$;

public final class JobManager$ {
    public static final JobManager$ MODULE$;
    private final Logger LOG;
    private final int STARTUP_FAILURE_RETURN_CODE;
    private final int RUNTIME_FAILURE_RETURN_CODE;
    private final String JOB_MANAGER_NAME;
    private final String ARCHIVE_NAME;

    static {
        new JobManager$();
    }

    public Logger LOG() {
        return this.LOG;
    }

    public int STARTUP_FAILURE_RETURN_CODE() {
        return this.STARTUP_FAILURE_RETURN_CODE;
    }

    public int RUNTIME_FAILURE_RETURN_CODE() {
        return this.RUNTIME_FAILURE_RETURN_CODE;
    }

    public String JOB_MANAGER_NAME() {
        return this.JOB_MANAGER_NAME;
    }

    public String ARCHIVE_NAME() {
        return this.ARCHIVE_NAME;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void main(String[] args) {
        Tuple4 tuple4;
        EnvironmentInformation.logEnvironmentInfo(this.LOG().logger(), "JobManager", args);
        SignalHandler.register(this.LOG().logger());
        Tuple4 tuple42 = this.liftedTree2$1(args);
        if (tuple42 == null) throw new MatchError((Object)tuple42);
        Configuration configuration = (Configuration)tuple42._1();
        JobManagerMode executionMode = (JobManagerMode)((Object)tuple42._2());
        String listeningHost = (String)tuple42._3();
        Iterator listeningPortRange = (Iterator)tuple42._4();
        if (configuration == null) throw new MatchError((Object)tuple42);
        Configuration configuration2 = configuration;
        if (executionMode == null) throw new MatchError((Object)tuple42);
        JobManagerMode jobManagerMode = executionMode;
        if (listeningHost == null) throw new MatchError((Object)tuple42);
        String string = listeningHost;
        if (listeningPortRange == null) throw new MatchError((Object)tuple42);
        Iterator iterator = listeningPortRange;
        Tuple4 tuple43 = tuple4 = new Tuple4((Object)configuration2, (Object)jobManagerMode, (Object)string, (Object)iterator);
        Configuration configuration3 = (Configuration)tuple43._1();
        JobManagerMode executionMode2 = (JobManagerMode)((Object)tuple43._2());
        String listeningHost2 = (String)tuple43._3();
        Iterator listeningPortRange2 = (Iterator)tuple43._4();
        if (listeningHost2 == null) {
            String message = "Config parameter 'jobmanager.rpc.address' is missing (hostname/address to bind JobManager to).";
            this.LOG().error((Function0)new Serializable(message){
                public static final long serialVersionUID = 0L;
                private final String message$1;

                public final String apply() {
                    return this.message$1;
                }
                {
                    this.message$1 = message$1;
                }
            });
            System.exit(this.STARTUP_FAILURE_RETURN_CODE());
        }
        if (!listeningPortRange2.hasNext()) {
            if (ZooKeeperUtils.isZooKeeperRecoveryMode(configuration3)) {
                String message = "Config parameter 'recovery.jobmanager.port' does not specify a valid port range.";
                this.LOG().error((Function0)new Serializable(message){
                    public static final long serialVersionUID = 0L;
                    private final String message$2;

                    public final String apply() {
                        return this.message$2;
                    }
                    {
                        this.message$2 = message$2;
                    }
                });
                System.exit(this.STARTUP_FAILURE_RETURN_CODE());
            } else {
                String message = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Config parameter '"})).s((Seq)Nil$.MODULE$)).append((Object)"jobmanager.rpc.port").append((Object)"' does not specify a valid port.").toString();
                this.LOG().error((Function0)new Serializable(message){
                    public static final long serialVersionUID = 0L;
                    private final String message$3;

                    public final String apply() {
                        return this.message$3;
                    }
                    {
                        this.message$3 = message$3;
                    }
                });
                System.exit(this.STARTUP_FAILURE_RETURN_CODE());
            }
        }
        try {
            if (SecurityUtils.isSecurityEnabled()) {
                this.LOG().info((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Security is enabled. Starting secure JobManager.";
                    }
                });
                SecurityUtils.runSecured(new SecurityUtils.FlinkSecuredRunner<BoxedUnit>(configuration3, executionMode2, listeningHost2, listeningPortRange2){
                    private final Configuration configuration$1;
                    private final JobManagerMode executionMode$1;
                    private final String listeningHost$1;
                    private final Iterator listeningPortRange$1;

                    public void run() {
                        JobManager$.MODULE$.runJobManager(this.configuration$1, this.executionMode$1, this.listeningHost$1, this.listeningPortRange$1);
                    }
                    {
                        this.configuration$1 = configuration$1;
                        this.executionMode$1 = executionMode$1;
                        this.listeningHost$1 = listeningHost$1;
                        this.listeningPortRange$1 = listeningPortRange$1;
                    }
                });
                return;
            } else {
                this.LOG().info((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Security is not enabled. Starting non-authenticated JobManager.";
                    }
                });
                this.runJobManager(configuration3, executionMode2, listeningHost2, listeningPortRange2);
            }
            return;
        }
        catch (Throwable throwable) {
            this.LOG().error((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Failed to run JobManager.";
                }
            }, (Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$14;

                public final Throwable apply() {
                    return this.t$14;
                }
                {
                    this.t$14 = t$14;
                }
            });
            System.exit(this.STARTUP_FAILURE_RETURN_CODE());
        }
    }

    public void runJobManager(Configuration configuration, JobManagerMode executionMode, String listeningAddress, int listeningPort) {
        int numberProcessors = Hardware.getNumberCPUCores();
        ExecutorService futureExecutor = Executors.newFixedThreadPool(numberProcessors, new NamedThreadFactory("jobmanager-future-", "-thread-"));
        ExecutorService ioExecutor = Executors.newFixedThreadPool(numberProcessors, new NamedThreadFactory("jobmanager-io-", "-thread-"));
        FiniteDuration timeout = AkkaUtils$.MODULE$.getTimeout(configuration);
        Tuple5 tuple5 = this.liftedTree3$1(configuration, executionMode, listeningAddress, listeningPort, futureExecutor, ioExecutor);
        if (tuple5 != null) {
            Tuple2 tuple2;
            ActorSystem jobManagerSystem = (ActorSystem)tuple5._1();
            Option webMonitorOption = (Option)tuple5._4();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)jobManagerSystem, (Object)webMonitorOption);
            ActorSystem jobManagerSystem2 = (ActorSystem)tuple22._1();
            Option webMonitorOption2 = (Option)tuple22._2();
            jobManagerSystem2.awaitTermination();
            webMonitorOption2.foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(WebMonitor webMonitor) {
                    try {
                        webMonitor.stop();
                    }
                    catch (Throwable throwable) {
                        JobManager$.MODULE$.LOG().warn((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Could not properly stop the web monitor.";
                            }
                        }, (Function0)new Serializable(this, throwable){
                            public static final long serialVersionUID = 0L;
                            private final Throwable t$15;

                            public final Throwable apply() {
                                return this.t$15;
                            }
                            {
                                this.t$15 = t$15;
                            }
                        });
                    }
                }
            });
            ExecutorUtils.gracefulShutdown(timeout.toMillis(), TimeUnit.MILLISECONDS, futureExecutor, ioExecutor);
            return;
        }
        throw new MatchError((Object)tuple5);
    }

    public void runJobManager(Configuration configuration, JobManagerMode executionMode, String listeningAddress, Iterator<Integer> listeningPortRange) {
        Try result = this.retryOnBindException((Function0)new Serializable(configuration, executionMode, listeningAddress, listeningPortRange){
            public static final long serialVersionUID = 0L;
            private final Configuration configuration$2;
            private final JobManagerMode executionMode$2;
            public final String listeningAddress$1;
            private final Iterator listeningPortRange$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * WARNING - void declaration
             */
            public void apply$mcV$sp() {
                int n;
                ServerSocket socket = NetUtils.createSocketFromPorts((Iterator)this.listeningPortRange$2, (NetUtils.SocketFactory)new NetUtils.SocketFactory(this){
                    private final /* synthetic */ anonfun.2 $outer;

                    public ServerSocket createSocket(int port) {
                        return new ServerSocket(port, 0, InetAddress.getByName(this.$outer.listeningAddress$1));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                if (socket == null) {
                    throw new BindException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to allocate port for JobManager."})).s((Seq)Nil$.MODULE$));
                }
                try {
                    n = socket.getLocalPort();
                }
                catch (Throwable throwable) {
                    void var1_1;
                    var1_1.close();
                    throw throwable;
                }
                socket.close();
                int port = n;
                JobManager$.MODULE$.runJobManager(this.configuration$2, this.executionMode$2, this.listeningAddress$1, port);
            }
            {
                this.configuration$2 = configuration$2;
                this.executionMode$2 = executionMode$2;
                this.listeningAddress$1 = listeningAddress$1;
                this.listeningPortRange$2 = listeningPortRange$2;
            }
        }, (Function0<Object>)new Serializable(listeningPortRange){
            public static final long serialVersionUID = 0L;
            private final Iterator listeningPortRange$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.listeningPortRange$2.hasNext();
            }
            {
                this.listeningPortRange$2 = listeningPortRange$2;
            }
        }, 5000L);
        Try try_ = result;
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable f = failure.exception();
            throw f;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public <T> Try<T> retryOnBindException(Function0<T> fn, Function0<Object> stopCond, long maxSleepBetweenRetries) {
        Try try_;
        block5: {
            Try try_2;
            block6: {
                Failure failure;
                block7: {
                    Exception exception;
                    while (true) {
                        Throwable x;
                        boolean bl = false;
                        Failure failure2 = null;
                        try_2 = Try$.MODULE$.apply(fn);
                        if (try_2 instanceof Failure) {
                            bl = true;
                            failure2 = (Failure)try_2;
                            Throwable x2 = failure2.exception();
                            if (x2 instanceof BindException) {
                                if (stopCond.apply$mcZ$sp()) {
                                    try_ = new Failure((Throwable)new RuntimeException("Unable to do further retries starting the actor system"));
                                    break block5;
                                }
                                this.sleepBeforeRetry$1(maxSleepBetweenRetries);
                                maxSleepBetweenRetries = this.retryOnBindException$default$3();
                                continue;
                            }
                        }
                        if (!bl || !((x = failure2.exception()) instanceof Exception)) break block6;
                        exception = (Exception)x;
                        Throwable throwable = exception.getCause();
                        if (!(throwable instanceof ChannelException)) break;
                        if (stopCond.apply$mcZ$sp()) {
                            failure = new Failure((Throwable)new RuntimeException("Unable to do further retries starting the actor system"));
                            break block7;
                        }
                        this.sleepBeforeRetry$1(maxSleepBetweenRetries);
                        maxSleepBetweenRetries = this.retryOnBindException$default$3();
                    }
                    failure = new Failure((Throwable)exception);
                }
                try_ = failure;
                break block5;
            }
            try_ = try_2;
        }
        return try_;
    }

    public <T> long retryOnBindException$default$3() {
        return 0L;
    }

    public Tuple5<ActorSystem, ActorRef, ActorRef, Option<WebMonitor>, Option<ActorRef>> startActorSystemAndJobManagerActors(Configuration configuration, JobManagerMode executionMode, String listeningAddress, int listeningPort, Executor futureExecutor, Executor ioExecutor, Class<? extends JobManager> jobManagerClass, Class<? extends MemoryArchivist> archiveClass, Option<Class<? extends FlinkResourceManager<?>>> resourceManagerClass) {
        None$ none$;
        Address address;
        ActorSystem jobManagerSystem;
        this.LOG().info((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting JobManager";
            }
        });
        String hostPortUrl = NetUtils.hostAndPortToUrlString((String)listeningAddress, (int)listeningPort);
        this.LOG().info((Function0)new Serializable(hostPortUrl){
            public static final long serialVersionUID = 0L;
            private final String hostPortUrl$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting JobManager actor system at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hostPortUrl$1}));
            }
            {
                this.hostPortUrl$1 = hostPortUrl$1;
            }
        });
        try {
            Config akkaConfig = AkkaUtils$.MODULE$.getAkkaConfig(configuration, (Option<Tuple2<String, Object>>)new Some((Object)new Tuple2((Object)listeningAddress, (Object)BoxesRunTime.boxToInteger((int)listeningPort))));
            if (this.LOG().isDebugEnabled()) {
                this.LOG().debug((Function0)new Serializable(akkaConfig){
                    public static final long serialVersionUID = 0L;
                    private final Config akkaConfig$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Using akka configuration\n ").append((Object)this.akkaConfig$1).toString();
                    }
                    {
                        this.akkaConfig$1 = akkaConfig$1;
                    }
                });
            }
            jobManagerSystem = AkkaUtils$.MODULE$.createActorSystem(akkaConfig);
            address = AkkaUtils$.MODULE$.getAddress(jobManagerSystem);
        }
        catch (Throwable throwable) {
            Throwable cause;
            if (throwable instanceof ChannelException && (cause = throwable.getCause()) != null && throwable.getCause() instanceof BindException) {
                String address2 = new StringBuilder().append((Object)listeningAddress).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)listeningPort)).toString();
                throw new Exception(new StringBuilder().append((Object)"Unable to create JobManager at address ").append((Object)address2).append((Object)" - ").append((Object)cause.getMessage()).toString(), throwable);
            }
            throw new Exception("Could not create JobManager actor system", throwable);
        }
        configuration.setString("jobmanager.rpc.address", (String)address.host().get());
        configuration.setInteger("jobmanager.rpc.port", BoxesRunTime.unboxToInt((Object)address.port().get()));
        if (configuration.getInteger("jobmanager.web.port", 0) >= 0) {
            this.LOG().info((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Starting JobManager web frontend";
                }
            });
            LeaderRetrievalService leaderRetrievalService = LeaderRetrievalUtils.createLeaderRetrievalService(configuration);
            WebMonitor webServer = WebMonitorUtils.startWebRuntimeMonitor(configuration, leaderRetrievalService, jobManagerSystem);
            none$ = Option$.MODULE$.apply((Object)webServer);
        } else {
            none$ = None$.MODULE$;
        }
        None$ webMonitor = none$;
        webMonitor.foreach((Function1)new Serializable(configuration){
            public static final long serialVersionUID = 0L;
            private final Configuration configuration$4;

            public final void apply(WebMonitor monitor) {
                this.configuration$4.setInteger("jobmanager.web.port", monitor.getServerPort());
            }
            {
                this.configuration$4 = configuration$4;
            }
        });
        try {
            Tuple2<ActorRef, ActorRef> tuple2;
            block15: {
                Option<Class<? extends FlinkResourceManager<?>>> option;
                block18: {
                    None$ none$2;
                    ActorRef archive;
                    ActorRef jobManager;
                    block17: {
                        block16: {
                            BoxedUnit boxedUnit;
                            Tuple2 tuple22;
                            this.LOG().info((Function0)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Starting JobManager actor";
                                }
                            });
                            tuple2 = this.startJobManagerActors(configuration, jobManagerSystem, futureExecutor, ioExecutor, jobManagerClass, archiveClass);
                            if (tuple2 == null) break block15;
                            ActorRef jobManager2 = (ActorRef)tuple2._1();
                            ActorRef archive2 = (ActorRef)tuple2._2();
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)jobManager2, (Object)archive2);
                            jobManager = (ActorRef)tuple23._1();
                            archive = (ActorRef)tuple23._2();
                            this.LOG().debug((Function0)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Starting JobManager process reaper";
                                }
                            });
                            jobManagerSystem.actorOf(Props$.MODULE$.apply(ProcessReaper.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobManager, this.LOG().logger(), BoxesRunTime.boxToInteger((int)this.RUNTIME_FAILURE_RETURN_CODE())})), "JobManager_Process_Reaper");
                            JobManagerMode jobManagerMode = executionMode;
                            JobManagerMode jobManagerMode2 = JobManagerMode.LOCAL;
                            if (!(jobManagerMode != null ? !((Object)((Object)jobManagerMode)).equals((Object)jobManagerMode2) : jobManagerMode2 != null)) {
                                this.LOG().info((Function0)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "Starting embedded TaskManager for JobManager's LOCAL execution mode";
                                    }
                                });
                                ActorRef taskManagerActor = TaskManager$.MODULE$.startTaskManagerComponentsAndActor(configuration, ResourceID.generate(), jobManagerSystem, listeningAddress, (Option<String>)new Some((Object)TaskManager$.MODULE$.TASK_MANAGER_NAME()), (Option<LeaderRetrievalService>)None$.MODULE$, true, TaskManager.class);
                                this.LOG().debug((Function0)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "Starting TaskManager process reaper";
                                    }
                                });
                                boxedUnit = jobManagerSystem.actorOf(Props$.MODULE$.apply(ProcessReaper.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskManagerActor, this.LOG().logger(), BoxesRunTime.boxToInteger((int)this.RUNTIME_FAILURE_RETURN_CODE())})), "TaskManager_Process_Reaper");
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            webMonitor.foreach((Function1)new Serializable(configuration){
                                public static final long serialVersionUID = 0L;
                                private final Configuration configuration$4;

                                public final void apply(WebMonitor monitor) {
                                    String jobManagerAkkaUrl = JobManager$.MODULE$.getRemoteJobManagerAkkaURL(this.configuration$4);
                                    monitor.start(jobManagerAkkaUrl);
                                }
                                {
                                    this.configuration$4 = configuration$4;
                                }
                            });
                            option = resourceManagerClass;
                            if (!(option instanceof Some)) break block16;
                            Some some = (Some)option;
                            Class rmClass = (Class)some.x();
                            this.LOG().debug((Function0)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Starting Resource manager actor";
                                }
                            });
                            none$2 = Option$.MODULE$.apply((Object)FlinkResourceManager.startResourceManagerActors(configuration, jobManagerSystem, LeaderRetrievalUtils.createLeaderRetrievalService(configuration), rmClass));
                            break block17;
                        }
                        None$ none$3 = None$.MODULE$;
                        Option<Class<? extends FlinkResourceManager<?>>> option2 = option;
                        if (none$3 != null ? !none$3.equals(option2) : option2 != null) break block18;
                        this.LOG().info((Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Resource Manager class not provided. No resource manager will be started.";
                            }
                        });
                        none$2 = None$.MODULE$;
                    }
                    None$ resourceManager = none$2;
                    return new Tuple5((Object)jobManagerSystem, (Object)jobManager, (Object)archive, (Object)webMonitor, (Object)resourceManager);
                }
                throw new MatchError(option);
            }
            throw new MatchError(tuple2);
        }
        catch (Throwable throwable) {
            this.LOG().error((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error while starting up JobManager";
                }
            }, (Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$16;

                public final Throwable apply() {
                    return this.t$16;
                }
                {
                    this.t$16 = t$16;
                }
            });
            try {
                jobManagerSystem.shutdown();
            }
            catch (Throwable throwable2) {
                this.LOG().warn((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Could not cleanly shut down actor system";
                    }
                }, (Function0)new Serializable(throwable2){
                    public static final long serialVersionUID = 0L;
                    private final Throwable tt$2;

                    public final Throwable apply() {
                        return this.tt$2;
                    }
                    {
                        this.tt$2 = tt$2;
                    }
                });
            }
            throw throwable;
        }
    }

    public Tuple4<Configuration, JobManagerMode, String, Iterator<Integer>> parseArgs(String[] args) {
        String string;
        Configuration configuration;
        JobManagerCliOptions config;
        block9: {
            OptionParser<JobManagerCliOptions> parser = new OptionParser<JobManagerCliOptions>(){
                {
                    this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Flink JobManager"}));
                    this.opt("configDir", Read$.MODULE$.stringRead()).action((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final JobManagerCliOptions apply(String arg, JobManagerCliOptions conf) {
                            conf.setConfigDir(arg);
                            return conf;
                        }
                    }).text("The configuration directory.");
                    this.opt("executionMode", Read$.MODULE$.stringRead()).action((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final JobManagerCliOptions apply(String arg, JobManagerCliOptions conf) {
                            conf.setJobManagerMode(arg);
                            return conf;
                        }
                    }).text("The execution mode of the JobManager (CLUSTER / LOCAL)");
                    this.opt("host", Read$.MODULE$.stringRead()).optional().action((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final JobManagerCliOptions apply(String arg, JobManagerCliOptions conf) {
                            conf.setHost(arg);
                            return conf;
                        }
                    }).text("Network address for communication with the job manager");
                    this.opt("webui-port", Read$.MODULE$.intRead()).optional().action((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final JobManagerCliOptions apply(int arg, JobManagerCliOptions conf) {
                            conf.setWebUIPort(arg);
                            return conf;
                        }
                    }).text("Port for the UI web server");
                }
            };
            config = (JobManagerCliOptions)parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)new JobManagerCliOptions()).getOrElse((Function0)new Serializable(args, (OptionParser)parser){
                public static final long serialVersionUID = 0L;
                private final String[] args$2;
                private final OptionParser parser$1;

                public final Nothing$ apply() {
                    throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid command line arguments: ", ". Usage: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.args$2).mkString(" "), this.parser$1.usage()})));
                }
                {
                    this.args$2 = args$2;
                    this.parser$1 = parser$1;
                }
            });
            String configDir = config.getConfigDir();
            if (configDir == null) {
                throw new Exception("Missing parameter '--configDir'");
            }
            if (config.getJobManagerMode() == null) {
                throw new Exception("Missing parameter '--executionMode'");
            }
            this.LOG().info((Function0)new Serializable(configDir){
                public static final long serialVersionUID = 0L;
                private final String configDir$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Loading configuration from ").append((Object)this.configDir$1).toString();
                }
                {
                    this.configDir$1 = configDir$1;
                }
            });
            GlobalConfiguration.loadConfiguration((String)configDir);
            configuration = GlobalConfiguration.getConfiguration();
            try {
                FileSystem.setDefaultScheme((Configuration)configuration);
                if (!new File(configDir).isDirectory()) break block9;
            }
            catch (IOException iOException) {
                throw new Exception("Error while setting the default filesystem scheme from configuration.", iOException);
            }
            configuration.setString("flink.base.dir.path", new StringBuilder().append((Object)configDir).append((Object)"/..").toString());
        }
        if (config.getWebUIPort() >= 0) {
            configuration.setInteger("jobmanager.web.port", config.getWebUIPort());
        }
        if (config.getHost() != null) {
            configuration.setString("jobmanager.rpc.address", config.getHost());
        }
        String host = configuration.getString("jobmanager.rpc.address", null);
        if (ZooKeeperUtils.isZooKeeperRecoveryMode(configuration)) {
            this.LOG().info((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Starting JobManager with high-availability";
                }
            });
            configuration.setInteger("jobmanager.rpc.port", 0);
            string = configuration.getString("recovery.jobmanager.port", "0");
        } else {
            this.LOG().info((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Starting JobManager without high-availability";
                }
            });
            int listeningPort = configuration.getInteger("jobmanager.rpc.port", 6123);
            if (listeningPort <= 0 || listeningPort >= 65536) {
                String message = "Config parameter 'jobmanager.rpc.port' is invalid, it must be greater than 0 and less than 65536.";
                this.LOG().error((Function0)new Serializable(message){
                    public static final long serialVersionUID = 0L;
                    private final String message$4;

                    public final String apply() {
                        return this.message$4;
                    }
                    {
                        this.message$4 = message$4;
                    }
                });
                System.exit(this.STARTUP_FAILURE_RETURN_CODE());
            }
            string = String.valueOf(listeningPort);
        }
        String portRange = string;
        JobManagerMode executionMode = config.getJobManagerMode();
        String hostUrl = NetUtils.ipAddressToUrlString((InetAddress)InetAddress.getByName(host));
        this.LOG().info((Function0)new Serializable(portRange, executionMode, hostUrl){
            public static final long serialVersionUID = 0L;
            private final String portRange$1;
            private final JobManagerMode executionMode$4;
            private final String hostUrl$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting JobManager on ", ":", " with execution mode ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hostUrl$1, this.portRange$1, this.executionMode$4}));
            }
            {
                this.portRange$1 = portRange$1;
                this.executionMode$4 = executionMode$4;
                this.hostUrl$1 = hostUrl$1;
            }
        });
        Iterator portRangeIterator = NetUtils.getPortRangeFromString((String)portRange);
        return new Tuple4((Object)configuration, (Object)executionMode, (Object)host, (Object)portRangeIterator);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple12<InstanceManager, Scheduler, BlobLibraryCacheManager, RestartStrategyFactory, FiniteDuration, Object, LeaderElectionService, SubmittedJobGraphStore, CheckpointRecoveryFactory, SavepointStore, FiniteDuration, Option<MetricRegistry>> createJobManagerComponents(Configuration configuration, Executor futureExecutor, Executor ioExecutor, Option<LeaderElectionService> leaderElectionServiceOption) {
        FiniteDuration finiteDuration;
        Tuple3 tuple3;
        Tuple3 tuple32;
        FiniteDuration timeout = AkkaUtils$.MODULE$.getTimeout(configuration);
        long cleanupInterval = configuration.getLong("library-cache-manager.cleanup.interval", 3600L) * 1000L;
        RestartStrategyFactory restartStrategy = RestartStrategyFactory.createRestartStrategyFactory(configuration);
        int archiveCount = configuration.getInteger("jobmanager.web.history", 5);
        BlobServer blobServer = null;
        InstanceManager instanceManager = null;
        Scheduler scheduler = null;
        BlobLibraryCacheManager libraryCacheManager = null;
        try {
            blobServer = new BlobServer(configuration);
            instanceManager = new InstanceManager();
            scheduler = new Scheduler((ExecutionContext)ExecutionContext$.MODULE$.fromExecutor(futureExecutor));
            libraryCacheManager = new BlobLibraryCacheManager(blobServer, cleanupInterval);
            instanceManager.addInstanceListener(scheduler);
        }
        catch (Throwable throwable) {
            if (libraryCacheManager != null) {
                libraryCacheManager.shutdown();
            }
            if (scheduler != null) {
                scheduler.shutdown();
            }
            if (instanceManager != null) {
                instanceManager.shutdown();
            }
            if (blobServer == null) throw throwable;
            blobServer.shutdown();
            throw throwable;
        }
        RecoveryMode recoveryMode = RecoveryMode.fromConfig(configuration);
        RecoveryMode recoveryMode2 = RecoveryMode.STANDALONE;
        RecoveryMode recoveryMode3 = recoveryMode;
        if (!(recoveryMode2 != null ? !((Object)((Object)recoveryMode2)).equals((Object)recoveryMode3) : recoveryMode3 != null)) {
            LeaderElectionService leaderElectionService;
            Option<LeaderElectionService> option = leaderElectionServiceOption;
            if (option instanceof Some) {
                LeaderElectionService les;
                Some some = (Some)option;
                leaderElectionService = les = (LeaderElectionService)some.x();
            } else {
                None$ none$ = None$.MODULE$;
                Option<LeaderElectionService> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) throw new MatchError(option);
                leaderElectionService = new StandaloneLeaderElectionService();
            }
            LeaderElectionService leaderElectionService2 = leaderElectionService;
            tuple32 = new Tuple3((Object)leaderElectionService2, (Object)new StandaloneSubmittedJobGraphStore(), (Object)new StandaloneCheckpointRecoveryFactory());
        } else {
            LeaderElectionService leaderElectionService;
            RecoveryMode recoveryMode4 = RecoveryMode.ZOOKEEPER;
            RecoveryMode recoveryMode5 = recoveryMode;
            if (recoveryMode4 != null ? !((Object)((Object)recoveryMode4)).equals((Object)recoveryMode5) : recoveryMode5 != null) throw new MatchError((Object)recoveryMode);
            CuratorFramework client = ZooKeeperUtils.startCuratorFramework(configuration);
            Option<LeaderElectionService> option = leaderElectionServiceOption;
            if (option instanceof Some) {
                LeaderElectionService les;
                Some some = (Some)option;
                leaderElectionService = les = (LeaderElectionService)some.x();
            } else {
                None$ none$ = None$.MODULE$;
                Option<LeaderElectionService> option3 = option;
                if (none$ != null ? !none$.equals(option3) : option3 != null) throw new MatchError(option);
                leaderElectionService = ZooKeeperUtils.createLeaderElectionService(client, configuration);
            }
            LeaderElectionService leaderElectionService3 = leaderElectionService;
            tuple32 = new Tuple3((Object)leaderElectionService3, (Object)ZooKeeperUtils.createSubmittedJobGraphs(client, configuration, ioExecutor), (Object)new ZooKeeperCheckpointRecoveryFactory(client, configuration, ioExecutor));
        }
        Tuple3 tuple33 = tuple32;
        if (tuple33 == null) throw new MatchError((Object)tuple33);
        LeaderElectionService leaderElectionService = (LeaderElectionService)tuple33._1();
        SubmittedJobGraphStore submittedJobGraphs = (SubmittedJobGraphStore)tuple33._2();
        CheckpointRecoveryFactory checkpointRecoveryFactory = (CheckpointRecoveryFactory)tuple33._3();
        Tuple3 tuple34 = tuple3 = new Tuple3((Object)leaderElectionService, (Object)submittedJobGraphs, (Object)checkpointRecoveryFactory);
        LeaderElectionService leaderElectionService4 = (LeaderElectionService)tuple34._1();
        SubmittedJobGraphStore submittedJobGraphs2 = (SubmittedJobGraphStore)tuple34._2();
        CheckpointRecoveryFactory checkpointRecoveryFactory2 = (CheckpointRecoveryFactory)tuple34._3();
        SavepointStore savepointStore = SavepointStoreFactory.createFromConfig(configuration);
        String jobRecoveryTimeoutStr = configuration.getString("recovery.job.delay", "");
        if (jobRecoveryTimeoutStr == null || jobRecoveryTimeoutStr.isEmpty()) {
            finiteDuration = timeout;
        } else {
            finiteDuration = FiniteDuration$.MODULE$.apply(Duration$.MODULE$.apply(jobRecoveryTimeoutStr).toMillis(), TimeUnit.MILLISECONDS);
        }
        FiniteDuration jobRecoveryTimeout = finiteDuration;
        None$ none$ = Option$.MODULE$.apply((Object)new MetricRegistry(configuration));
        catch (NumberFormatException numberFormatException) {
            throw new Exception(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid config value for ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"recovery.job.delay"}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ". Value must be a valid duration (such as '10 s' or '1 min')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobRecoveryTimeoutStr}))).toString());
        }
        catch (Exception exception) {
            none$ = None$.MODULE$;
        }
        None$ metricRegistry = none$;
        return new Tuple12((Object)instanceManager, (Object)scheduler, (Object)libraryCacheManager, (Object)restartStrategy, (Object)timeout, (Object)BoxesRunTime.boxToInteger((int)archiveCount), (Object)leaderElectionService4, (Object)submittedJobGraphs2, (Object)checkpointRecoveryFactory2, (Object)savepointStore, (Object)jobRecoveryTimeout, (Object)metricRegistry);
    }

    public Tuple2<ActorRef, ActorRef> startJobManagerActors(Configuration configuration, ActorSystem actorSystem, Executor futureExecutor, Executor ioExecutor, Class<? extends JobManager> jobManagerClass, Class<? extends MemoryArchivist> archiveClass) {
        return this.startJobManagerActors(configuration, actorSystem, futureExecutor, ioExecutor, (Option<String>)new Some((Object)this.JOB_MANAGER_NAME()), (Option<String>)new Some((Object)this.ARCHIVE_NAME()), jobManagerClass, archiveClass);
    }

    public Tuple2<ActorRef, ActorRef> startJobManagerActors(Configuration configuration, ActorSystem actorSystem, Executor futureExecutor, Executor ioExecutor, Option<String> jobManagerActorName, Option<String> archiveActorName, Class<? extends JobManager> jobManagerClass, Class<? extends MemoryArchivist> archiveClass) {
        Tuple12<InstanceManager, Scheduler, BlobLibraryCacheManager, RestartStrategyFactory, FiniteDuration, Object, LeaderElectionService, SubmittedJobGraphStore, CheckpointRecoveryFactory, SavepointStore, FiniteDuration, Option<MetricRegistry>> tuple12;
        block2: {
            Option<String> option;
            block5: {
                Option<String> option2;
                block8: {
                    ActorRef actorRef;
                    ActorRef archive;
                    block7: {
                        Props jobManagerProps;
                        block6: {
                            ActorRef actorRef2;
                            Option metricsRegistry;
                            FiniteDuration jobRecoveryTimeout;
                            SavepointStore savepointStore;
                            CheckpointRecoveryFactory checkpointRecoveryFactory;
                            SubmittedJobGraphStore submittedJobGraphs;
                            LeaderElectionService leaderElectionService;
                            FiniteDuration timeout;
                            RestartStrategyFactory restartStrategy;
                            BlobLibraryCacheManager libraryCacheManager;
                            Scheduler scheduler;
                            InstanceManager instanceManager;
                            block4: {
                                Props archiveProps;
                                block3: {
                                    Tuple12 tuple122;
                                    tuple12 = this.createJobManagerComponents(configuration, futureExecutor, ioExecutor, (Option<LeaderElectionService>)None$.MODULE$);
                                    if (tuple12 == null) break block2;
                                    InstanceManager instanceManager2 = (InstanceManager)tuple12._1();
                                    Scheduler scheduler2 = (Scheduler)tuple12._2();
                                    BlobLibraryCacheManager libraryCacheManager2 = (BlobLibraryCacheManager)tuple12._3();
                                    RestartStrategyFactory restartStrategy2 = (RestartStrategyFactory)tuple12._4();
                                    FiniteDuration timeout2 = (FiniteDuration)tuple12._5();
                                    int archiveCount = BoxesRunTime.unboxToInt((Object)tuple12._6());
                                    LeaderElectionService leaderElectionService2 = (LeaderElectionService)tuple12._7();
                                    SubmittedJobGraphStore submittedJobGraphs2 = (SubmittedJobGraphStore)tuple12._8();
                                    CheckpointRecoveryFactory checkpointRecoveryFactory2 = (CheckpointRecoveryFactory)tuple12._9();
                                    SavepointStore savepointStore2 = (SavepointStore)tuple12._10();
                                    FiniteDuration jobRecoveryTimeout2 = (FiniteDuration)tuple12._11();
                                    Option metricsRegistry2 = (Option)tuple12._12();
                                    Tuple12 tuple123 = tuple122 = new Tuple12((Object)instanceManager2, (Object)scheduler2, (Object)libraryCacheManager2, (Object)restartStrategy2, (Object)timeout2, (Object)BoxesRunTime.boxToInteger((int)archiveCount), (Object)leaderElectionService2, (Object)submittedJobGraphs2, (Object)checkpointRecoveryFactory2, (Object)savepointStore2, (Object)jobRecoveryTimeout2, (Object)metricsRegistry2);
                                    instanceManager = (InstanceManager)tuple123._1();
                                    scheduler = (Scheduler)tuple123._2();
                                    libraryCacheManager = (BlobLibraryCacheManager)tuple123._3();
                                    restartStrategy = (RestartStrategyFactory)tuple123._4();
                                    timeout = (FiniteDuration)tuple123._5();
                                    int archiveCount2 = BoxesRunTime.unboxToInt((Object)tuple123._6());
                                    leaderElectionService = (LeaderElectionService)tuple123._7();
                                    submittedJobGraphs = (SubmittedJobGraphStore)tuple123._8();
                                    checkpointRecoveryFactory = (CheckpointRecoveryFactory)tuple123._9();
                                    savepointStore = (SavepointStore)tuple123._10();
                                    jobRecoveryTimeout = (FiniteDuration)tuple123._11();
                                    metricsRegistry = (Option)tuple123._12();
                                    archiveProps = Props$.MODULE$.apply(archiveClass, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)archiveCount2)}));
                                    option = archiveActorName;
                                    if (!(option instanceof Some)) break block3;
                                    Some some = (Some)option;
                                    String actorName = (String)some.x();
                                    actorRef2 = actorSystem.actorOf(archiveProps, actorName);
                                    break block4;
                                }
                                None$ none$ = None$.MODULE$;
                                Option<String> option3 = option;
                                if (none$ != null ? !none$.equals(option3) : option3 != null) break block5;
                                actorRef2 = actorSystem.actorOf(archiveProps);
                            }
                            archive = actorRef2;
                            jobManagerProps = Props$.MODULE$.apply(jobManagerClass, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configuration, futureExecutor, ioExecutor, instanceManager, scheduler, libraryCacheManager, archive, restartStrategy, timeout, leaderElectionService, submittedJobGraphs, checkpointRecoveryFactory, savepointStore, jobRecoveryTimeout, metricsRegistry}));
                            option2 = jobManagerActorName;
                            if (!(option2 instanceof Some)) break block6;
                            Some some = (Some)option2;
                            String actorName = (String)some.x();
                            actorRef = actorSystem.actorOf(jobManagerProps, actorName);
                            break block7;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<String> option4 = option2;
                        if (none$ != null ? !none$.equals(option4) : option4 != null) break block8;
                        actorRef = actorSystem.actorOf(jobManagerProps);
                    }
                    ActorRef jobManager = actorRef;
                    return new Tuple2((Object)jobManager, (Object)archive);
                }
                throw new MatchError(option2);
            }
            throw new MatchError(option);
        }
        throw new MatchError(tuple12);
    }

    public String getRemoteJobManagerAkkaURL(InetSocketAddress address, Option<String> name) {
        String hostPort = NetUtils.socketAddressToUrlString((InetSocketAddress)address);
        return this.getJobManagerAkkaURLHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"akka.tcp://flink@", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hostPort})), name);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getRemoteJobManagerAkkaURL(Configuration config) {
        Tuple2 tuple22;
        Tuple2<String, Object> tuple2 = TaskManager$.MODULE$.getAndCheckJobManagerAddress(config);
        if (tuple2 == null) throw new MatchError(tuple2);
        String hostname = (String)tuple2._1();
        int port = tuple2._2$mcI$sp();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)hostname, (Object)BoxesRunTime.boxToInteger((int)port));
        String hostname2 = (String)tuple23._1();
        int port2 = tuple23._2$mcI$sp();
        InetSocketAddress hostPort = null;
        try {
            InetAddress inetAddress = InetAddress.getByName(hostname2);
            hostPort = new InetSocketAddress(inetAddress, port2);
            return this.getRemoteJobManagerAkkaURL(hostPort, (Option<String>)Option$.MODULE$.empty());
        }
        catch (UnknownHostException unknownHostException) {
            void var7_7;
            throw new UnknownHostException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot resolve the JobManager hostname '", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var7_7}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"specified in the configuration"})).s((Seq)Nil$.MODULE$)).toString());
        }
    }

    public Option<String> getRemoteJobManagerAkkaURL$default$2() {
        return None$.MODULE$;
    }

    public String getLocalJobManagerAkkaURL(Option<String> name) {
        return this.getJobManagerAkkaURLHelper("akka://flink", name);
    }

    public Option<String> getLocalJobManagerAkkaURL$default$1() {
        return None$.MODULE$;
    }

    public String getJobManagerAkkaURL(ActorSystem system, Option<String> name) {
        return this.getJobManagerAkkaURLHelper(AkkaUtils$.MODULE$.getAddress(system).toString(), name);
    }

    public Option<String> getJobManagerAkkaURL$default$2() {
        return None$.MODULE$;
    }

    private String getJobManagerAkkaURLHelper(String address, Option<String> name) {
        return new StringBuilder().append((Object)address).append((Object)"/user/").append(name.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return JobManager$.MODULE$.JOB_MANAGER_NAME();
            }
        })).toString();
    }

    public Future<ActorRef> getJobManagerActorRefFuture(InetSocketAddress address, ActorSystem system, FiniteDuration timeout) {
        return AkkaUtils$.MODULE$.getActorRefFuture(this.getRemoteJobManagerAkkaURL(address, this.getRemoteJobManagerAkkaURL$default$2()), system, timeout);
    }

    public ActorRef getJobManagerActorRef(String jobManagerUrl, ActorSystem system, FiniteDuration timeout) throws IOException {
        return AkkaUtils$.MODULE$.getActorRef(jobManagerUrl, system, timeout);
    }

    public ActorRef getJobManagerActorRef(InetSocketAddress address, ActorSystem system, FiniteDuration timeout) throws IOException {
        String jmAddress = this.getRemoteJobManagerAkkaURL(address, this.getRemoteJobManagerAkkaURL$default$2());
        return this.getJobManagerActorRef(jmAddress, system, timeout);
    }

    public ActorRef getJobManagerActorRef(InetSocketAddress address, ActorSystem system, Configuration config) throws IOException {
        FiniteDuration timeout = AkkaUtils$.MODULE$.getLookupTimeout(config);
        return this.getJobManagerActorRef(address, system, timeout);
    }

    private final Tuple4 liftedTree2$1(String[] args$1) {
        Tuple4<Configuration, JobManagerMode, String, Iterator<Integer>> tuple4;
        try {
            tuple4 = this.parseArgs(args$1);
        }
        catch (Throwable throwable) {
            this.LOG().error((Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$13;

                public final String apply() {
                    return this.t$13.getMessage();
                }
                {
                    this.t$13 = t$13;
                }
            }, (Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$13;

                public final Throwable apply() {
                    return this.t$13;
                }
                {
                    this.t$13 = t$13;
                }
            });
            System.exit(this.STARTUP_FAILURE_RETURN_CODE());
            tuple4 = null;
        }
        return tuple4;
    }

    private final Tuple5 liftedTree3$1(Configuration configuration$3, JobManagerMode executionMode$3, String listeningAddress$2, int listeningPort$1, ExecutorService futureExecutor$1, ExecutorService ioExecutor$1) {
        try {
            return this.startActorSystemAndJobManagerActors(configuration$3, executionMode$3, listeningAddress$2, listeningPort$1, futureExecutor$1, ioExecutor$1, JobManager.class, MemoryArchivist.class, Option$.MODULE$.apply(StandaloneResourceManager.class));
        }
        catch (Throwable throwable) {
            futureExecutor$1.shutdownNow();
            ioExecutor$1.shutdownNow();
            throw throwable;
        }
    }

    private final void sleepBeforeRetry$1(long maxSleepBetweenRetries$1) {
        if (maxSleepBetweenRetries$1 > 0L) {
            long sleepTime = (long)(Math.random() * (double)maxSleepBetweenRetries$1);
            this.LOG().info((Function0)new Serializable(sleepTime){
                public static final long serialVersionUID = 0L;
                private final long sleepTime$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retrying after bind exception. Sleeping for ", " ms."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.sleepTime$1)}));
                }
                {
                    this.sleepTime$1 = sleepTime$1;
                }
            });
            Thread.sleep(sleepTime);
        }
    }

    private JobManager$() {
        MODULE$ = this;
        this.LOG = Logger$.MODULE$.apply(JobManager.class);
        this.STARTUP_FAILURE_RETURN_CODE = 1;
        this.RUNTIME_FAILURE_RETURN_CODE = 2;
        this.JOB_MANAGER_NAME = "jobmanager";
        this.ARCHIVE_NAME = "archive";
    }
}

