/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.tasks;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.flink.runtime.jobgraph.JobVertexID;

public class JobSnapshottingSettings
implements Serializable {
    private static final long serialVersionUID = -2593319571078198180L;
    private final List<JobVertexID> verticesToTrigger;
    private final List<JobVertexID> verticesToAcknowledge;
    private final List<JobVertexID> verticesToConfirm;
    private final long checkpointInterval;
    private final long checkpointTimeout;
    private final long minPauseBetweenCheckpoints;
    private final int maxConcurrentCheckpoints;

    public JobSnapshottingSettings(List<JobVertexID> verticesToTrigger, List<JobVertexID> verticesToAcknowledge, List<JobVertexID> verticesToConfirm, long checkpointInterval, long checkpointTimeout, long minPauseBetweenCheckpoints, int maxConcurrentCheckpoints) {
        if (checkpointInterval < 1L || checkpointTimeout < 1L || minPauseBetweenCheckpoints < 0L || maxConcurrentCheckpoints < 1) {
            throw new IllegalArgumentException();
        }
        this.verticesToTrigger = Objects.requireNonNull(verticesToTrigger);
        this.verticesToAcknowledge = Objects.requireNonNull(verticesToAcknowledge);
        this.verticesToConfirm = Objects.requireNonNull(verticesToConfirm);
        this.checkpointInterval = checkpointInterval;
        this.checkpointTimeout = checkpointTimeout;
        this.minPauseBetweenCheckpoints = minPauseBetweenCheckpoints;
        this.maxConcurrentCheckpoints = maxConcurrentCheckpoints;
    }

    public List<JobVertexID> getVerticesToTrigger() {
        return this.verticesToTrigger;
    }

    public List<JobVertexID> getVerticesToAcknowledge() {
        return this.verticesToAcknowledge;
    }

    public List<JobVertexID> getVerticesToConfirm() {
        return this.verticesToConfirm;
    }

    public long getCheckpointInterval() {
        return this.checkpointInterval;
    }

    public long getCheckpointTimeout() {
        return this.checkpointTimeout;
    }

    public long getMinPauseBetweenCheckpoints() {
        return this.minPauseBetweenCheckpoints;
    }

    public int getMaxConcurrentCheckpoints() {
        return this.maxConcurrentCheckpoints;
    }

    public String toString() {
        return String.format("SnapshotSettings: interval=%d, timeout=%d, pause-between=%d, maxConcurrent=%d, trigger=%s, ack=%s, commit=%s", this.checkpointInterval, this.checkpointTimeout, this.minPauseBetweenCheckpoints, this.maxConcurrentCheckpoints, this.verticesToTrigger, this.verticesToAcknowledge, this.verticesToConfirm);
    }
}

