/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.io.Serializable;
import org.apache.flink.util.Preconditions;

public class SavepointRestoreSettings
implements Serializable {
    private static final long serialVersionUID = 87377506900849777L;
    private static final SavepointRestoreSettings NONE = new SavepointRestoreSettings(null, false);
    private static final boolean DEFAULT_ALLOW_NON_RESTORED_STATE = false;
    private final String restorePath;
    private final boolean allowNonRestoredState;

    private SavepointRestoreSettings(String restorePath, boolean allowNonRestoredState) {
        this.restorePath = restorePath;
        this.allowNonRestoredState = allowNonRestoredState;
    }

    public boolean restoreSavepoint() {
        return this.restorePath != null;
    }

    public String getRestorePath() {
        return this.restorePath;
    }

    public boolean allowNonRestoredState() {
        return this.allowNonRestoredState;
    }

    public String toString() {
        if (this.restoreSavepoint()) {
            return "SavepointRestoreSettings.forPath(restorePath='" + this.restorePath + '\'' + ", allowNonRestoredState=" + this.allowNonRestoredState + ')';
        }
        return "SavepointRestoreSettings.none()";
    }

    public static SavepointRestoreSettings none() {
        return NONE;
    }

    public static SavepointRestoreSettings forPath(String savepointPath) {
        return SavepointRestoreSettings.forPath(savepointPath, false);
    }

    public static SavepointRestoreSettings forPath(String savepointPath, boolean allowNonRestoredState) {
        Preconditions.checkNotNull((Object)savepointPath, (String)"Savepoint restore path.");
        return new SavepointRestoreSettings(savepointPath, allowNonRestoredState);
    }
}

