/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.CancelCheckpointMarker;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.EndOfSuperstepEvent;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.util.DataInputDeserializer;
import org.apache.flink.runtime.util.DataOutputSerializer;
import org.apache.flink.util.InstantiationUtil;

public class EventSerializer {
    private static final int END_OF_PARTITION_EVENT = 0;
    private static final int CHECKPOINT_BARRIER_EVENT = 1;
    private static final int END_OF_SUPERSTEP_EVENT = 2;
    private static final int OTHER_EVENT = 3;
    private static final int CANCEL_CHECKPOINT_MARKER_EVENT = 4;

    public static ByteBuffer toSerializedEvent(AbstractEvent event) throws IOException {
        Class<?> eventClass = event.getClass();
        if (eventClass == EndOfPartitionEvent.class) {
            return ByteBuffer.wrap(new byte[]{0, 0, 0, 0});
        }
        if (eventClass == CheckpointBarrier.class) {
            CheckpointBarrier barrier = (CheckpointBarrier)event;
            ByteBuffer buf = ByteBuffer.allocate(20);
            buf.putInt(0, 1);
            buf.putLong(4, barrier.getId());
            buf.putLong(12, barrier.getTimestamp());
            return buf;
        }
        if (eventClass == EndOfSuperstepEvent.class) {
            return ByteBuffer.wrap(new byte[]{0, 0, 0, 2});
        }
        if (eventClass == CancelCheckpointMarker.class) {
            CancelCheckpointMarker marker = (CancelCheckpointMarker)event;
            ByteBuffer buf = ByteBuffer.allocate(12);
            buf.putInt(0, 4);
            buf.putLong(4, marker.getCheckpointId());
            return buf;
        }
        try {
            DataOutputSerializer serializer = new DataOutputSerializer(128);
            serializer.writeInt(3);
            serializer.writeUTF(event.getClass().getName());
            event.write(serializer);
            return serializer.wrapAsByteBuffer();
        }
        catch (IOException e) {
            throw new IOException("Error while serializing event.", e);
        }
    }

    public static AbstractEvent fromSerializedEvent(ByteBuffer buffer, ClassLoader classLoader) throws IOException {
        if (buffer.remaining() < 4) {
            throw new IOException("Incomplete event");
        }
        ByteOrder bufferOrder = buffer.order();
        buffer.order(ByteOrder.BIG_ENDIAN);
        try {
            int type = buffer.getInt();
            if (type == 0) {
                EndOfPartitionEvent endOfPartitionEvent = EndOfPartitionEvent.INSTANCE;
                return endOfPartitionEvent;
            }
            if (type == 1) {
                long id = buffer.getLong();
                long timestamp = buffer.getLong();
                CheckpointBarrier checkpointBarrier = new CheckpointBarrier(id, timestamp);
                return checkpointBarrier;
            }
            if (type == 2) {
                EndOfSuperstepEvent endOfSuperstepEvent = EndOfSuperstepEvent.INSTANCE;
                return endOfSuperstepEvent;
            }
            if (type == 4) {
                long id = buffer.getLong();
                CancelCheckpointMarker cancelCheckpointMarker = new CancelCheckpointMarker(id);
                return cancelCheckpointMarker;
            }
            if (type == 3) {
                try {
                    Class<AbstractEvent> clazz;
                    DataInputDeserializer deserializer = new DataInputDeserializer(buffer);
                    String className = deserializer.readUTF();
                    try {
                        clazz = classLoader.loadClass(className).asSubclass(AbstractEvent.class);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IOException("Could not load event class '" + className + "'.", e);
                    }
                    catch (ClassCastException e) {
                        throw new IOException("The class '" + className + "' is not a valid subclass of '" + AbstractEvent.class.getName() + "'.", e);
                    }
                    AbstractEvent event = (AbstractEvent)InstantiationUtil.instantiate(clazz, AbstractEvent.class);
                    event.read(deserializer);
                    AbstractEvent abstractEvent = event;
                    return abstractEvent;
                }
                catch (Exception e) {
                    throw new IOException("Error while deserializing or instantiating event.", e);
                }
            }
            throw new IOException("Corrupt byte stream for event");
        }
        finally {
            buffer.order(bufferOrder);
        }
    }

    public static Buffer toBuffer(AbstractEvent event) throws IOException {
        ByteBuffer serializedEvent = EventSerializer.toSerializedEvent(event);
        MemorySegment data = MemorySegmentFactory.wrap((byte[])serializedEvent.array());
        Buffer buffer = new Buffer(data, FreeingBufferRecycler.INSTANCE, false);
        buffer.setSize(serializedEvent.remaining());
        return buffer;
    }

    public static AbstractEvent fromBuffer(Buffer buffer, ClassLoader classLoader) throws IOException {
        return EventSerializer.fromSerializedEvent(buffer.getNioBuffer(), classLoader);
    }
}

