/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.IOException;
import org.apache.flink.runtime.io.disk.iomanager.AsynchronousFileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileWriter;
import org.apache.flink.runtime.io.disk.iomanager.BufferWriteRequest;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.RequestDoneCallback;
import org.apache.flink.runtime.io.disk.iomanager.RequestQueue;
import org.apache.flink.runtime.io.disk.iomanager.WriteRequest;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.util.event.NotificationListener;

public class AsynchronousBufferFileWriter
extends AsynchronousFileIOChannel<Buffer, WriteRequest>
implements BufferFileWriter {
    private static final RecyclingCallback CALLBACK = new RecyclingCallback();

    protected AsynchronousBufferFileWriter(FileIOChannel.ID channelID, RequestQueue<WriteRequest> requestQueue) throws IOException {
        super(channelID, requestQueue, CALLBACK, true);
    }

    @Override
    public void writeBlock(Buffer buffer) throws IOException {
        this.addRequest(new BufferWriteRequest(this, buffer));
    }

    @Override
    public int getNumberOfOutstandingRequests() {
        return this.requestsNotReturned.get();
    }

    @Override
    public boolean registerAllRequestsProcessedListener(NotificationListener listener) throws IOException {
        return super.registerAllRequestsProcessedListener(listener);
    }

    private static class RecyclingCallback
    implements RequestDoneCallback<Buffer> {
        private RecyclingCallback() {
        }

        @Override
        public void requestSuccessful(Buffer buffer) {
            buffer.recycle();
        }

        @Override
        public void requestFailed(Buffer buffer, IOException e) {
            buffer.recycle();
        }
    }
}

