/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileIOChannel
implements FileIOChannel {
    protected static final Logger LOG = LoggerFactory.getLogger(FileIOChannel.class);
    protected final FileIOChannel.ID id;
    protected final FileChannel fileChannel;

    protected AbstractFileIOChannel(FileIOChannel.ID channelID, boolean writeEnabled) throws IOException {
        this.id = (FileIOChannel.ID)Preconditions.checkNotNull((Object)channelID);
        try {
            RandomAccessFile file = new RandomAccessFile(this.id.getPath(), writeEnabled ? "rw" : "r");
            this.fileChannel = file.getChannel();
        }
        catch (IOException e) {
            throw new IOException("Channel to path '" + channelID.getPath() + "' could not be opened.", e);
        }
    }

    @Override
    public final FileIOChannel.ID getChannelID() {
        return this.id;
    }

    @Override
    public long getSize() throws IOException {
        FileChannel channel = this.fileChannel;
        return channel == null ? 0L : channel.size();
    }

    @Override
    public abstract boolean isClosed();

    @Override
    public abstract void close() throws IOException;

    @Override
    public void deleteChannel() {
        if (!this.isClosed() || this.fileChannel.isOpen()) {
            throw new IllegalStateException("Cannot delete a channel that is open.");
        }
        try {
            File f = new File(this.id.getPath());
            if (f.exists()) {
                f.delete();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void closeAndDelete() throws IOException {
        try {
            this.close();
        }
        finally {
            this.deleteChannel();
        }
    }

    @Override
    public FileChannel getNioFileChannel() {
        return this.fileChannel;
    }
}

