/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.savepoint;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.runtime.checkpoint.savepoint.Savepoint;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointSerializer;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointSerializers;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointStore;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FsSavepointStore
implements SavepointStore {
    private static final Logger LOG = LoggerFactory.getLogger(FsSavepointStore.class);
    int MAGIC_NUMBER = 1231054637;
    private final Path rootPath;
    private final String prefix;
    private final FileSystem fileSystem;

    FsSavepointStore(String rootPath, String prefix) throws IOException {
        this.rootPath = new Path((String)Preconditions.checkNotNull((Object)rootPath, (String)"Root path"));
        this.prefix = (String)Preconditions.checkNotNull((Object)prefix, (String)"Prefix");
        this.fileSystem = FileSystem.get((URI)this.rootPath.toUri());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Savepoint> String storeSavepoint(T savepoint) throws IOException {
        Preconditions.checkNotNull(savepoint, (String)"Savepoint");
        Exception latestException = null;
        Path path = null;
        FSDataOutputStream fdos = null;
        for (int attempt = 0; attempt < 10; ++attempt) {
            path = new Path(this.rootPath, FileUtils.getRandomFilename((String)this.prefix));
            try {
                fdos = this.fileSystem.create(path, false);
                break;
            }
            catch (Exception e) {
                latestException = e;
                continue;
            }
        }
        if (fdos == null) {
            throw new IOException("Failed to create file output stream at " + path, latestException);
        }
        boolean success = false;
        try (DataOutputStream dos = new DataOutputStream((OutputStream)fdos);){
            dos.writeInt(this.MAGIC_NUMBER);
            dos.writeInt(savepoint.getVersion());
            SavepointSerializer<T> serializer = SavepointSerializers.getSerializer(savepoint);
            serializer.serialize(savepoint, dos);
            success = true;
        }
        finally {
            if (!success && this.fileSystem.exists(path) && !this.fileSystem.delete(path, true)) {
                LOG.warn("Failed to delete file " + path + " after failed write.");
            }
        }
        return path.toString();
    }

    @Override
    public Savepoint loadSavepoint(String path) throws IOException {
        Preconditions.checkNotNull((Object)path, (String)"Path");
        Throwable throwable = null;
        try (DataInputViewStreamWrapper dis = new DataInputViewStreamWrapper((InputStream)this.createFsInputStream(new Path(path)));){
            int magicNumber = dis.readInt();
            if (magicNumber == this.MAGIC_NUMBER) {
                int version = dis.readInt();
                SavepointSerializer<?> serializer = SavepointSerializers.getSerializer(version);
                Object obj = serializer.deserialize((DataInputStream)dis);
                return obj;
            }
            try {
                throw new RuntimeException("Unexpected magic number. This is most likely caused by trying to load a Flink 1.0 savepoint. You cannot load a savepoint triggered by Flink 1.0 with this version of Flink. If it is _not_ a Flink 1.0 savepoint, this error indicates that the specified file is not a proper savepoint or the file has been corrupted.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    public void disposeSavepoint(String path, ClassLoader classLoader) throws Exception {
        block4: {
            Preconditions.checkNotNull((Object)path, (String)"Path");
            Preconditions.checkNotNull((Object)classLoader, (String)"Class loader");
            try {
                Savepoint savepoint = this.loadSavepoint(path);
                savepoint.dispose(classLoader);
                Path filePath = new Path(path);
                if (this.fileSystem.exists(filePath)) {
                    if (!this.fileSystem.delete(filePath, true)) {
                        throw new IOException("Failed to delete " + filePath + ".");
                    }
                    break block4;
                }
                throw new IllegalArgumentException("Invalid path '" + filePath.toUri() + "'.");
            }
            catch (Throwable t) {
                throw new IOException("Failed to dispose savepoint " + path + ".", t);
            }
        }
    }

    @Override
    public void shutdown() throws Exception {
    }

    private FSDataInputStream createFsInputStream(Path path) throws IOException {
        if (this.fileSystem.exists(path)) {
            return this.fileSystem.open(path);
        }
        throw new IllegalArgumentException("Invalid path '" + path.toUri() + "'.");
    }

    Path getRootPath() {
        return this.rootPath;
    }
}

