/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.akka;

import akka.actor.UntypedActor;
import akka.remote.AssociationErrorEvent;
import akka.remote.transport.Transport;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.runtime.akka.QuarantineHandler;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

public class QuarantineMonitor
extends UntypedActor {
    private static final Pattern pattern = Pattern.compile("^Invalid address:\\s+(.*)$");
    private static final String QUARANTINE_MSG = "The remote system has a UID that has been quarantined. Association aborted.";
    private static final String QUARANTINED_MSG = "The remote system has quarantined this system. No further associations to the remote system are possible until this system is restarted.";
    private final QuarantineHandler handler;
    private final Logger log;

    public QuarantineMonitor(QuarantineHandler handler, Logger log) {
        this.handler = (QuarantineHandler)Preconditions.checkNotNull((Object)handler);
        this.log = (Logger)Preconditions.checkNotNull((Object)log);
    }

    public void preStart() {
        this.getContext().system().eventStream().subscribe(this.getSelf(), AssociationErrorEvent.class);
    }

    public void onReceive(Object message) throws Exception {
        if (message instanceof AssociationErrorEvent) {
            AssociationErrorEvent associationErrorEvent = (AssociationErrorEvent)message;
            if (associationErrorEvent.getCause() != null) {
                Throwable invalidAssociation = associationErrorEvent.getCause();
                Matcher matcher = pattern.matcher(invalidAssociation.getMessage());
                String remoteSystem = matcher.find() ? matcher.group(1) : "Unknown";
                if (invalidAssociation.getCause() instanceof Transport.InvalidAssociationException) {
                    Transport.InvalidAssociationException invalidAssociationException = (Transport.InvalidAssociationException)invalidAssociation.getCause();
                    if (QUARANTINE_MSG.equals(invalidAssociationException.getMessage())) {
                        this.handler.hasQuarantined(remoteSystem, this.getContext().system());
                    } else if (QUARANTINED_MSG.equals(invalidAssociationException.getMessage())) {
                        this.handler.wasQuarantinedBy(remoteSystem, this.getContext().system());
                    } else {
                        this.log.debug("The invalid association exception's message could not be matched.", (Object)associationErrorEvent);
                    }
                } else {
                    this.log.debug("The association error event's root cause is not of type {}.", (Object)Transport.InvalidAssociationException.class.getSimpleName(), (Object)associationErrorEvent);
                }
            } else {
                this.log.debug("Received association error event which did not contain a cause.", (Object)associationErrorEvent);
            }
        }
    }
}

