/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators;

import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.runtime.operators.TimestampsAndWatermarksOperator;
import org.apache.flink.util.Preconditions;

public class TimestampsAndWatermarksOperatorFactory<T>
extends AbstractStreamOperatorFactory<T>
implements OneInputStreamOperatorFactory<T, T> {
    private final WatermarkStrategy<T> watermarkStrategy;
    private final boolean emitProgressiveWatermarks;

    public TimestampsAndWatermarksOperatorFactory(WatermarkStrategy<T> watermarkStrategy, boolean emitProgressiveWatermarks) {
        this.watermarkStrategy = (WatermarkStrategy)Preconditions.checkNotNull(watermarkStrategy);
        this.emitProgressiveWatermarks = emitProgressiveWatermarks;
    }

    @Override
    public <T1 extends StreamOperator<T>> T1 createStreamOperator(StreamOperatorParameters<T> parameters) {
        return (T1)new TimestampsAndWatermarksOperator<T>(parameters, this.watermarkStrategy, this.emitProgressiveWatermarks);
    }

    @Override
    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        return TimestampsAndWatermarksOperator.class;
    }
}

