/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.util.ImmutableStreamNode;

@Internal
public class ImmutableStreamGraph {
    private final StreamGraph streamGraph;
    private final ClassLoader userClassloader;
    private final Map<Integer, ImmutableStreamNode> immutableStreamNodes;

    public ImmutableStreamGraph(StreamGraph streamGraph, ClassLoader userClassloader) {
        this.streamGraph = streamGraph;
        this.userClassloader = userClassloader;
        this.immutableStreamNodes = new HashMap<Integer, ImmutableStreamNode>();
    }

    public ImmutableStreamNode getStreamNode(Integer vertexId) {
        if (this.streamGraph.getStreamNode(vertexId) == null) {
            return null;
        }
        return this.immutableStreamNodes.computeIfAbsent(vertexId, id -> new ImmutableStreamNode(this.streamGraph.getStreamNode((Integer)id)));
    }

    public ReadableConfig getConfiguration() {
        return this.streamGraph.getJobConfiguration();
    }

    public ClassLoader getUserClassLoader() {
        return this.userClassloader;
    }
}

