/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.IOException;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.EntropyInjector;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.CheckpointMetadataOutputStream;
import org.apache.flink.runtime.state.CheckpointStorageLocation;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.runtime.state.filesystem.FsCheckpointMetadataOutputStream;
import org.apache.flink.runtime.state.filesystem.FsCheckpointStreamFactory;
import org.apache.flink.util.Preconditions;

public class FsCheckpointStorageLocation
extends FsCheckpointStreamFactory
implements CheckpointStorageLocation {
    private final FileSystem fileSystem;
    private final Path checkpointDirectory;
    private final Path sharedStateDirectory;
    private final Path taskOwnedStateDirectory;
    private final Path metadataFilePath;
    private final CheckpointStorageLocationReference reference;
    private final int fileStateSizeThreshold;
    private final int writeBufferSize;

    public FsCheckpointStorageLocation(FileSystem fileSystem, Path checkpointDir, Path sharedStateDir, Path taskOwnedStateDir, CheckpointStorageLocationReference reference, int fileStateSizeThreshold, int writeBufferSize) {
        super(fileSystem, checkpointDir, sharedStateDir, fileStateSizeThreshold, writeBufferSize);
        Preconditions.checkArgument((fileStateSizeThreshold >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((writeBufferSize >= 0 ? 1 : 0) != 0);
        this.fileSystem = (FileSystem)Preconditions.checkNotNull((Object)fileSystem);
        this.checkpointDirectory = (Path)Preconditions.checkNotNull((Object)checkpointDir);
        this.sharedStateDirectory = (Path)Preconditions.checkNotNull((Object)sharedStateDir);
        this.taskOwnedStateDirectory = (Path)Preconditions.checkNotNull((Object)taskOwnedStateDir);
        this.reference = (CheckpointStorageLocationReference)Preconditions.checkNotNull((Object)reference);
        Path metadataDir = EntropyInjector.removeEntropyMarkerIfPresent((FileSystem)fileSystem, (Path)checkpointDir);
        this.metadataFilePath = new Path(metadataDir, "_metadata");
        this.fileStateSizeThreshold = fileStateSizeThreshold;
        this.writeBufferSize = writeBufferSize;
    }

    public Path getCheckpointDirectory() {
        return this.checkpointDirectory;
    }

    public Path getSharedStateDirectory() {
        return this.sharedStateDirectory;
    }

    public Path getTaskOwnedStateDirectory() {
        return this.taskOwnedStateDirectory;
    }

    public Path getMetadataFilePath() {
        return this.metadataFilePath;
    }

    @Override
    public CheckpointMetadataOutputStream createMetadataOutputStream() throws IOException {
        return new FsCheckpointMetadataOutputStream(this.fileSystem, this.metadataFilePath, this.checkpointDirectory);
    }

    @Override
    public void disposeOnFailure() throws IOException {
        this.fileSystem.delete(this.checkpointDirectory, true);
    }

    @Override
    public CheckpointStorageLocationReference getLocationReference() {
        return this.reference;
    }

    @Override
    public String toString() {
        return "FsCheckpointStorageLocation {fileSystem=" + String.valueOf(this.fileSystem) + ", checkpointDirectory=" + String.valueOf(this.checkpointDirectory) + ", sharedStateDirectory=" + String.valueOf(this.sharedStateDirectory) + ", taskOwnedStateDirectory=" + String.valueOf(this.taskOwnedStateDirectory) + ", metadataFilePath=" + String.valueOf(this.metadataFilePath) + ", reference=" + String.valueOf(this.reference) + ", fileStateSizeThreshold=" + this.fileStateSizeThreshold + ", writeBufferSize=" + this.writeBufferSize + "}";
    }

    @VisibleForTesting
    FileSystem getFileSystem() {
        return this.fileSystem;
    }
}

