/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.checkpoint.InitializationStatus;
import org.apache.flink.runtime.checkpoint.SubTaskInitializationMetrics;

@ThreadSafe
public class SubTaskInitializationMetricsBuilder {
    private final long initializationStartTs;
    private final ConcurrentMap<String, Long> durationMetrics = new ConcurrentHashMap<String, Long>();
    private final AtomicReference<InitializationStatus> status = new AtomicReference<InitializationStatus>(InitializationStatus.FAILED);

    public SubTaskInitializationMetricsBuilder(long initializationStartTs) {
        this.initializationStartTs = initializationStartTs;
    }

    public long getInitializationStartTs() {
        return this.initializationStartTs;
    }

    public SubTaskInitializationMetricsBuilder addDurationMetric(String name, long value) {
        this.durationMetrics.compute(name, (key, oldValue) -> oldValue == null ? value : value + oldValue);
        return this;
    }

    public SubTaskInitializationMetricsBuilder setStatus(InitializationStatus status) {
        this.status.set(status);
        return this;
    }

    public SubTaskInitializationMetrics build() {
        return this.build(System.currentTimeMillis());
    }

    @VisibleForTesting
    public SubTaskInitializationMetrics build(long endTs) {
        return new SubTaskInitializationMetrics(this.initializationStartTs, endTs, this.durationMetrics, this.status.get());
    }
}

