/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.api.common.resources.ExternalResource;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExternalResourceOptions;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.taskexecutor.TaskExecutorResourceSpec;
import org.apache.flink.runtime.taskexecutor.TaskExecutorResourceUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TaskExecutorResourceUtilsTest {
    private static final double CPU_CORES = 1.0;
    private static final MemorySize TASK_HEAP = MemorySize.ofMebiBytes((long)1L);
    private static final MemorySize TASK_OFF_HEAP = MemorySize.ofMebiBytes((long)2L);
    private static final MemorySize NETWORK = MemorySize.ofMebiBytes((long)3L);
    private static final MemorySize MANAGED = MemorySize.ofMebiBytes((long)4L);
    private static final String EXTERNAL_RESOURCE_NAME = "test";
    private static final long EXTERNAL_RESOURCE_AMOUNT = 1L;

    TaskExecutorResourceUtilsTest() {
    }

    @Test
    void testResourceSpecFromConfig() {
        TaskExecutorResourceSpec resourceSpec = TaskExecutorResourceUtils.resourceSpecFromConfig((Configuration)TaskExecutorResourceUtilsTest.createValidConfig());
        Assertions.assertThat((Comparable)resourceSpec.getCpuCores()).isEqualTo((Object)new CPUResource(1.0));
        Assertions.assertThat((Comparable)resourceSpec.getTaskHeapSize()).isEqualTo((Object)TASK_HEAP);
        Assertions.assertThat((Comparable)resourceSpec.getTaskOffHeapSize()).isEqualTo((Object)TASK_OFF_HEAP);
        Assertions.assertThat((Comparable)resourceSpec.getNetworkMemSize()).isEqualTo((Object)NETWORK);
        Assertions.assertThat((Comparable)resourceSpec.getManagedMemorySize()).isEqualTo((Object)MANAGED);
        Assertions.assertThat((long)((ExternalResource)resourceSpec.getExtendedResources().get(EXTERNAL_RESOURCE_NAME)).getValue().longValue()).isEqualTo(1L);
    }

    @Test
    void testResourceSpecFromConfigFailsIfNetworkSizeIsNotFixed() {
        Configuration configuration = TaskExecutorResourceUtilsTest.createValidConfig();
        configuration.set(TaskManagerOptions.NETWORK_MEMORY_MIN, (Object)MemorySize.ofMebiBytes((long)1L));
        configuration.set(TaskManagerOptions.NETWORK_MEMORY_MAX, (Object)MemorySize.ofMebiBytes((long)2L));
        Assertions.assertThatThrownBy(() -> TaskExecutorResourceUtils.resourceSpecFromConfig((Configuration)configuration)).isInstanceOf(IllegalConfigurationException.class);
    }

    @Test
    void testResourceSpecFromConfigFailsIfRequiredOptionIsNotSet() {
        TaskExecutorResourceUtils.CONFIG_OPTIONS.stream().filter(option -> !option.hasDefaultValue()).forEach(option -> Assertions.assertThatThrownBy(() -> TaskExecutorResourceUtils.resourceSpecFromConfig((Configuration)TaskExecutorResourceUtilsTest.setAllRequiredOptionsExceptOne(option))).isInstanceOf(IllegalConfigurationException.class));
    }

    @Test
    void testAdjustForLocalExecution() {
        Configuration configuration = TaskExecutorResourceUtils.adjustForLocalExecution((Configuration)new Configuration());
        Assertions.assertThat((Comparable)((Comparable)configuration.get(TaskManagerOptions.NETWORK_MEMORY_MIN))).isEqualTo((Object)TaskExecutorResourceUtils.DEFAULT_SHUFFLE_MEMORY_SIZE);
        Assertions.assertThat((Comparable)((Comparable)configuration.get(TaskManagerOptions.NETWORK_MEMORY_MAX))).isEqualTo((Object)TaskExecutorResourceUtils.DEFAULT_SHUFFLE_MEMORY_SIZE);
        Assertions.assertThat((Comparable)((Comparable)configuration.get(TaskManagerOptions.MANAGED_MEMORY_SIZE))).isEqualTo((Object)TaskExecutorResourceUtils.DEFAULT_MANAGED_MEMORY_SIZE);
    }

    @Test
    public void testNetworkMinAdjustForLocalExecutionIfMaxSet() {
        MemorySize networkMemorySize = MemorySize.ofMebiBytes((long)1L);
        Configuration configuration = new Configuration();
        configuration.set(TaskManagerOptions.NETWORK_MEMORY_MAX, (Object)networkMemorySize);
        TaskExecutorResourceUtils.adjustForLocalExecution((Configuration)configuration);
        Assertions.assertThat((Comparable)((Comparable)configuration.get(TaskManagerOptions.NETWORK_MEMORY_MIN))).isEqualTo((Object)networkMemorySize);
        Assertions.assertThat((Comparable)((Comparable)configuration.get(TaskManagerOptions.NETWORK_MEMORY_MAX))).isEqualTo((Object)networkMemorySize);
    }

    @Test
    public void testNetworkMaxAdjustForLocalExecutionIfMinSet() {
        MemorySize networkMemorySize = MemorySize.ofMebiBytes((long)1L);
        Configuration configuration = new Configuration();
        configuration.set(TaskManagerOptions.NETWORK_MEMORY_MIN, (Object)networkMemorySize);
        TaskExecutorResourceUtils.adjustForLocalExecution((Configuration)configuration);
        Assertions.assertThat((Comparable)((Comparable)configuration.get(TaskManagerOptions.NETWORK_MEMORY_MIN))).isEqualTo((Object)networkMemorySize);
        Assertions.assertThat((Comparable)((Comparable)configuration.get(TaskManagerOptions.NETWORK_MEMORY_MAX))).isEqualTo((Object)networkMemorySize);
    }

    @Test
    void testUnusedOptionsAreIgnoredForLocalExecution() {
        Configuration configuration = new Configuration();
        configuration.set(TaskManagerOptions.TOTAL_PROCESS_MEMORY, (Object)MemorySize.ofMebiBytes((long)2024L));
        configuration.set(TaskManagerOptions.TOTAL_FLINK_MEMORY, (Object)MemorySize.ofMebiBytes((long)2024L));
        configuration.set(TaskManagerOptions.FRAMEWORK_HEAP_MEMORY, (Object)MemorySize.ofMebiBytes((long)2024L));
        configuration.set(TaskManagerOptions.FRAMEWORK_OFF_HEAP_MEMORY, (Object)MemorySize.ofMebiBytes((long)2024L));
        configuration.set(TaskManagerOptions.JVM_METASPACE, (Object)MemorySize.ofMebiBytes((long)2024L));
        configuration.set(TaskManagerOptions.JVM_OVERHEAD_MIN, (Object)MemorySize.ofMebiBytes((long)2024L));
        configuration.set(TaskManagerOptions.JVM_OVERHEAD_MAX, (Object)MemorySize.ofMebiBytes((long)2024L));
        configuration.set(TaskManagerOptions.JVM_OVERHEAD_FRACTION, (Object)Float.valueOf(2024.0f));
        TaskExecutorResourceUtils.adjustForLocalExecution((Configuration)configuration);
        Assertions.assertThat((Object)configuration).isEqualTo((Object)TaskExecutorResourceUtils.adjustForLocalExecution((Configuration)new Configuration()));
    }

    @Test
    void testCalculateTotalFlinkMemoryWithAllFactorsBeingSet() {
        Configuration config = new Configuration();
        config.set(TaskManagerOptions.FRAMEWORK_HEAP_MEMORY, (Object)new MemorySize(1L));
        config.set(TaskManagerOptions.TASK_HEAP_MEMORY, (Object)new MemorySize(2L));
        config.set(TaskManagerOptions.FRAMEWORK_OFF_HEAP_MEMORY, (Object)new MemorySize(3L));
        config.set(TaskManagerOptions.TASK_OFF_HEAP_MEMORY, (Object)new MemorySize(4L));
        config.set(TaskManagerOptions.NETWORK_MEMORY_MAX, (Object)new MemorySize(6L));
        config.set(TaskManagerOptions.NETWORK_MEMORY_MIN, (Object)new MemorySize(6L));
        config.set(TaskManagerOptions.MANAGED_MEMORY_SIZE, (Object)new MemorySize(7L));
        Assertions.assertThat((long)TaskExecutorResourceUtils.calculateTotalFlinkMemoryFromComponents((Configuration)config)).isEqualTo(23L);
    }

    @Test
    void testCalculateTotalFlinkMemoryWithMissingFactors() {
        Configuration config = new Configuration();
        config.set(TaskManagerOptions.FRAMEWORK_HEAP_MEMORY, (Object)new MemorySize(1L));
        config.set(TaskManagerOptions.FRAMEWORK_OFF_HEAP_MEMORY, (Object)new MemorySize(3L));
        config.set(TaskManagerOptions.TASK_OFF_HEAP_MEMORY, (Object)new MemorySize(4L));
        config.set(TaskManagerOptions.MANAGED_MEMORY_SIZE, (Object)new MemorySize(7L));
        Assertions.assertThatThrownBy(() -> TaskExecutorResourceUtils.calculateTotalFlinkMemoryFromComponents((Configuration)config)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testCalculateTotalProcessMemoryWithAllFactorsBeingSet() {
        Configuration config = new Configuration();
        config.set(TaskManagerOptions.FRAMEWORK_HEAP_MEMORY, (Object)new MemorySize(1L));
        config.set(TaskManagerOptions.TASK_HEAP_MEMORY, (Object)new MemorySize(2L));
        config.set(TaskManagerOptions.FRAMEWORK_OFF_HEAP_MEMORY, (Object)new MemorySize(3L));
        config.set(TaskManagerOptions.TASK_OFF_HEAP_MEMORY, (Object)new MemorySize(4L));
        config.set(TaskManagerOptions.NETWORK_MEMORY_MAX, (Object)new MemorySize(6L));
        config.set(TaskManagerOptions.NETWORK_MEMORY_MIN, (Object)new MemorySize(6L));
        config.set(TaskManagerOptions.MANAGED_MEMORY_SIZE, (Object)new MemorySize(7L));
        config.set(TaskManagerOptions.JVM_METASPACE, (Object)new MemorySize(8L));
        config.set(TaskManagerOptions.JVM_OVERHEAD_MAX, (Object)new MemorySize(10L));
        config.set(TaskManagerOptions.JVM_OVERHEAD_MIN, (Object)new MemorySize(10L));
        Assertions.assertThat((long)TaskExecutorResourceUtils.calculateTotalProcessMemoryFromComponents((Configuration)config)).isEqualTo(41L);
    }

    @Test
    void testCalculateTotalProcessMemoryWithMissingFactors() {
        Configuration config = new Configuration();
        config.set(TaskManagerOptions.FRAMEWORK_HEAP_MEMORY, (Object)new MemorySize(1L));
        config.set(TaskManagerOptions.FRAMEWORK_OFF_HEAP_MEMORY, (Object)new MemorySize(3L));
        config.set(TaskManagerOptions.TASK_OFF_HEAP_MEMORY, (Object)new MemorySize(4L));
        config.set(TaskManagerOptions.NETWORK_MEMORY_MAX, (Object)new MemorySize(6L));
        config.set(TaskManagerOptions.MANAGED_MEMORY_SIZE, (Object)new MemorySize(7L));
        config.set(TaskManagerOptions.JVM_METASPACE, (Object)new MemorySize(8L));
        Assertions.assertThatThrownBy(() -> TaskExecutorResourceUtils.calculateTotalProcessMemoryFromComponents((Configuration)config)).isInstanceOf(IllegalArgumentException.class);
    }

    private static Configuration createValidConfig() {
        Configuration configuration = new Configuration();
        configuration.set(TaskManagerOptions.CPU_CORES, (Object)1.0);
        configuration.set(TaskManagerOptions.TASK_HEAP_MEMORY, (Object)TASK_HEAP);
        configuration.set(TaskManagerOptions.TASK_OFF_HEAP_MEMORY, (Object)TASK_OFF_HEAP);
        configuration.set(TaskManagerOptions.NETWORK_MEMORY_MIN, (Object)NETWORK);
        configuration.set(TaskManagerOptions.NETWORK_MEMORY_MAX, (Object)NETWORK);
        configuration.set(TaskManagerOptions.MANAGED_MEMORY_SIZE, (Object)MANAGED);
        configuration.setString(ExternalResourceOptions.EXTERNAL_RESOURCE_LIST.key(), EXTERNAL_RESOURCE_NAME);
        configuration.setString(ExternalResourceOptions.getAmountConfigOptionForResource((String)EXTERNAL_RESOURCE_NAME), String.valueOf(1L));
        return configuration;
    }

    private static Configuration setAllRequiredOptionsExceptOne(ConfigOption<?> optionToNotSet) {
        Configuration configuration = new Configuration();
        if (!TaskManagerOptions.CPU_CORES.equals(optionToNotSet)) {
            configuration.set(TaskManagerOptions.CPU_CORES, (Object)1.0);
        }
        MemorySize network = MemorySize.ofMebiBytes((long)3L);
        configuration.set(TaskManagerOptions.NETWORK_MEMORY_MIN, (Object)network);
        configuration.set(TaskManagerOptions.NETWORK_MEMORY_MAX, (Object)network);
        TaskExecutorResourceUtils.CONFIG_OPTIONS.stream().filter(option -> !option.equals((Object)TaskManagerOptions.CPU_CORES)).filter(option -> !option.equals((Object)optionToNotSet)).forEach(option -> configuration.set(option, (Object)MemorySize.ofMebiBytes((long)1L)));
        return configuration;
    }
}

