/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import javax.annotation.Nonnull;
import org.apache.flink.runtime.state.InternalPriorityQueue;
import org.apache.flink.runtime.state.InternalPriorityQueueTestBase;
import org.apache.flink.runtime.state.KeyExtractorFunction;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.PriorityComparator;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueElement;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueSet;
import org.apache.flink.runtime.state.heap.KeyGroupPartitionedPriorityQueue;

class KeyGroupPartitionedPriorityQueueTest
extends InternalPriorityQueueTestBase {
    KeyGroupPartitionedPriorityQueueTest() {
    }

    @Override
    protected InternalPriorityQueue<InternalPriorityQueueTestBase.TestElement> newPriorityQueue(int initialCapacity) {
        return new KeyGroupPartitionedPriorityQueue(KEY_EXTRACTOR_FUNCTION, TEST_ELEMENT_PRIORITY_COMPARATOR, this.newFactory(initialCapacity), KEY_GROUP_RANGE, KEY_GROUP_RANGE.getNumberOfKeyGroups());
    }

    private KeyGroupPartitionedPriorityQueue.PartitionQueueSetFactory<InternalPriorityQueueTestBase.TestElement, KeyGroupHeapPQSet<InternalPriorityQueueTestBase.TestElement>> newFactory(int initialCapacity) {
        return (keyGroupId, numKeyGroups, keyExtractorFunction, elementComparator) -> new KeyGroupHeapPQSet(elementComparator, keyExtractorFunction, initialCapacity, KeyGroupRange.of((int)keyGroupId, (int)keyGroupId), numKeyGroups);
    }

    @Override
    protected boolean testSetSemanticsAgainstDuplicateElements() {
        return true;
    }

    private static class KeyGroupHeapPQSet<T extends HeapPriorityQueueElement>
    extends HeapPriorityQueueSet<T>
    implements HeapPriorityQueueElement {
        private int internalIndex = Integer.MIN_VALUE;

        public KeyGroupHeapPQSet(@Nonnull PriorityComparator<T> elementPriorityComparator, @Nonnull KeyExtractorFunction<T> keyExtractor, int minimumCapacity, @Nonnull KeyGroupRange keyGroupRange, int totalNumberOfKeyGroups) {
            super(elementPriorityComparator, keyExtractor, minimumCapacity, keyGroupRange, totalNumberOfKeyGroups);
        }

        public int getInternalIndex() {
            return this.internalIndex;
        }

        public void setInternalIndex(int newIndex) {
            this.internalIndex = newIndex;
        }
    }
}

