/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.StateBackendOptions;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.StateBackendFactory;
import org.apache.flink.runtime.state.StateBackendLoader;
import org.apache.flink.runtime.state.filesystem.FsStateBackend;
import org.apache.flink.runtime.state.filesystem.FsStateBackendFactory;
import org.apache.flink.runtime.state.hashmap.HashMapStateBackend;
import org.apache.flink.runtime.state.memory.MemoryStateBackend;
import org.apache.flink.runtime.state.memory.MemoryStateBackendFactory;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.util.DynamicCodeLoadingException;
import org.apache.flink.util.TernaryBoolean;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mockito;

class StateBackendLoadingTest {
    @TempDir
    private java.nio.file.Path tmp;
    private final ClassLoader cl = this.getClass().getClassLoader();
    private final String backendKey = StateBackendOptions.STATE_BACKEND.key();

    StateBackendLoadingTest() {
    }

    @Test
    void testDefaultStateBackend() throws Exception {
        Assertions.assertThat((Object)StateBackendLoader.loadStateBackendFromConfig((ReadableConfig)new Configuration(), (ClassLoader)this.cl, null)).isInstanceOf(HashMapStateBackend.class);
    }

    @Test
    void testInstantiateHashMapStateBackendBackendByDefault() throws Exception {
        StateBackend backend = StateBackendLoader.fromApplicationOrConfigOrDefault(null, (Configuration)new Configuration(), (Configuration)new Configuration(), (ClassLoader)this.cl, null);
        Assertions.assertThat((Object)backend).isInstanceOf(HashMapStateBackend.class);
    }

    @Test
    void testApplicationDefinedHasPrecedence() throws Exception {
        StateBackend appBackend = (StateBackend)Mockito.mock(StateBackend.class);
        Configuration config = new Configuration();
        config.setString(this.backendKey, "jobmanager");
        StateBackend backend = StateBackendLoader.fromApplicationOrConfigOrDefault((StateBackend)appBackend, (Configuration)config, (Configuration)config, (ClassLoader)this.cl, null);
        Assertions.assertThat((Object)backend).isEqualTo((Object)appBackend);
    }

    @Test
    void testLoadMemoryStateBackendNoParameters() throws Exception {
        Configuration config1 = new Configuration();
        config1.setString(this.backendKey, "jobmanager");
        Configuration config2 = new Configuration();
        config2.setString(this.backendKey, MemoryStateBackendFactory.class.getName());
        StateBackend backend1 = StateBackendLoader.loadStateBackendFromConfig((ReadableConfig)config1, (ClassLoader)this.cl, null);
        StateBackend backend2 = StateBackendLoader.loadStateBackendFromConfig((ReadableConfig)config2, (ClassLoader)this.cl, null);
        Assertions.assertThat((Object)backend1).isInstanceOf(MemoryStateBackend.class);
        Assertions.assertThat((Object)backend2).isInstanceOf(MemoryStateBackend.class);
    }

    @Test
    void testLoadMemoryStateWithParameters() throws Exception {
        String checkpointDir = new Path(TempDirUtils.newFolder((java.nio.file.Path)this.tmp).toURI()).toString();
        String savepointDir = new Path(TempDirUtils.newFolder((java.nio.file.Path)this.tmp).toURI()).toString();
        Path expectedCheckpointPath = new Path(checkpointDir);
        Path expectedSavepointPath = new Path(savepointDir);
        Configuration config1 = new Configuration();
        config1.setString(this.backendKey, "jobmanager");
        config1.set(CheckpointingOptions.CHECKPOINTS_DIRECTORY, (Object)checkpointDir);
        config1.set(CheckpointingOptions.SAVEPOINT_DIRECTORY, (Object)savepointDir);
        Configuration config2 = new Configuration();
        config2.setString(this.backendKey, MemoryStateBackendFactory.class.getName());
        config2.set(CheckpointingOptions.CHECKPOINTS_DIRECTORY, (Object)checkpointDir);
        config2.set(CheckpointingOptions.SAVEPOINT_DIRECTORY, (Object)savepointDir);
        MemoryStateBackend backend1 = (MemoryStateBackend)StateBackendLoader.loadStateBackendFromConfig((ReadableConfig)config1, (ClassLoader)this.cl, null);
        MemoryStateBackend backend2 = (MemoryStateBackend)StateBackendLoader.loadStateBackendFromConfig((ReadableConfig)config2, (ClassLoader)this.cl, null);
        Assertions.assertThat((Object)backend1).isNotNull();
        Assertions.assertThat((Object)backend2).isNotNull();
        Assertions.assertThat((Object)backend1.getCheckpointPath()).isEqualTo((Object)expectedCheckpointPath);
        Assertions.assertThat((Object)backend1.getSavepointPath()).isEqualTo((Object)expectedSavepointPath);
        Assertions.assertThat((Object)backend2.getCheckpointPath()).isEqualTo((Object)expectedCheckpointPath);
        Assertions.assertThat((Object)backend2.getSavepointPath()).isEqualTo((Object)expectedSavepointPath);
    }

    @Test
    void testConfigureMemoryStateBackend() throws Exception {
        String checkpointDir = new Path(TempDirUtils.newFolder((java.nio.file.Path)this.tmp).toURI()).toString();
        String savepointDir = new Path(TempDirUtils.newFolder((java.nio.file.Path)this.tmp).toURI()).toString();
        Path expectedCheckpointPath = new Path(checkpointDir);
        Path expectedSavepointPath = new Path(savepointDir);
        int maxSize = 100;
        MemoryStateBackend backend = new MemoryStateBackend(100);
        Configuration config = new Configuration();
        config.setString(this.backendKey, "filesystem");
        config.set(CheckpointingOptions.CHECKPOINTS_DIRECTORY, (Object)checkpointDir);
        config.set(CheckpointingOptions.SAVEPOINT_DIRECTORY, (Object)savepointDir);
        StateBackend loadedBackendFromClusterConfig = StateBackendLoader.fromApplicationOrConfigOrDefault((StateBackend)backend, (Configuration)new Configuration(), (Configuration)config, (ClassLoader)this.cl, null);
        Assertions.assertThat((Object)loadedBackendFromClusterConfig).isInstanceOf(MemoryStateBackend.class);
        MemoryStateBackend memBackend1 = (MemoryStateBackend)loadedBackendFromClusterConfig;
        Assertions.assertThat((Object)memBackend1.getCheckpointPath()).isEqualTo((Object)expectedCheckpointPath);
        Assertions.assertThat((Object)memBackend1.getSavepointPath()).isEqualTo((Object)expectedSavepointPath);
        Assertions.assertThat((int)memBackend1.getMaxStateSize()).isEqualTo(100);
        StateBackend loadedBackendFromJobConfig = StateBackendLoader.fromApplicationOrConfigOrDefault((StateBackend)backend, (Configuration)config, (Configuration)new Configuration(), (ClassLoader)this.cl, null);
        Assertions.assertThat((Object)loadedBackendFromJobConfig).isInstanceOf(MemoryStateBackend.class);
        MemoryStateBackend memBackend2 = (MemoryStateBackend)loadedBackendFromJobConfig;
        Assertions.assertThat((Object)memBackend2.getCheckpointPath()).isNull();
        Assertions.assertThat((Object)memBackend2.getSavepointPath()).isNull();
        Assertions.assertThat((int)memBackend2.getMaxStateSize()).isEqualTo(100);
    }

    @Test
    void testConfigureMemoryStateBackendMixed() throws Exception {
        String appCheckpointDir = new Path(TempDirUtils.newFolder((java.nio.file.Path)this.tmp).toURI()).toString();
        String checkpointDir = new Path(TempDirUtils.newFolder((java.nio.file.Path)this.tmp).toURI()).toString();
        String savepointDir = new Path(TempDirUtils.newFolder((java.nio.file.Path)this.tmp).toURI()).toString();
        Path expectedCheckpointPath = new Path(appCheckpointDir);
        Path expectedSavepointPath = new Path(savepointDir);
        MemoryStateBackend backend = new MemoryStateBackend(appCheckpointDir, null);
        Configuration config = new Configuration();
        config.setString(this.backendKey, "filesystem");
        config.set(CheckpointingOptions.CHECKPOINTS_DIRECTORY, (Object)checkpointDir);
        config.set(CheckpointingOptions.SAVEPOINT_DIRECTORY, (Object)savepointDir);
        StateBackend loadedBackendFromJobConfig = StateBackendLoader.fromApplicationOrConfigOrDefault((StateBackend)backend, (Configuration)new Configuration(), (Configuration)config, (ClassLoader)this.cl, null);
        Assertions.assertThat((Object)loadedBackendFromJobConfig).isInstanceOf(MemoryStateBackend.class);
        MemoryStateBackend memBackend1 = (MemoryStateBackend)loadedBackendFromJobConfig;
        Assertions.assertThat((Object)memBackend1.getCheckpointPath()).isEqualTo((Object)expectedCheckpointPath);
        Assertions.assertThat((Object)memBackend1.getSavepointPath()).isEqualTo((Object)expectedSavepointPath);
        StateBackend loadedBackendFromClusterConfig = StateBackendLoader.fromApplicationOrConfigOrDefault((StateBackend)backend, (Configuration)config, (Configuration)new Configuration(), (ClassLoader)this.cl, null);
        Assertions.assertThat((Object)loadedBackendFromClusterConfig).isInstanceOf(MemoryStateBackend.class);
        MemoryStateBackend memBackend2 = (MemoryStateBackend)loadedBackendFromClusterConfig;
        Assertions.assertThat((Object)memBackend2.getCheckpointPath()).isEqualTo((Object)expectedCheckpointPath);
        Assertions.assertThat((Object)memBackend2.getSavepointPath()).isNull();
    }

    @Test
    void testLoadFileSystemStateBackend() throws Exception {
        String checkpointDir = new Path(TempDirUtils.newFolder((java.nio.file.Path)this.tmp).toURI()).toString();
        String savepointDir = new Path(TempDirUtils.newFolder((java.nio.file.Path)this.tmp).toURI()).toString();
        Path expectedCheckpointsPath = new Path(checkpointDir);
        Path expectedSavepointsPath = new Path(savepointDir);
        MemorySize threshold = MemorySize.parse((String)"900kb");
        int minWriteBufferSize = 1024;
        Configuration config1 = new Configuration();
        config1.setString(this.backendKey, "filesystem");
        config1.set(CheckpointingOptions.CHECKPOINTS_DIRECTORY, (Object)checkpointDir);
        config1.set(CheckpointingOptions.SAVEPOINT_DIRECTORY, (Object)savepointDir);
        config1.set(CheckpointingOptions.FS_SMALL_FILE_THRESHOLD, (Object)threshold);
        config1.set(CheckpointingOptions.FS_WRITE_BUFFER_SIZE, (Object)1024);
        Configuration config2 = new Configuration();
        config2.setString(this.backendKey, FsStateBackendFactory.class.getName());
        config2.set(CheckpointingOptions.CHECKPOINTS_DIRECTORY, (Object)checkpointDir);
        config2.set(CheckpointingOptions.SAVEPOINT_DIRECTORY, (Object)savepointDir);
        config2.set(CheckpointingOptions.FS_SMALL_FILE_THRESHOLD, (Object)threshold);
        config1.set(CheckpointingOptions.FS_WRITE_BUFFER_SIZE, (Object)1024);
        StateBackend backend1 = StateBackendLoader.loadStateBackendFromConfig((ReadableConfig)config1, (ClassLoader)this.cl, null);
        StateBackend backend2 = StateBackendLoader.loadStateBackendFromConfig((ReadableConfig)config2, (ClassLoader)this.cl, null);
        Assertions.assertThat((Object)backend1).isInstanceOf(HashMapStateBackend.class);
        Assertions.assertThat((Object)backend2).isInstanceOf(FsStateBackend.class);
        HashMapStateBackend fs1 = (HashMapStateBackend)backend1;
        FsStateBackend fs2 = (FsStateBackend)backend2;
        Assertions.assertThat((Object)fs2.getCheckpointPath()).isEqualTo((Object)expectedCheckpointsPath);
        Assertions.assertThat((Object)fs2.getSavepointPath()).isEqualTo((Object)expectedSavepointsPath);
        Assertions.assertThat((int)fs2.getMinFileSizeThreshold()).isEqualTo(threshold.getBytes());
        Assertions.assertThat((int)fs2.getWriteBufferSize()).isEqualTo(Math.max(threshold.getBytes(), 1024L));
    }

    @Test
    void testLoadFileSystemStateBackendMixed() throws Exception {
        String appCheckpointDir = new Path(TempDirUtils.newFolder((java.nio.file.Path)this.tmp).toURI()).toString();
        String checkpointDir = new Path(TempDirUtils.newFolder((java.nio.file.Path)this.tmp).toURI()).toString();
        String savepointDir = new Path(TempDirUtils.newFolder((java.nio.file.Path)this.tmp).toURI()).toString();
        Path expectedCheckpointsPath = new Path(new URI(appCheckpointDir));
        Path expectedSavepointsPath = new Path(savepointDir);
        int threshold = 1000000;
        int writeBufferSize = 4000000;
        FsStateBackend backend = new FsStateBackend(new URI(appCheckpointDir), null, 1000000, 4000000, TernaryBoolean.TRUE);
        Configuration config = new Configuration();
        config.setString(this.backendKey, "jobmanager");
        config.set(CheckpointingOptions.CHECKPOINTS_DIRECTORY, (Object)checkpointDir);
        config.set(CheckpointingOptions.SAVEPOINT_DIRECTORY, (Object)savepointDir);
        config.set(CheckpointingOptions.FS_SMALL_FILE_THRESHOLD, (Object)MemorySize.parse((String)"20"));
        config.set(CheckpointingOptions.FS_WRITE_BUFFER_SIZE, (Object)3000000);
        StateBackend loadedBackend = StateBackendLoader.fromApplicationOrConfigOrDefault((StateBackend)backend, (Configuration)config, (Configuration)config, (ClassLoader)this.cl, null);
        Assertions.assertThat((Object)loadedBackend).isInstanceOf(FsStateBackend.class);
        FsStateBackend fs = (FsStateBackend)loadedBackend;
        Assertions.assertThat((Object)fs.getCheckpointPath()).isEqualTo((Object)expectedCheckpointsPath);
        Assertions.assertThat((Object)fs.getSavepointPath()).isEqualTo((Object)expectedSavepointsPath);
        Assertions.assertThat((int)fs.getMinFileSizeThreshold()).isEqualTo(1000000);
        Assertions.assertThat((int)fs.getWriteBufferSize()).isEqualTo(4000000);
    }

    @Test
    void testLoadingFails() throws Exception {
        Configuration config = new Configuration();
        config.setString(this.backendKey, "does.not.exist");
        Assertions.assertThatThrownBy(() -> StateBackendLoader.fromApplicationOrConfigOrDefault(null, (Configuration)config, (Configuration)new Configuration(), (ClassLoader)this.cl, null)).isInstanceOf(DynamicCodeLoadingException.class);
        config.setString(this.backendKey, File.class.getName());
        Assertions.assertThatThrownBy(() -> StateBackendLoader.fromApplicationOrConfigOrDefault(null, (Configuration)config, (Configuration)new Configuration(), (ClassLoader)this.cl, null)).isInstanceOf(DynamicCodeLoadingException.class);
        config.setString(this.backendKey, FailingFactory.class.getName());
        Assertions.assertThatThrownBy(() -> StateBackendLoader.fromApplicationOrConfigOrDefault(null, (Configuration)config, (Configuration)new Configuration(), (ClassLoader)this.cl, null)).isInstanceOf(IOException.class);
    }

    @Test
    void testHighAvailabilityDefault() throws Exception {
        String haPersistenceDir = new Path(TempDirUtils.newFolder((java.nio.file.Path)this.tmp).toURI()).toString();
        this.testMemoryBackendHighAvailabilityDefault(haPersistenceDir, null);
        Path checkpointPath = new Path(TempDirUtils.newFolder((java.nio.file.Path)this.tmp).toURI().toString());
        this.testMemoryBackendHighAvailabilityDefault(haPersistenceDir, checkpointPath);
    }

    @Test
    void testHighAvailabilityDefaultLocalPaths() throws Exception {
        String haPersistenceDir = new Path(TempDirUtils.newFolder((java.nio.file.Path)this.tmp).getAbsolutePath()).toString();
        this.testMemoryBackendHighAvailabilityDefault(haPersistenceDir, null);
        Path checkpointPath = new Path(TempDirUtils.newFolder((java.nio.file.Path)this.tmp).toURI().toString()).makeQualified(FileSystem.getLocalFileSystem());
        this.testMemoryBackendHighAvailabilityDefault(haPersistenceDir, checkpointPath);
    }

    private void testMemoryBackendHighAvailabilityDefault(String haPersistenceDir, Path checkpointPath) throws Exception {
        Configuration config1 = new Configuration();
        config1.set(HighAvailabilityOptions.HA_MODE, (Object)"zookeeper");
        config1.set(HighAvailabilityOptions.HA_CLUSTER_ID, (Object)"myCluster");
        config1.set(HighAvailabilityOptions.HA_STORAGE_PATH, (Object)haPersistenceDir);
        Configuration config2 = new Configuration();
        config2.setString(this.backendKey, "jobmanager");
        config2.set(HighAvailabilityOptions.HA_MODE, (Object)"zookeeper");
        config2.set(HighAvailabilityOptions.HA_CLUSTER_ID, (Object)"myCluster");
        config2.set(HighAvailabilityOptions.HA_STORAGE_PATH, (Object)haPersistenceDir);
        if (checkpointPath != null) {
            config1.set(CheckpointingOptions.CHECKPOINTS_DIRECTORY, (Object)checkpointPath.toUri().toString());
            config2.set(CheckpointingOptions.CHECKPOINTS_DIRECTORY, (Object)checkpointPath.toUri().toString());
        }
        MemoryStateBackend appBackend = new MemoryStateBackend();
        StateBackend loaded1 = StateBackendLoader.fromApplicationOrConfigOrDefault((StateBackend)appBackend, (Configuration)new Configuration(), (Configuration)config1, (ClassLoader)this.cl, null);
        StateBackend loaded2 = StateBackendLoader.fromApplicationOrConfigOrDefault(null, (Configuration)new Configuration(), (Configuration)config1, (ClassLoader)this.cl, null);
        StateBackend loaded3 = StateBackendLoader.fromApplicationOrConfigOrDefault(null, (Configuration)new Configuration(), (Configuration)config2, (ClassLoader)this.cl, null);
        Assertions.assertThat((Object)loaded1).isInstanceOf(MemoryStateBackend.class);
        Assertions.assertThat((Object)loaded2).isInstanceOf(HashMapStateBackend.class);
        Assertions.assertThat((Object)loaded3).isInstanceOf(MemoryStateBackend.class);
        MemoryStateBackend memBackend1 = (MemoryStateBackend)loaded1;
        MemoryStateBackend memBackend2 = (MemoryStateBackend)loaded3;
        Assertions.assertThat((Object)memBackend1.getSavepointPath()).isNull();
        if (checkpointPath != null) {
            Assertions.assertThat((Object)memBackend1.getCheckpointPath()).isNotNull();
            Assertions.assertThat((Object)memBackend2.getCheckpointPath()).isNotNull();
            Assertions.assertThat((Object)memBackend1.getCheckpointPath()).isEqualTo((Object)checkpointPath);
            Assertions.assertThat((Object)memBackend2.getCheckpointPath()).isEqualTo((Object)checkpointPath);
        } else {
            Assertions.assertThat((Object)memBackend1.getCheckpointPath()).isNull();
            Assertions.assertThat((Object)memBackend2.getCheckpointPath()).isNull();
        }
    }

    static final class FailingFactory
    implements StateBackendFactory<StateBackend> {
        FailingFactory() {
        }

        public StateBackend createFromConfig(ReadableConfig config, ClassLoader classLoader) throws IOException {
            throw new IOException("fail!");
        }
    }
}

