/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.UUID;
import org.apache.flink.runtime.state.DirectoryStateHandle;
import org.apache.flink.runtime.state.SnapshotDirectory;
import org.apache.flink.util.FileUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class SnapshotDirectoryTest {
    @TempDir
    private Path temporaryFolder;

    SnapshotDirectoryTest() {
    }

    @Test
    void mkdirs() throws Exception {
        File folderRoot = this.temporaryFolder.toFile();
        File newFolder = new File(folderRoot, String.valueOf(UUID.randomUUID()));
        File innerNewFolder = new File(newFolder, String.valueOf(UUID.randomUUID()));
        Path path = innerNewFolder.toPath();
        Assertions.assertThat((File)newFolder).doesNotExist();
        Assertions.assertThat((File)innerNewFolder).doesNotExist();
        SnapshotDirectory snapshotDirectory = SnapshotDirectory.permanent((Path)path);
        Assertions.assertThat((boolean)snapshotDirectory.exists()).isFalse();
        Assertions.assertThat((File)newFolder).doesNotExist();
        Assertions.assertThat((File)innerNewFolder).doesNotExist();
        Assertions.assertThat((boolean)snapshotDirectory.mkdirs()).isTrue();
        Assertions.assertThat((File)newFolder).isDirectory();
        Assertions.assertThat((File)innerNewFolder).isDirectory();
        Assertions.assertThat((boolean)snapshotDirectory.exists()).isTrue();
    }

    @Test
    void exists() throws Exception {
        File folderRoot = this.temporaryFolder.toFile();
        File folderA = new File(folderRoot, String.valueOf(UUID.randomUUID()));
        Assertions.assertThat((File)folderA).doesNotExist();
        Path path = folderA.toPath();
        SnapshotDirectory snapshotDirectory = SnapshotDirectory.permanent((Path)path);
        Assertions.assertThat((boolean)snapshotDirectory.exists()).isFalse();
        Assertions.assertThat((boolean)folderA.mkdirs()).isTrue();
        Assertions.assertThat((boolean)snapshotDirectory.exists()).isTrue();
        Assertions.assertThat((boolean)folderA.delete()).isTrue();
        Assertions.assertThat((boolean)snapshotDirectory.exists()).isFalse();
    }

    @Test
    void listStatus() throws Exception {
        File folderRoot = this.temporaryFolder.toFile();
        File folderA = new File(folderRoot, String.valueOf(UUID.randomUUID()));
        File folderB = new File(folderA, String.valueOf(UUID.randomUUID()));
        Assertions.assertThat((boolean)folderB.mkdirs()).isTrue();
        File file = new File(folderA, "test.txt");
        Assertions.assertThat((boolean)file.createNewFile()).isTrue();
        Path path = folderA.toPath();
        SnapshotDirectory snapshotDirectory = SnapshotDirectory.permanent((Path)path);
        Assertions.assertThat((boolean)snapshotDirectory.exists()).isTrue();
        Assertions.assertThat((String)Arrays.toString(snapshotDirectory.listDirectory())).isEqualTo(Arrays.toString(snapshotDirectory.listDirectory()));
        Assertions.assertThat((String)Arrays.toString(snapshotDirectory.listDirectory())).isEqualTo(Arrays.toString(FileUtils.listDirectory((Path)path)));
    }

    @Test
    void completeSnapshotAndGetHandle() throws Exception {
        File folderRoot = this.temporaryFolder.toFile();
        File folderA = new File(folderRoot, String.valueOf(UUID.randomUUID()));
        Assertions.assertThat((boolean)folderA.mkdirs()).isTrue();
        Path folderAPath = folderA.toPath();
        SnapshotDirectory snapshotDirectory = SnapshotDirectory.permanent((Path)folderAPath);
        DirectoryStateHandle handle = snapshotDirectory.completeSnapshotAndGetHandle();
        Assertions.assertThat((Object)handle).isNotNull();
        Assertions.assertThat((boolean)snapshotDirectory.cleanup()).isTrue();
        Assertions.assertThat((File)folderA).isDirectory();
        Assertions.assertThat((Path)handle.getDirectory()).isEqualTo((Object)folderAPath);
        handle.discardState();
        Assertions.assertThat((File)folderA).doesNotExist();
        Assertions.assertThat((boolean)folderA.mkdirs()).isTrue();
        SnapshotDirectory newSnapshotDirectory = SnapshotDirectory.permanent((Path)folderAPath);
        Assertions.assertThat((boolean)newSnapshotDirectory.cleanup()).isTrue();
        Assertions.assertThatThrownBy(() -> ((SnapshotDirectory)newSnapshotDirectory).completeSnapshotAndGetHandle()).isInstanceOf(IOException.class);
    }

    @Test
    void deleteIfNotCompeltedSnapshot() throws Exception {
        File folderRoot = this.temporaryFolder.toFile();
        File folderA = new File(folderRoot, String.valueOf(UUID.randomUUID()));
        File folderB = new File(folderA, String.valueOf(UUID.randomUUID()));
        Assertions.assertThat((boolean)folderB.mkdirs()).isTrue();
        File file = new File(folderA, "test.txt");
        Assertions.assertThat((boolean)file.createNewFile()).isTrue();
        Path folderAPath = folderA.toPath();
        SnapshotDirectory snapshotDirectory = SnapshotDirectory.permanent((Path)folderAPath);
        Assertions.assertThat((boolean)snapshotDirectory.cleanup()).isTrue();
        Assertions.assertThat((File)folderA).doesNotExist();
        Assertions.assertThat((boolean)folderA.mkdirs()).isTrue();
        Assertions.assertThat((boolean)file.createNewFile()).isTrue();
        snapshotDirectory = SnapshotDirectory.permanent((Path)folderAPath);
        snapshotDirectory.completeSnapshotAndGetHandle();
        Assertions.assertThat((boolean)snapshotDirectory.cleanup()).isTrue();
        Assertions.assertThat((File)folderA).isDirectory();
        Assertions.assertThat((File)file).exists();
    }

    @Test
    void isSnapshotOngoing() throws Exception {
        File folderRoot = this.temporaryFolder.toFile();
        File folderA = new File(folderRoot, String.valueOf(UUID.randomUUID()));
        Assertions.assertThat((boolean)folderA.mkdirs()).isTrue();
        Path pathA = folderA.toPath();
        SnapshotDirectory snapshotDirectory = SnapshotDirectory.permanent((Path)pathA);
        Assertions.assertThat((boolean)snapshotDirectory.isSnapshotCompleted()).isFalse();
        Assertions.assertThat((Object)snapshotDirectory.completeSnapshotAndGetHandle()).isNotNull();
        Assertions.assertThat((boolean)snapshotDirectory.isSnapshotCompleted()).isTrue();
        snapshotDirectory = SnapshotDirectory.permanent((Path)pathA);
        Assertions.assertThat((boolean)snapshotDirectory.isSnapshotCompleted()).isFalse();
        snapshotDirectory.cleanup();
        Assertions.assertThat((boolean)snapshotDirectory.isSnapshotCompleted()).isFalse();
    }

    @Test
    void temporary() throws Exception {
        File folderRoot = this.temporaryFolder.toFile();
        File folder = new File(folderRoot, String.valueOf(UUID.randomUUID()));
        Assertions.assertThat((boolean)folder.mkdirs()).isTrue();
        SnapshotDirectory tmpSnapshotDirectory = SnapshotDirectory.temporary((File)folder);
        Assertions.assertThat((Object)tmpSnapshotDirectory.completeSnapshotAndGetHandle()).isNull();
        Assertions.assertThat((boolean)tmpSnapshotDirectory.cleanup()).isTrue();
        Assertions.assertThat((File)folder).doesNotExist();
    }
}

