/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.source.coordinator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.api.connector.source.SplitsAssignment;
import org.apache.flink.api.connector.source.mocks.MockSourceSplit;
import org.apache.flink.runtime.source.coordinator.SourceCoordinatorContext;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.function.ThrowingRunnable;
import org.assertj.core.api.Assertions;

class CoordinatorTestUtils {
    CoordinatorTestUtils() {
    }

    static SplitsAssignment<MockSourceSplit> getSplitsAssignment(int numSubtasks, int startingSplitId) {
        HashMap assignments = new HashMap();
        int splitId = startingSplitId;
        for (int subtaskIndex = 0; subtaskIndex < numSubtasks; ++subtaskIndex) {
            ArrayList<MockSourceSplit> subtaskAssignment = new ArrayList<MockSourceSplit>();
            for (int j = 0; j < subtaskIndex + 1; ++j) {
                subtaskAssignment.add(new MockSourceSplit(splitId++));
            }
            assignments.put(subtaskIndex, subtaskAssignment);
        }
        return new SplitsAssignment(assignments);
    }

    static void verifyAssignment(List<String> expectedSplitIds, Collection<MockSourceSplit> actualAssignment) {
        Assertions.assertThat((int)actualAssignment.size()).isEqualTo(expectedSplitIds.size());
        int i = 0;
        for (MockSourceSplit split : actualAssignment) {
            Assertions.assertThat((String)split.splitId()).isEqualTo(expectedSplitIds.get(i++));
        }
    }

    static void verifyException(ThrowingRunnable<Throwable> runnable, String failureMessage, String errorMessage) {
        Assertions.assertThatThrownBy(() -> runnable.run(), (String)failureMessage, (Object[])new Object[0]).hasStackTraceContaining(errorMessage);
    }

    static void waitForCoordinatorToProcessActions(SourceCoordinatorContext<?> context) {
        CompletableFuture future = new CompletableFuture();
        context.runInCoordinatorThread(() -> future.complete(null));
        try {
            future.get();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)"test interrupted");
        }
        catch (ExecutionException e) {
            ExceptionUtils.rethrow((Throwable)ExceptionUtils.stripExecutionException((Throwable)e));
        }
    }
}

