/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security.token.hadoop;

import java.io.IOException;
import org.apache.flink.runtime.security.token.hadoop.HadoopDelegationTokenConverter;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HadoopDelegationTokenConverterTest {
    @Test
    public void testRoundTrip() throws IOException, ClassNotFoundException {
        Text tokenKind = new Text("TEST_TOKEN_KIND");
        Text tokenService = new Text("TEST_TOKEN_SERVICE");
        Credentials credentials = new Credentials();
        credentials.addToken(tokenService, new Token(new byte[4], new byte[4], tokenKind, tokenService));
        byte[] credentialsBytes = HadoopDelegationTokenConverter.serialize((Credentials)credentials);
        Credentials deserializedCredentials = HadoopDelegationTokenConverter.deserialize((byte[])credentialsBytes);
        Assertions.assertEquals((int)1, (int)credentials.getAllTokens().size());
        Assertions.assertEquals((int)1, (int)deserializedCredentials.getAllTokens().size());
        Assertions.assertNotNull((Object)credentials.getToken(tokenService));
        Assertions.assertNotNull((Object)deserializedCredentials.getToken(tokenService));
    }
}

