/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.strategy;

import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.SchedulingPipelinedRegion;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingResultPartition;

public class TestingSchedulingPipelinedRegion
implements SchedulingPipelinedRegion {
    private final Map<ExecutionVertexID, TestingSchedulingExecutionVertex> regionVertices = new HashMap<ExecutionVertexID, TestingSchedulingExecutionVertex>();
    private final Set<ConsumedPartitionGroup> blockingConsumedPartitionGroups = Collections.newSetFromMap(new IdentityHashMap());
    private final Set<ConsumedPartitionGroup> releaseBySchedulerConsumedPartitionGroups = Collections.newSetFromMap(new IdentityHashMap());

    public TestingSchedulingPipelinedRegion(Set<TestingSchedulingExecutionVertex> vertices) {
        HashMap<IntermediateResultPartitionID, TestingSchedulingResultPartition> resultPartitionsById = new HashMap<IntermediateResultPartitionID, TestingSchedulingResultPartition>();
        for (TestingSchedulingExecutionVertex vertex : vertices) {
            this.regionVertices.put(vertex.getId(), vertex);
            for (TestingSchedulingResultPartition consumedPartition : vertex.getConsumedResults()) {
                resultPartitionsById.putIfAbsent(consumedPartition.getId(), consumedPartition);
            }
            for (ConsumedPartitionGroup consumedGroup : vertex.getConsumedPartitionGroups()) {
                IntermediateResultPartitionID consumerId;
                TestingSchedulingResultPartition rp;
                Iterator iterator = consumedGroup.iterator();
                if (!iterator.hasNext() || vertices.contains((rp = (TestingSchedulingResultPartition)resultPartitionsById.get(consumerId = (IntermediateResultPartitionID)iterator.next())).getProducer())) continue;
                if (!rp.getResultType().canBePipelinedConsumed()) {
                    this.blockingConsumedPartitionGroups.add(consumedGroup);
                }
                if (!rp.getResultType().isReleaseByScheduler()) continue;
                this.releaseBySchedulerConsumedPartitionGroups.add(consumedGroup);
            }
        }
    }

    public Iterable<TestingSchedulingExecutionVertex> getVertices() {
        return Collections.unmodifiableCollection(this.regionVertices.values());
    }

    public TestingSchedulingExecutionVertex getVertex(ExecutionVertexID vertexId) {
        TestingSchedulingExecutionVertex executionVertex = this.regionVertices.get(vertexId);
        if (executionVertex == null) {
            throw new IllegalArgumentException(String.format("Execution vertex %s not found in pipelined region", vertexId));
        }
        return executionVertex;
    }

    public Iterable<ConsumedPartitionGroup> getAllNonPipelinedConsumedPartitionGroups() {
        return Collections.unmodifiableSet(this.blockingConsumedPartitionGroups);
    }

    public Iterable<ConsumedPartitionGroup> getAllReleaseBySchedulerConsumedPartitionGroups() {
        return Collections.unmodifiableSet(this.releaseBySchedulerConsumedPartitionGroups);
    }

    public boolean contains(ExecutionVertexID vertexId) {
        return this.regionVertices.containsKey(vertexId);
    }
}

