/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.flink.runtime.rest.messages.RestResponseMarshallingTestBase;
import org.apache.flink.runtime.rest.messages.ThreadDumpInfo;
import org.apache.flink.testutils.junit.extensions.parameterized.NoOpTestExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={NoOpTestExtension.class})
class ThreadDumpInfoTest
extends RestResponseMarshallingTestBase<ThreadDumpInfo> {
    ThreadDumpInfoTest() {
    }

    @Override
    protected Class<ThreadDumpInfo> getTestResponseClass() {
        return ThreadDumpInfo.class;
    }

    @Override
    protected ThreadDumpInfo getTestResponseInstance() throws Exception {
        List<ThreadDumpInfo.ThreadInfo> threadInfos = Arrays.asList(ThreadDumpInfo.ThreadInfo.create((String)"foobar", (String)"barfoo"), ThreadDumpInfo.ThreadInfo.create((String)"bar", (String)"foo"));
        return ThreadDumpInfo.create(threadInfos);
    }

    @Override
    protected void assertOriginalEqualsToUnmarshalled(ThreadDumpInfo expected, ThreadDumpInfo actual) {
        Assertions.assertThat((Collection)actual.getThreadInfos()).isEqualTo(Arrays.asList(expected.getThreadInfos().toArray()));
    }

    @Test
    void testComparedWithDefaultJDKImplemetation() {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        ThreadInfo threadInfo = threadMxBean.getThreadInfo(Thread.currentThread().getId(), Integer.MAX_VALUE);
        String[] threadInfoLines = threadInfo.toString().split("\n");
        String[] expected = Arrays.copyOfRange(threadInfoLines, 1, threadInfoLines.length);
        String stringifyThreadInfo = ThreadDumpInfo.stringifyThreadInfo((ThreadInfo)threadInfo, (int)8);
        String[] stringifyThreadInfoLines = stringifyThreadInfo.split("\n");
        Object[] stringified = Arrays.copyOfRange(stringifyThreadInfoLines, 1, stringifyThreadInfoLines.length);
        Assertions.assertThat((Object[])stringified).isEqualTo((Object)expected);
    }

    @Test
    void testStacktraceDepthLimitation() {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        ThreadInfo threadInfo = threadMxBean.getThreadInfo(Thread.currentThread().getId(), Integer.MAX_VALUE);
        int expectedStacktraceDepth = threadInfo.getStackTrace().length;
        String stringifiedInfo = ThreadDumpInfo.stringifyThreadInfo((ThreadInfo)threadInfo, (int)Integer.MAX_VALUE);
        Assertions.assertThat((long)this.getOutputDepth(stringifiedInfo)).isEqualTo((long)expectedStacktraceDepth);
        String stringifiedInfoExceedMaxDepth = ThreadDumpInfo.stringifyThreadInfo((ThreadInfo)threadInfo, (int)(expectedStacktraceDepth - 1));
        Assertions.assertThat((long)this.getOutputDepth(stringifiedInfoExceedMaxDepth)).isEqualTo((long)(expectedStacktraceDepth - 1));
        Assertions.assertThat((boolean)stringifiedInfoExceedMaxDepth.contains("\t...")).isTrue();
    }

    private long getOutputDepth(String stringifiedInfo) {
        return Arrays.stream(stringifiedInfo.split("\n")).filter(x -> x.contains("\tat ")).count();
    }
}

