/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.router;

import org.apache.flink.runtime.rest.handler.router.MultipartRoutes;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class MultipartRoutesTest {
    @Test
    public void testRoutePatternMatching() {
        MultipartRoutes.Builder builder = new MultipartRoutes.Builder();
        builder.addPostRoute("/jobs");
        builder.addPostRoute("/jobs/:jobid/stop");
        builder.addPostRoute("/jobs/:jobid/savepoints/:savepointid/delete");
        builder.addFileUploadRoute("/jobs");
        builder.addFileUploadRoute("/jobs/:jobid/stop");
        builder.addFileUploadRoute("/jobs/:jobid/savepoints/:savepointid/delete");
        MultipartRoutes routes = builder.build();
        Assertions.assertThat((boolean)routes.isPostRoute("/jobs")).isTrue();
        Assertions.assertThat((boolean)routes.isPostRoute("/jobs?q1=p1&q2=p2")).isTrue();
        Assertions.assertThat((boolean)routes.isPostRoute("/jobs/abc")).isFalse();
        Assertions.assertThat((boolean)routes.isPostRoute("/jobs/abc/stop")).isTrue();
        Assertions.assertThat((boolean)routes.isPostRoute("/jobs/abc/savepoints/def/delete")).isTrue();
        Assertions.assertThat((boolean)routes.isFileUploadRoute("/jobs")).isTrue();
        Assertions.assertThat((boolean)routes.isFileUploadRoute("/jobs?q1=p1&q2=p2")).isTrue();
        Assertions.assertThat((boolean)routes.isFileUploadRoute("/jobs/abc")).isFalse();
        Assertions.assertThat((boolean)routes.isFileUploadRoute("/jobs/abc/stop")).isTrue();
        Assertions.assertThat((boolean)routes.isFileUploadRoute("/jobs/abc/savepoints/def/delete")).isTrue();
    }
}

