/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ArchivedExecution;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionVertex;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.ExecutionHistory;
import org.apache.flink.runtime.failure.FailureEnricherUtils;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.HandlerRequestException;
import org.apache.flink.runtime.rest.handler.job.JobExceptionsHandler;
import org.apache.flink.runtime.rest.handler.legacy.DefaultExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedExecutionGraphBuilder;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobExceptionsHeaders;
import org.apache.flink.runtime.rest.messages.JobExceptionsInfoWithHistory;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.job.JobExceptionsMessageParameters;
import org.apache.flink.runtime.scheduler.ExecutionGraphInfo;
import org.apache.flink.runtime.scheduler.exceptionhistory.ExceptionHistoryEntry;
import org.apache.flink.runtime.scheduler.exceptionhistory.RootExceptionHistoryEntry;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.SerializedThrowable;
import org.apache.flink.util.concurrent.Executors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.HamcrestCondition;
import org.assertj.core.api.ListAssert;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.collection.IsEmptyIterable;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.hamcrest.collection.IsIterableWithSize;
import org.junit.jupiter.api.Test;

class JobExceptionsHandlerTest {
    private final JobExceptionsHandler testInstance = new JobExceptionsHandler(CompletableFuture::new, TestingUtils.TIMEOUT, Collections.emptyMap(), (MessageHeaders)JobExceptionsHeaders.getInstance(), (ExecutionGraphCache)new DefaultExecutionGraphCache(TestingUtils.TIMEOUT, TestingUtils.TIMEOUT), Executors.directExecutor());

    JobExceptionsHandlerTest() {
    }

    @Test
    void testNoExceptions() throws HandlerRequestException {
        ExecutionGraphInfo executionGraphInfo = new ExecutionGraphInfo(new ArchivedExecutionGraphBuilder().build());
        HandlerRequest<EmptyRequestBody> request = JobExceptionsHandlerTest.createRequest(executionGraphInfo.getJobId(), 10);
        JobExceptionsInfoWithHistory response = this.testInstance.handleRequest(request, executionGraphInfo);
        Assertions.assertThat((String)response.getRootException()).isNull();
        Assertions.assertThat((Long)response.getRootTimestamp()).isNull();
        Assertions.assertThat((boolean)response.isTruncated()).isFalse();
        Assertions.assertThat((List)response.getAllExceptions()).isEmpty();
        Assertions.assertThat((List)response.getExceptionHistory().getEntries()).isEmpty();
    }

    @Test
    void testOnlyRootCause() throws HandlerRequestException, ExecutionException, InterruptedException {
        RuntimeException rootCause = new RuntimeException("root cause");
        long rootCauseTimestamp = System.currentTimeMillis();
        ExecutionGraphInfo executionGraphInfo = JobExceptionsHandlerTest.createExecutionGraphInfo(JobExceptionsHandlerTest.fromGlobalFailure(rootCause, rootCauseTimestamp));
        HandlerRequest<EmptyRequestBody> request = JobExceptionsHandlerTest.createRequest(executionGraphInfo.getJobId(), 10);
        JobExceptionsInfoWithHistory response = this.testInstance.handleRequest(request, executionGraphInfo);
        Assertions.assertThat((String)response.getRootException()).isEqualTo(ExceptionUtils.stringifyException((Throwable)rootCause));
        Assertions.assertThat((Long)response.getRootTimestamp()).isEqualTo(rootCauseTimestamp);
        Assertions.assertThat((boolean)response.isTruncated()).isFalse();
        Assertions.assertThat((List)response.getAllExceptions()).isEmpty();
        Assertions.assertThat((List)response.getExceptionHistory().getEntries()).satisfies((Condition)HamcrestCondition.matching((Matcher)Matchers.contains(JobExceptionsHandlerTest.historyContainsGlobalFailure(rootCause, rootCauseTimestamp, new Matcher[0]))));
    }

    @Test
    void testOnlyExceptionHistory() throws HandlerRequestException, ExecutionException, InterruptedException {
        RuntimeException rootThrowable = new RuntimeException("exception #0");
        long rootTimestamp = System.currentTimeMillis();
        RootExceptionHistoryEntry rootEntry = JobExceptionsHandlerTest.fromGlobalFailure(rootThrowable, rootTimestamp);
        ExecutionGraphInfo executionGraphInfo = JobExceptionsHandlerTest.createExecutionGraphInfoWithoutFailureCause(rootEntry);
        HandlerRequest<EmptyRequestBody> request = JobExceptionsHandlerTest.createRequest(executionGraphInfo.getJobId(), 10);
        JobExceptionsInfoWithHistory response = this.testInstance.handleRequest(request, executionGraphInfo);
        Assertions.assertThat((String)response.getRootException()).isNull();
        Assertions.assertThat((Long)response.getRootTimestamp()).isNull();
        Assertions.assertThat((List)response.getExceptionHistory().getEntries()).satisfies((Condition)HamcrestCondition.matching((Matcher)Matchers.contains(JobExceptionsHandlerTest.historyContainsGlobalFailure(rootThrowable, rootTimestamp, new Matcher[0]))));
    }

    @Test
    void testOnlyExceptionHistoryWithNoMatchingFailureLabel() throws HandlerRequestException {
        RuntimeException rootThrowable = new RuntimeException("exception #0");
        long rootTimestamp = System.currentTimeMillis();
        RootExceptionHistoryEntry rootEntry = JobExceptionsHandlerTest.fromGlobalFailure(rootThrowable, rootTimestamp);
        ExecutionGraphInfo executionGraphInfo = JobExceptionsHandlerTest.createExecutionGraphInfoWithoutFailureCause(rootEntry);
        HandlerRequest<EmptyRequestBody> request = JobExceptionsHandlerTest.createRequest(executionGraphInfo.getJobId(), 10, Arrays.asList("key:value"));
        JobExceptionsInfoWithHistory response = this.testInstance.handleRequest(request, executionGraphInfo);
        Assertions.assertThat((String)response.getRootException()).isNull();
        Assertions.assertThat((Long)response.getRootTimestamp()).isNull();
        Assertions.assertThat((List)response.getExceptionHistory().getEntries()).isEmpty();
    }

    @Test
    void testWithExceptionHistory() throws HandlerRequestException, ExecutionException, InterruptedException {
        RootExceptionHistoryEntry rootCause = JobExceptionsHandlerTest.fromGlobalFailure(new RuntimeException("exception #0"), System.currentTimeMillis());
        RootExceptionHistoryEntry otherFailure = new RootExceptionHistoryEntry((Throwable)new RuntimeException("exception #1"), System.currentTimeMillis(), CompletableFuture.completedFuture(Collections.singletonMap("key", "value")), "task name", (TaskManagerLocation)new LocalTaskManagerLocation(), Collections.emptySet());
        ExecutionGraphInfo executionGraphInfo = JobExceptionsHandlerTest.createExecutionGraphInfo(rootCause, otherFailure);
        HandlerRequest<EmptyRequestBody> request = JobExceptionsHandlerTest.createRequest(executionGraphInfo.getJobId(), 10);
        JobExceptionsInfoWithHistory response = this.testInstance.handleRequest(request, executionGraphInfo);
        Assertions.assertThat((List)response.getExceptionHistory().getEntries()).satisfies((Condition)HamcrestCondition.matching((Matcher)Matchers.contains((Matcher[])new Matcher[]{JobExceptionsHandlerTest.historyContainsGlobalFailure((Throwable)rootCause.getException(), rootCause.getTimestamp(), new Matcher[0]), JobExceptionsHandlerTest.historyContainsJobExceptionInfo((Throwable)otherFailure.getException(), otherFailure.getTimestamp(), otherFailure.getFailureLabelsFuture(), otherFailure.getFailingTaskName(), JobExceptionsHandler.toString((ExceptionHistoryEntry.ArchivedTaskManagerLocation)otherFailure.getTaskManagerLocation()), JobExceptionsHandler.toTaskManagerId((ExceptionHistoryEntry.ArchivedTaskManagerLocation)otherFailure.getTaskManagerLocation()), new Matcher[0])})));
        Assertions.assertThat((boolean)response.getExceptionHistory().isTruncated()).isFalse();
    }

    @Test
    void testWithExceptionHistoryAndConcurrentGlobalFailure() throws HandlerRequestException, ExecutionException, InterruptedException {
        ExceptionHistoryEntry otherFailure = ExceptionHistoryEntry.createGlobal((Throwable)new RuntimeException("exception #1"), CompletableFuture.completedFuture(Collections.emptyMap()));
        RootExceptionHistoryEntry rootCause = JobExceptionsHandlerTest.fromGlobalFailure(new RuntimeException("exception #0"), System.currentTimeMillis(), Collections.singleton(otherFailure));
        ExecutionGraphInfo executionGraphInfo = JobExceptionsHandlerTest.createExecutionGraphInfo(rootCause);
        HandlerRequest<EmptyRequestBody> request = JobExceptionsHandlerTest.createRequest(executionGraphInfo.getJobId(), 10);
        JobExceptionsInfoWithHistory response = this.testInstance.handleRequest(request, executionGraphInfo);
        ((ListAssert)Assertions.assertThat((List)response.getExceptionHistory().getEntries()).hasSize(1)).satisfies((Condition)HamcrestCondition.matching((Matcher)Matchers.contains(JobExceptionsHandlerTest.historyContainsGlobalFailure((Throwable)rootCause.getException(), rootCause.getTimestamp(), JobExceptionsHandlerTest.matchesFailure((Throwable)otherFailure.getException(), otherFailure.getTimestamp(), otherFailure.getFailureLabelsFuture(), otherFailure.getFailingTaskName(), JobExceptionsHandler.toString((ExceptionHistoryEntry.ArchivedTaskManagerLocation)otherFailure.getTaskManagerLocation()), JobExceptionsHandler.toTaskManagerId((ExceptionHistoryEntry.ArchivedTaskManagerLocation)otherFailure.getTaskManagerLocation()))))));
        Assertions.assertThat((boolean)response.getExceptionHistory().isTruncated()).isFalse();
    }

    @Test
    void testWithExceptionHistoryWithMatchingFailureLabel() throws HandlerRequestException, ExecutionException, InterruptedException {
        RootExceptionHistoryEntry rootCause = JobExceptionsHandlerTest.fromGlobalFailure(new RuntimeException("exception #0"), System.currentTimeMillis());
        RootExceptionHistoryEntry matchingFailure = new RootExceptionHistoryEntry((Throwable)new RuntimeException("exception #1"), System.currentTimeMillis(), CompletableFuture.completedFuture(new HashMap<String, String>(){
            {
                this.put("key1", "value1");
                this.put("key3", "value3");
            }
        }), "task name", (TaskManagerLocation)new LocalTaskManagerLocation(), Collections.emptySet());
        RootExceptionHistoryEntry noMatchingFailure = new RootExceptionHistoryEntry((Throwable)new RuntimeException("exception #2"), System.currentTimeMillis(), CompletableFuture.completedFuture(Collections.singletonMap("key2", "value2")), "task name", (TaskManagerLocation)new LocalTaskManagerLocation(), Collections.emptySet());
        RootExceptionHistoryEntry anotherMatchingFailure = new RootExceptionHistoryEntry((Throwable)new RuntimeException("exception #3"), System.currentTimeMillis(), CompletableFuture.completedFuture(new HashMap<String, String>(){
            {
                this.put("key1", "value1");
                this.put("key3", "value2");
            }
        }), "task name", (TaskManagerLocation)new LocalTaskManagerLocation(), Collections.emptySet());
        ExecutionGraphInfo executionGraphInfo = JobExceptionsHandlerTest.createExecutionGraphInfo(rootCause, matchingFailure, noMatchingFailure, anotherMatchingFailure);
        HandlerRequest<EmptyRequestBody> request = JobExceptionsHandlerTest.createRequest(executionGraphInfo.getJobId(), 10, Arrays.asList("key1:value1", "key3:value3"));
        JobExceptionsInfoWithHistory response = this.testInstance.handleRequest(request, executionGraphInfo);
        Assertions.assertThat((List)response.getExceptionHistory().getEntries()).hasSize(1);
        Assertions.assertThat((List)response.getExceptionHistory().getEntries()).satisfies((Condition)HamcrestCondition.matching((Matcher)Matchers.contains(JobExceptionsHandlerTest.historyContainsJobExceptionInfo((Throwable)matchingFailure.getException(), matchingFailure.getTimestamp(), matchingFailure.getFailureLabelsFuture(), matchingFailure.getFailingTaskName(), JobExceptionsHandler.toString((ExceptionHistoryEntry.ArchivedTaskManagerLocation)matchingFailure.getTaskManagerLocation()), JobExceptionsHandler.toTaskManagerId((ExceptionHistoryEntry.ArchivedTaskManagerLocation)matchingFailure.getTaskManagerLocation()), new Matcher[0]))));
        Assertions.assertThat((boolean)response.getExceptionHistory().isTruncated()).isFalse();
    }

    @Test
    void testWithLocalExceptionHistoryEntryNotHavingATaskManagerInformationAvailable() throws HandlerRequestException, ExecutionException, InterruptedException {
        RootExceptionHistoryEntry failure = new RootExceptionHistoryEntry((Throwable)new RuntimeException("exception #1"), System.currentTimeMillis(), CompletableFuture.completedFuture(Collections.singletonMap("key", "value")), "task name", null, Collections.emptySet());
        ExecutionGraphInfo executionGraphInfo = JobExceptionsHandlerTest.createExecutionGraphInfo(failure);
        HandlerRequest<EmptyRequestBody> request = JobExceptionsHandlerTest.createRequest(executionGraphInfo.getJobId(), 10);
        JobExceptionsInfoWithHistory response = this.testInstance.handleRequest(request, executionGraphInfo);
        Assertions.assertThat((List)response.getExceptionHistory().getEntries()).satisfies((Condition)HamcrestCondition.matching((Matcher)Matchers.contains(JobExceptionsHandlerTest.historyContainsJobExceptionInfo((Throwable)failure.getException(), failure.getTimestamp(), failure.getFailureLabelsFuture(), failure.getFailingTaskName(), JobExceptionsHandler.toString((ExceptionHistoryEntry.ArchivedTaskManagerLocation)failure.getTaskManagerLocation()), JobExceptionsHandler.toTaskManagerId((ExceptionHistoryEntry.ArchivedTaskManagerLocation)failure.getTaskManagerLocation()), new Matcher[0]))));
    }

    @Test
    void testWithExceptionHistoryWithTruncationThroughParameter() throws HandlerRequestException, ExecutionException, InterruptedException {
        RootExceptionHistoryEntry rootCause = JobExceptionsHandlerTest.fromGlobalFailure(new RuntimeException("exception #0"), System.currentTimeMillis());
        RootExceptionHistoryEntry otherFailure = new RootExceptionHistoryEntry((Throwable)new RuntimeException("exception #1"), System.currentTimeMillis(), CompletableFuture.completedFuture(Collections.singletonMap("key", "value")), "task name", (TaskManagerLocation)new LocalTaskManagerLocation(), Collections.emptySet());
        ExecutionGraphInfo executionGraphInfo = JobExceptionsHandlerTest.createExecutionGraphInfo(rootCause, otherFailure);
        HandlerRequest<EmptyRequestBody> request = JobExceptionsHandlerTest.createRequest(executionGraphInfo.getJobId(), 1);
        JobExceptionsInfoWithHistory response = this.testInstance.handleRequest(request, executionGraphInfo);
        Assertions.assertThat((List)response.getExceptionHistory().getEntries()).satisfies((Condition)HamcrestCondition.matching((Matcher)Matchers.contains(JobExceptionsHandlerTest.historyContainsGlobalFailure((Throwable)rootCause.getException(), rootCause.getTimestamp(), new Matcher[0]))));
        Assertions.assertThat((List)response.getExceptionHistory().getEntries()).satisfies((Condition)HamcrestCondition.matching((Matcher)IsIterableWithSize.iterableWithSize((int)1)));
        Assertions.assertThat((boolean)response.getExceptionHistory().isTruncated()).isTrue();
    }

    @Test
    void testTaskManagerLocationFallbackHandling() {
        Assertions.assertThat((String)JobExceptionsHandler.toString((TaskManagerLocation)null)).isEqualTo("(unassigned)");
    }

    @Test
    void testTaskManagerLocationHandling() {
        LocalTaskManagerLocation taskManagerLocation = new LocalTaskManagerLocation();
        Assertions.assertThat((String)JobExceptionsHandler.toString((TaskManagerLocation)taskManagerLocation)).isEqualTo(String.format("%s:%s", taskManagerLocation.getFQDNHostname(), taskManagerLocation.dataPort()));
    }

    @Test
    void testArchivedTaskManagerLocationFallbackHandling() {
        Assertions.assertThat((String)JobExceptionsHandler.toString((ExceptionHistoryEntry.ArchivedTaskManagerLocation)null)).isNull();
    }

    @Test
    void testArchivedTaskManagerLocationHandling() {
        LocalTaskManagerLocation taskManagerLocation = new LocalTaskManagerLocation();
        Assertions.assertThat((String)JobExceptionsHandler.toString((TaskManagerLocation)taskManagerLocation)).isEqualTo(String.format("%s:%s", taskManagerLocation.getFQDNHostname(), taskManagerLocation.dataPort()));
    }

    @Test
    void testGetJobExceptionsInfo() throws HandlerRequestException {
        int numExceptions = 20;
        ExecutionGraphInfo archivedExecutionGraph = JobExceptionsHandlerTest.createAccessExecutionGraph(20);
        JobExceptionsHandlerTest.checkExceptionLimit(this.testInstance, archivedExecutionGraph, 20, 10);
        JobExceptionsHandlerTest.checkExceptionLimit(this.testInstance, archivedExecutionGraph, 20, 20);
        JobExceptionsHandlerTest.checkExceptionLimit(this.testInstance, archivedExecutionGraph, 20, 30);
    }

    private static void checkExceptionLimit(JobExceptionsHandler jobExceptionsHandler, ExecutionGraphInfo graph, int maxNumExceptions, int numExpectedException) throws HandlerRequestException {
        HandlerRequest<EmptyRequestBody> handlerRequest = JobExceptionsHandlerTest.createRequest(graph.getJobId(), numExpectedException);
        JobExceptionsInfoWithHistory jobExceptionsInfo = jobExceptionsHandler.handleRequest(handlerRequest, graph);
        int numReportedException = Math.min(maxNumExceptions, numExpectedException);
        Assertions.assertThat((int)numReportedException).isEqualTo(jobExceptionsInfo.getAllExceptions().size());
    }

    private static ExecutionGraphInfo createAccessExecutionGraph(int numTasks) {
        HashMap<JobVertexID, ArchivedExecutionJobVertex> tasks = new HashMap<JobVertexID, ArchivedExecutionJobVertex>();
        for (int i = 0; i < numTasks; ++i) {
            JobVertexID jobVertexId = new JobVertexID();
            tasks.put(jobVertexId, JobExceptionsHandlerTest.createArchivedExecutionJobVertex(jobVertexId));
        }
        RuntimeException failureCause = new RuntimeException("root cause");
        long failureTimestamp = System.currentTimeMillis();
        List<RootExceptionHistoryEntry> exceptionHistory = Collections.singletonList(new RootExceptionHistoryEntry((Throwable)failureCause, failureTimestamp, FailureEnricherUtils.EMPTY_FAILURE_LABELS, "test task #1", (TaskManagerLocation)new LocalTaskManagerLocation(), Collections.emptySet()));
        return new ExecutionGraphInfo(new ArchivedExecutionGraphBuilder().setFailureCause(new ErrorInfo((Throwable)failureCause, failureTimestamp)).setTasks(tasks).build(), exceptionHistory);
    }

    private static ArchivedExecutionJobVertex createArchivedExecutionJobVertex(JobVertexID jobVertexID) {
        StringifiedAccumulatorResult[] emptyAccumulators = new StringifiedAccumulatorResult[]{};
        long[] timestamps = new long[ExecutionState.values().length];
        long[] endTimestamps = new long[ExecutionState.values().length];
        ExecutionState expectedState = ExecutionState.RUNNING;
        LocalTaskManagerLocation assignedResourceLocation = new LocalTaskManagerLocation();
        AllocationID allocationID = new AllocationID();
        boolean subtaskIndex = true;
        int attempt = 2;
        return new ArchivedExecutionJobVertex(new ArchivedExecutionVertex[]{new ArchivedExecutionVertex(1, "test task", new ArchivedExecution(new StringifiedAccumulatorResult[0], null, ExecutionGraphTestUtils.createExecutionAttemptId(jobVertexID, 1, 2), expectedState, new ErrorInfo((Throwable)new RuntimeException("error"), System.currentTimeMillis()), (TaskManagerLocation)assignedResourceLocation, allocationID, timestamps, endTimestamps), new ExecutionHistory(0))}, jobVertexID, jobVertexID.toString(), 1, 1, new SlotSharingGroup(), ResourceProfile.UNKNOWN, emptyAccumulators);
    }

    private static ExecutionGraphInfo createExecutionGraphInfo(RootExceptionHistoryEntry ... historyEntries) {
        return JobExceptionsHandlerTest.createExecutionGraphInfo(true, historyEntries);
    }

    private static ExecutionGraphInfo createExecutionGraphInfoWithoutFailureCause(RootExceptionHistoryEntry ... historyEntries) {
        return JobExceptionsHandlerTest.createExecutionGraphInfo(false, historyEntries);
    }

    private static ExecutionGraphInfo createExecutionGraphInfo(boolean setFailureCause, RootExceptionHistoryEntry ... historyEntries) {
        ArchivedExecutionGraphBuilder executionGraphBuilder = new ArchivedExecutionGraphBuilder();
        ArrayList<RootExceptionHistoryEntry> historyEntryCollection = new ArrayList<RootExceptionHistoryEntry>();
        for (int i = 0; i < historyEntries.length; ++i) {
            if (i == 0 && setFailureCause) {
                executionGraphBuilder.setFailureCause(new ErrorInfo((Throwable)historyEntries[i].getException(), historyEntries[i].getTimestamp()));
            }
            historyEntryCollection.add(historyEntries[i]);
        }
        Collections.reverse(historyEntryCollection);
        return new ExecutionGraphInfo(executionGraphBuilder.build(), historyEntryCollection);
    }

    private static HandlerRequest<EmptyRequestBody> createRequest(JobID jobId, int size) throws HandlerRequestException {
        return JobExceptionsHandlerTest.createRequest(jobId, size, Collections.emptyList());
    }

    private static HandlerRequest<EmptyRequestBody> createRequest(JobID jobId, int size, List<String> failureLabels) throws HandlerRequestException {
        HashMap<String, String> pathParameters = new HashMap<String, String>();
        pathParameters.put("jobid", jobId.toString());
        HashMap<String, List<String>> queryParameters = new HashMap<String, List<String>>();
        queryParameters.put("maxExceptions", Collections.singletonList("" + size));
        if (!failureLabels.isEmpty()) {
            queryParameters.put("failureLabelFilter", failureLabels);
        }
        return HandlerRequest.resolveParametersAndCreate((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new JobExceptionsMessageParameters(), pathParameters, queryParameters, Collections.emptyList());
    }

    private static RootExceptionHistoryEntry fromGlobalFailure(Throwable cause, long timestamp) {
        return JobExceptionsHandlerTest.fromGlobalFailure(cause, timestamp, Collections.emptySet());
    }

    private static RootExceptionHistoryEntry fromGlobalFailure(Throwable cause, long timestamp, Collection<ExceptionHistoryEntry> concurrentExceptions) {
        return new RootExceptionHistoryEntry(cause, timestamp, FailureEnricherUtils.EMPTY_FAILURE_LABELS, null, null, concurrentExceptions);
    }

    @SafeVarargs
    private static Matcher<JobExceptionsInfoWithHistory.RootExceptionInfo> historyContainsJobExceptionInfo(Throwable expectedFailureCause, long expectedFailureTimestamp, CompletableFuture<Map<String, String>> expectedFailureLabels, String expectedTaskNameWithSubtaskId, String expectedTaskManagerLocation, String expectedTaskManagerId, Matcher<JobExceptionsInfoWithHistory.ExceptionInfo> ... concurrentExceptionMatchers) throws ExecutionException, InterruptedException {
        return new RootExceptionInfoMatcher((Matcher)JobExceptionsHandlerTest.matchesFailure(expectedFailureCause, expectedFailureTimestamp, expectedFailureLabels, expectedTaskNameWithSubtaskId, expectedTaskManagerLocation, expectedTaskManagerId), (Matcher[])concurrentExceptionMatchers);
    }

    @SafeVarargs
    private static Matcher<JobExceptionsInfoWithHistory.RootExceptionInfo> historyContainsGlobalFailure(Throwable expectedFailureCause, long expectedFailureTimestamp, Matcher<JobExceptionsInfoWithHistory.ExceptionInfo> ... concurrentExceptionMatchers) throws ExecutionException, InterruptedException {
        return new RootExceptionInfoMatcher((Matcher)JobExceptionsHandlerTest.matchesFailure(expectedFailureCause, expectedFailureTimestamp, FailureEnricherUtils.EMPTY_FAILURE_LABELS, null, null, null), (Matcher[])concurrentExceptionMatchers);
    }

    private static Matcher<JobExceptionsInfoWithHistory.ExceptionInfo> matchesFailure(Throwable expectedFailureCause, long expectedFailureTimestamp, CompletableFuture<Map<String, String>> expectedFailureLabels, String expectedTaskNameWithSubtaskId, String expectedTaskManagerLocation, String expectedTaskManagerId) throws ExecutionException, InterruptedException {
        return new ExceptionInfoMatcher(expectedFailureCause, expectedFailureTimestamp, expectedFailureLabels, expectedTaskNameWithSubtaskId, expectedTaskManagerLocation, expectedTaskManagerId);
    }

    private static class ExceptionInfoMatcher
    extends TypeSafeDiagnosingMatcher<JobExceptionsInfoWithHistory.ExceptionInfo> {
        private final Throwable expectedException;
        private final long expectedTimestamp;
        private final Map<String, String> expectedFailureLabels;
        private final String expectedTaskName;
        private final String expectedLocation;
        private final String expectedTaskManagerId;

        private ExceptionInfoMatcher(Throwable expectedException, long expectedTimestamp, CompletableFuture<Map<String, String>> expectedFailureLabels, String expectedTaskName, String expectedLocation, String expectedTaskManagerId) throws ExecutionException, InterruptedException {
            this.expectedException = this.deserializeSerializedThrowable(expectedException);
            this.expectedTimestamp = expectedTimestamp;
            this.expectedFailureLabels = expectedFailureLabels.get();
            this.expectedTaskName = expectedTaskName;
            this.expectedLocation = expectedLocation;
            this.expectedTaskManagerId = expectedTaskManagerId;
        }

        public void describeTo(Description description) {
            description.appendText("exceptionName=").appendText(this.getExpectedExceptionName()).appendText(", exceptionStacktrace=").appendText(this.getExpectedStacktrace()).appendText(", timestamp=").appendText(String.valueOf(this.expectedTimestamp)).appendText(", failureLabels=").appendText(String.valueOf(this.expectedFailureLabels)).appendText(", taskName=").appendText(this.expectedTaskName).appendText(", location=").appendText(this.expectedLocation).appendText(", taskManagerId=").appendText(this.expectedTaskManagerId);
        }

        private String getExpectedExceptionName() {
            return this.expectedException.getClass().getName();
        }

        private String getExpectedStacktrace() {
            return ExceptionUtils.stringifyException((Throwable)this.expectedException);
        }

        protected boolean matchesSafely(JobExceptionsInfoWithHistory.ExceptionInfo info, Description description) {
            return this.matches(info, description, JobExceptionsInfoWithHistory.ExceptionInfo::getExceptionName, this.getExpectedExceptionName(), "exceptionName") && this.matches(info, description, JobExceptionsInfoWithHistory.ExceptionInfo::getStacktrace, ExceptionUtils.stringifyException((Throwable)this.expectedException), "stacktrace") && this.matches(info, description, JobExceptionsInfoWithHistory.ExceptionInfo::getTimestamp, this.expectedTimestamp, "timestamp") && this.matches(info, description, JobExceptionsInfoWithHistory.ExceptionInfo::getTaskName, this.expectedTaskName, "taskName") && this.matches(info, description, JobExceptionsInfoWithHistory.ExceptionInfo::getLocation, this.expectedLocation, "location") && this.matches(info, description, JobExceptionsInfoWithHistory.ExceptionInfo::getTaskManagerId, this.expectedTaskManagerId, "taskManagerId");
        }

        private <R> boolean matches(JobExceptionsInfoWithHistory.ExceptionInfo info, Description desc, Function<JobExceptionsInfoWithHistory.ExceptionInfo, R> extractor, R expectedValue, String attributeName) {
            R actualValue = extractor.apply(info);
            if (actualValue == null) {
                return expectedValue == null;
            }
            boolean match = actualValue.equals(expectedValue);
            if (!match) {
                desc.appendText(attributeName).appendText("=").appendText(String.valueOf(actualValue));
            }
            return match;
        }

        protected Throwable deserializeSerializedThrowable(Throwable throwable) {
            return throwable instanceof SerializedThrowable ? ((SerializedThrowable)throwable).deserializeError(ClassLoader.getSystemClassLoader()) : throwable;
        }
    }

    private static class RootExceptionInfoMatcher
    extends TypeSafeDiagnosingMatcher<JobExceptionsInfoWithHistory.RootExceptionInfo> {
        private final Matcher<JobExceptionsInfoWithHistory.ExceptionInfo> rootCauseMatcher;
        private final Matcher<Iterable<? extends JobExceptionsInfoWithHistory.ExceptionInfo>> concurrentExceptionsMatcher;

        @SafeVarargs
        private RootExceptionInfoMatcher(Matcher<JobExceptionsInfoWithHistory.ExceptionInfo> rootCauseMatcher, Matcher<JobExceptionsInfoWithHistory.ExceptionInfo> ... concurrentExceptionsMatchers) {
            this.rootCauseMatcher = rootCauseMatcher;
            this.concurrentExceptionsMatcher = concurrentExceptionsMatchers.length == 0 ? IsEmptyIterable.emptyIterable() : IsIterableContainingInOrder.contains(Arrays.asList(concurrentExceptionsMatchers));
        }

        protected boolean matchesSafely(JobExceptionsInfoWithHistory.RootExceptionInfo rootExceptionInfo, Description description) {
            boolean match = true;
            if (!this.rootCauseMatcher.matches((Object)rootExceptionInfo)) {
                this.rootCauseMatcher.describeMismatch((Object)rootExceptionInfo, description);
                match = false;
            }
            if (!this.concurrentExceptionsMatcher.matches((Object)rootExceptionInfo.getConcurrentExceptions())) {
                this.concurrentExceptionsMatcher.describeMismatch((Object)rootExceptionInfo.getConcurrentExceptions(), description);
                return false;
            }
            return match;
        }

        public void describeTo(Description description) {
            this.rootCauseMatcher.describeTo(description);
            this.concurrentExceptionsMatcher.describeTo(description);
        }
    }
}

