/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.resourcemanager.slotmanager.PendingTaskManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerInfo;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerResourceInfoProvider;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerSlotInformation;
import org.apache.flink.util.Preconditions;

public class TestingTaskManagerResourceInfoProvider
implements TaskManagerResourceInfoProvider {
    private final Supplier<Collection<? extends TaskManagerInfo>> registeredTaskManagersSupplier;
    private final Function<InstanceID, Optional<TaskManagerInfo>> getRegisteredTaskManagerFunction;
    private final Supplier<Collection<PendingTaskManager>> pendingTaskManagersSupplier;
    private final Function<AllocationID, Optional<TaskManagerSlotInformation>> getAllocatedOrPendingSlotFunction;
    private final BiFunction<ResourceProfile, ResourceProfile, Collection<PendingTaskManager>> getPendingTaskManagersByTotalAndDefaultSlotResourceProfileFunction;

    private TestingTaskManagerResourceInfoProvider(Supplier<Collection<? extends TaskManagerInfo>> registeredTaskManagersSupplier, Function<InstanceID, Optional<TaskManagerInfo>> getRegisteredTaskManagerFunction, Supplier<Collection<PendingTaskManager>> pendingTaskManagersSupplier, Function<AllocationID, Optional<TaskManagerSlotInformation>> getAllocatedOrPendingSlotFunction, BiFunction<ResourceProfile, ResourceProfile, Collection<PendingTaskManager>> getPendingTaskManagersByTotalAndDefaultSlotResourceProfileFunction) {
        this.registeredTaskManagersSupplier = (Supplier)Preconditions.checkNotNull(registeredTaskManagersSupplier);
        this.getRegisteredTaskManagerFunction = (Function)Preconditions.checkNotNull(getRegisteredTaskManagerFunction);
        this.pendingTaskManagersSupplier = (Supplier)Preconditions.checkNotNull(pendingTaskManagersSupplier);
        this.getAllocatedOrPendingSlotFunction = (Function)Preconditions.checkNotNull(getAllocatedOrPendingSlotFunction);
        this.getPendingTaskManagersByTotalAndDefaultSlotResourceProfileFunction = (BiFunction)Preconditions.checkNotNull(getPendingTaskManagersByTotalAndDefaultSlotResourceProfileFunction);
    }

    public Collection<? extends TaskManagerInfo> getRegisteredTaskManagers() {
        return this.registeredTaskManagersSupplier.get();
    }

    public Optional<TaskManagerInfo> getRegisteredTaskManager(InstanceID instanceId) {
        return this.getRegisteredTaskManagerFunction.apply(instanceId);
    }

    public Collection<PendingTaskManager> getPendingTaskManagers() {
        return this.pendingTaskManagersSupplier.get();
    }

    public Optional<TaskManagerSlotInformation> getAllocatedOrPendingSlot(AllocationID allocationId) {
        return this.getAllocatedOrPendingSlotFunction.apply(allocationId);
    }

    public Collection<PendingTaskManager> getPendingTaskManagersByTotalAndDefaultSlotResourceProfile(ResourceProfile totalResourceProfile, ResourceProfile defaultSlotResourceProfile) {
        return this.getPendingTaskManagersByTotalAndDefaultSlotResourceProfileFunction.apply(totalResourceProfile, defaultSlotResourceProfile);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Supplier<Collection<? extends TaskManagerInfo>> registeredTaskManagersSupplier = Collections::emptyList;
        private Function<InstanceID, Optional<TaskManagerInfo>> getRegisteredTaskManagerFunction = ignore -> Optional.empty();
        private Supplier<Collection<PendingTaskManager>> pendingTaskManagersSupplier = Collections::emptyList;
        private Function<AllocationID, Optional<TaskManagerSlotInformation>> getAllocatedOrPendingSlotFunction = ignore -> Optional.empty();
        private BiFunction<ResourceProfile, ResourceProfile, Collection<PendingTaskManager>> getPendingTaskManagersByTotalAndDefaultSlotResourceProfileFunction = (ignored1, ignored2) -> Collections.emptyList();

        public Builder setGetAllocatedOrPendingSlotFunction(Function<AllocationID, Optional<TaskManagerSlotInformation>> getAllocatedOrPendingSlotFunction) {
            this.getAllocatedOrPendingSlotFunction = getAllocatedOrPendingSlotFunction;
            return this;
        }

        public Builder setGetRegisteredTaskManagerFunction(Function<InstanceID, Optional<TaskManagerInfo>> getRegisteredTaskManagerFunction) {
            this.getRegisteredTaskManagerFunction = getRegisteredTaskManagerFunction;
            return this;
        }

        public Builder setPendingTaskManagersSupplier(Supplier<Collection<PendingTaskManager>> pendingTaskManagersSupplier) {
            this.pendingTaskManagersSupplier = pendingTaskManagersSupplier;
            return this;
        }

        public Builder setRegisteredTaskManagersSupplier(Supplier<Collection<? extends TaskManagerInfo>> registeredTaskManagersSupplier) {
            this.registeredTaskManagersSupplier = registeredTaskManagersSupplier;
            return this;
        }

        public Builder setGetPendingTaskManagersByTotalAndDefaultSlotResourceProfileFunction(BiFunction<ResourceProfile, ResourceProfile, Collection<PendingTaskManager>> getPendingTaskManagersByTotalAndDefaultSlotResourceProfileFunction) {
            this.getPendingTaskManagersByTotalAndDefaultSlotResourceProfileFunction = getPendingTaskManagersByTotalAndDefaultSlotResourceProfileFunction;
            return this;
        }

        public TestingTaskManagerResourceInfoProvider build() {
            return new TestingTaskManagerResourceInfoProvider(this.registeredTaskManagersSupplier, this.getRegisteredTaskManagerFunction, this.pendingTaskManagersSupplier, this.getAllocatedOrPendingSlotFunction, this.getPendingTaskManagersByTotalAndDefaultSlotResourceProfileFunction);
        }
    }
}

