/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.ArrayList;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.resourcemanager.registration.TaskExecutorConnection;
import org.apache.flink.runtime.resourcemanager.slotmanager.FineGrainedTaskManagerRegistration;
import org.apache.flink.runtime.resourcemanager.slotmanager.FineGrainedTaskManagerSlot;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotState;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerSlotInformation;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TestingTaskExecutorGatewayBuilder;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FineGrainedTaskManagerRegistrationTest {
    private static final TaskExecutorConnection TASK_EXECUTOR_CONNECTION = new TaskExecutorConnection(ResourceID.generate(), (TaskExecutorGateway)new TestingTaskExecutorGatewayBuilder().createTestingTaskExecutorGateway());

    FineGrainedTaskManagerRegistrationTest() {
    }

    @Test
    void testFreeSlot() {
        ResourceProfile totalResource = ResourceProfile.fromResources((double)10.0, (int)1000);
        FineGrainedTaskManagerRegistration taskManager = new FineGrainedTaskManagerRegistration(TASK_EXECUTOR_CONNECTION, totalResource, totalResource);
        AllocationID allocationId = new AllocationID();
        JobID jobId = new JobID();
        FineGrainedTaskManagerSlot slot = new FineGrainedTaskManagerSlot(allocationId, jobId, ResourceProfile.fromResources((double)2.0, (int)100), TASK_EXECUTOR_CONNECTION, SlotState.ALLOCATED);
        taskManager.notifyAllocation(allocationId, slot);
        taskManager.freeSlot(allocationId);
        Assertions.assertThat((Object)taskManager.getAvailableResource()).isEqualTo((Object)totalResource);
        Assertions.assertThat((long)taskManager.getIdleSince()).isNotEqualTo(Long.MAX_VALUE);
        Assertions.assertThat((Map)taskManager.getAllocatedSlots()).isEmpty();
    }

    @Test
    void testNotifyAllocation() {
        ResourceProfile totalResource = ResourceProfile.fromResources((double)10.0, (int)1000);
        FineGrainedTaskManagerRegistration taskManager = new FineGrainedTaskManagerRegistration(TASK_EXECUTOR_CONNECTION, totalResource, totalResource);
        AllocationID allocationId = new AllocationID();
        JobID jobId = new JobID();
        FineGrainedTaskManagerSlot slot = new FineGrainedTaskManagerSlot(allocationId, jobId, ResourceProfile.fromResources((double)2.0, (int)100), TASK_EXECUTOR_CONNECTION, SlotState.ALLOCATED);
        taskManager.notifyAllocation(allocationId, slot);
        Assertions.assertThat((Object)taskManager.getAvailableResource()).isEqualTo((Object)ResourceProfile.fromResources((double)8.0, (int)900));
        Assertions.assertThat((long)taskManager.getIdleSince()).isEqualTo(Long.MAX_VALUE);
        Assertions.assertThat((Map)taskManager.getAllocatedSlots()).containsKey((Object)allocationId);
    }

    @Test
    void testNotifyAllocationComplete() {
        ResourceProfile totalResource = ResourceProfile.fromResources((double)10.0, (int)1000);
        FineGrainedTaskManagerRegistration taskManager = new FineGrainedTaskManagerRegistration(TASK_EXECUTOR_CONNECTION, totalResource, totalResource);
        AllocationID allocationId = new AllocationID();
        JobID jobId = new JobID();
        FineGrainedTaskManagerSlot slot = new FineGrainedTaskManagerSlot(allocationId, jobId, ResourceProfile.fromResources((double)2.0, (int)100), TASK_EXECUTOR_CONNECTION, SlotState.PENDING);
        taskManager.notifyAllocation(allocationId, slot);
        Assertions.assertThat((Object)taskManager.getAvailableResource()).isEqualTo((Object)ResourceProfile.fromResources((double)8.0, (int)900));
        Assertions.assertThat((long)taskManager.getIdleSince()).isEqualTo(Long.MAX_VALUE);
        Assertions.assertThat((Map)taskManager.getAllocatedSlots()).containsKey((Object)allocationId);
        taskManager.notifyAllocationComplete(allocationId);
        Assertions.assertThat((Object)taskManager.getAvailableResource()).isEqualTo((Object)ResourceProfile.fromResources((double)8.0, (int)900));
        Assertions.assertThat((long)taskManager.getIdleSince()).isEqualTo(Long.MAX_VALUE);
        Assertions.assertThat((Map)taskManager.getAllocatedSlots()).containsKey((Object)allocationId);
        Assertions.assertThat((Comparable)((TaskManagerSlotInformation)taskManager.getAllocatedSlots().get(allocationId)).getState()).isEqualTo((Object)SlotState.ALLOCATED);
    }

    @Test
    void testNotifyAllocationWithoutEnoughResource() {
        ResourceProfile totalResource = ResourceProfile.fromResources((double)1.0, (int)100);
        FineGrainedTaskManagerRegistration taskManager = new FineGrainedTaskManagerRegistration(TASK_EXECUTOR_CONNECTION, totalResource, totalResource);
        AllocationID allocationId = new AllocationID();
        JobID jobId = new JobID();
        FineGrainedTaskManagerSlot slot1 = new FineGrainedTaskManagerSlot(allocationId, jobId, ResourceProfile.fromResources((double)2.0, (int)100), TASK_EXECUTOR_CONNECTION, SlotState.PENDING);
        FineGrainedTaskManagerSlot slot2 = new FineGrainedTaskManagerSlot(allocationId, jobId, ResourceProfile.fromResources((double)2.0, (int)100), TASK_EXECUTOR_CONNECTION, SlotState.ALLOCATED);
        ArrayList<RuntimeException> exceptions = new ArrayList<RuntimeException>();
        try {
            taskManager.notifyAllocation(allocationId, slot1);
        }
        catch (IllegalStateException e) {
            exceptions.add(e);
        }
        try {
            taskManager.notifyAllocation(allocationId, slot2);
        }
        catch (IllegalArgumentException e) {
            exceptions.add(e);
        }
        Assertions.assertThat(exceptions).hasSize(2);
    }
}

