/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.util.Map;
import org.apache.flink.api.common.resources.ExternalResource;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExternalResourceOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessSpec;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessUtils;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class WorkerResourceSpecTest {
    private static final String EXTERNAL_RESOURCE_NAME = "gpu";

    WorkerResourceSpecTest() {
    }

    @Test
    void testEquals() {
        WorkerResourceSpec spec1 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setNumSlots(1).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec spec2 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setNumSlots(1).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec spec3 = new WorkerResourceSpec.Builder().setCpuCores(1.1).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setNumSlots(1).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec spec4 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(110).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setNumSlots(1).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec spec5 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(110).setNetworkMemoryMB(100).setManagedMemoryMB(100).setNumSlots(1).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec spec6 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(110).setManagedMemoryMB(100).setNumSlots(1).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec spec7 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(110).setNumSlots(1).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec spec8 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setNumSlots(2).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec spec9 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setNumSlots(1).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 2.0)).build();
        WorkerResourceSpec spec10 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setNumSlots(1).build();
        Assertions.assertThat((Object)spec1).isEqualTo((Object)spec1);
        Assertions.assertThat((Object)spec1).isEqualTo((Object)spec2);
        Assertions.assertThat((Object)spec1).isNotEqualTo((Object)spec3);
        Assertions.assertThat((Object)spec1).isNotEqualTo((Object)spec4);
        Assertions.assertThat((Object)spec1).isNotEqualTo((Object)spec5);
        Assertions.assertThat((Object)spec1).isNotEqualTo((Object)spec6);
        Assertions.assertThat((Object)spec1).isNotEqualTo((Object)spec7);
        Assertions.assertThat((Object)spec1).isNotEqualTo((Object)spec8);
        Assertions.assertThat((Object)spec1).isNotEqualTo((Object)spec9);
        Assertions.assertThat((Object)spec1).isNotEqualTo((Object)spec10);
    }

    @Test
    void testHashCodeEquals() {
        WorkerResourceSpec spec1 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setNumSlots(1).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec spec2 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setNumSlots(1).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec spec3 = new WorkerResourceSpec.Builder().setCpuCores(1.1).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setNumSlots(1).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec spec4 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(110).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setNumSlots(1).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec spec5 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(110).setNetworkMemoryMB(100).setManagedMemoryMB(100).setNumSlots(1).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec spec6 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(110).setManagedMemoryMB(100).setNumSlots(1).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec spec7 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(110).setNumSlots(1).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec spec8 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setNumSlots(2).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec spec9 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setNumSlots(1).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 2.0)).build();
        WorkerResourceSpec spec10 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setNumSlots(1).build();
        Assertions.assertThat((int)spec1.hashCode()).isEqualTo(spec2.hashCode());
        Assertions.assertThat((int)spec1.hashCode()).isEqualTo(spec1.hashCode());
        Assertions.assertThat((int)spec1.hashCode()).isNotEqualTo(spec3.hashCode());
        Assertions.assertThat((int)spec1.hashCode()).isNotEqualTo(spec4.hashCode());
        Assertions.assertThat((int)spec1.hashCode()).isNotEqualTo(spec5.hashCode());
        Assertions.assertThat((int)spec1.hashCode()).isNotEqualTo(spec6.hashCode());
        Assertions.assertThat((int)spec1.hashCode()).isNotEqualTo(spec7.hashCode());
        Assertions.assertThat((int)spec1.hashCode()).isNotEqualTo(spec8.hashCode());
        Assertions.assertThat((int)spec1.hashCode()).isNotEqualTo(spec9.hashCode());
        Assertions.assertThat((int)spec1.hashCode()).isNotEqualTo(spec10.hashCode());
    }

    @Test
    void testCreateFromTaskExecutorProcessSpec() {
        Configuration config = new Configuration();
        config.setString(ExternalResourceOptions.EXTERNAL_RESOURCE_LIST.key(), EXTERNAL_RESOURCE_NAME);
        config.setLong(ExternalResourceOptions.getAmountConfigOptionForResource((String)EXTERNAL_RESOURCE_NAME), 1L);
        TaskExecutorProcessSpec taskExecutorProcessSpec = TaskExecutorProcessUtils.newProcessSpecBuilder((Configuration)config).withTotalProcessMemory(MemorySize.ofMebiBytes((long)1024L)).build();
        WorkerResourceSpec workerResourceSpec = WorkerResourceSpec.fromTaskExecutorProcessSpec((TaskExecutorProcessSpec)taskExecutorProcessSpec);
        Assertions.assertThat((Comparable)workerResourceSpec.getCpuCores()).isEqualTo((Object)taskExecutorProcessSpec.getCpuCores());
        Assertions.assertThat((Comparable)workerResourceSpec.getTaskHeapSize()).isEqualTo((Object)taskExecutorProcessSpec.getTaskHeapSize());
        Assertions.assertThat((Comparable)workerResourceSpec.getTaskOffHeapSize()).isEqualTo((Object)taskExecutorProcessSpec.getTaskOffHeapSize());
        Assertions.assertThat((Comparable)workerResourceSpec.getNetworkMemSize()).isEqualTo((Object)taskExecutorProcessSpec.getNetworkMemSize());
        Assertions.assertThat((Comparable)workerResourceSpec.getManagedMemSize()).isEqualTo((Object)taskExecutorProcessSpec.getManagedMemorySize());
        Assertions.assertThat((int)workerResourceSpec.getNumSlots()).isEqualTo(taskExecutorProcessSpec.getNumSlots());
        Assertions.assertThat((Map)workerResourceSpec.getExtendedResources()).isEqualTo((Object)taskExecutorProcessSpec.getExtendedResources());
    }

    @Test
    void testCreateFromResourceProfile() {
        int numSlots = 3;
        ResourceProfile resourceProfile = ResourceProfile.newBuilder().setCpuCores(1.0).setManagedMemoryMB(100).setNetworkMemoryMB(100).setTaskOffHeapMemoryMB(10).setTaskHeapMemoryMB(10).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec workerResourceSpec = WorkerResourceSpec.fromTotalResourceProfile((ResourceProfile)resourceProfile, (int)3);
        Assertions.assertThat((Comparable)workerResourceSpec.getCpuCores()).isEqualTo((Object)resourceProfile.getCpuCores());
        Assertions.assertThat((Comparable)workerResourceSpec.getTaskHeapSize()).isEqualTo((Object)resourceProfile.getTaskHeapMemory());
        Assertions.assertThat((Comparable)workerResourceSpec.getTaskOffHeapSize()).isEqualTo((Object)resourceProfile.getTaskOffHeapMemory());
        Assertions.assertThat((Comparable)workerResourceSpec.getNetworkMemSize()).isEqualTo((Object)resourceProfile.getNetworkMemory());
        Assertions.assertThat((Comparable)workerResourceSpec.getManagedMemSize()).isEqualTo((Object)resourceProfile.getManagedMemory());
        Assertions.assertThat((int)workerResourceSpec.getNumSlots()).isEqualTo(3);
        Assertions.assertThat((Map)workerResourceSpec.getExtendedResources()).isEqualTo((Object)resourceProfile.getExtendedResources());
    }
}

