/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.testutils.types;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.base.IntComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.operators.testutils.types.IntList;

public class IntListComparator
extends TypeComparator<IntList> {
    private static final long serialVersionUID = 1L;
    private int reference;
    private final TypeComparator[] comparators = new TypeComparator[]{new IntComparator(true)};

    public int hash(IntList record) {
        return record.getKey() * 73;
    }

    public void setReference(IntList toCompare) {
        this.reference = toCompare.getKey();
    }

    public boolean equalToReference(IntList candidate) {
        return candidate.getKey() == this.reference;
    }

    public int compareToReference(TypeComparator<IntList> referencedComparator) {
        IntListComparator comp = (IntListComparator)referencedComparator;
        return comp.reference - this.reference;
    }

    public int compare(IntList first, IntList second) {
        return first.getKey() - second.getKey();
    }

    public int compareSerialized(DataInputView source1, DataInputView source2) throws IOException {
        return source1.readInt() - source2.readInt();
    }

    public boolean supportsNormalizedKey() {
        return true;
    }

    public boolean supportsSerializationWithKeyNormalization() {
        return true;
    }

    public int getNormalizeKeyLen() {
        return 4;
    }

    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < 4;
    }

    public void putNormalizedKey(IntList record, MemorySegment target, int offset, int len) {
        block5: {
            int value;
            block4: {
                value = record.getKey() - Integer.MIN_VALUE;
                if (len != 4) break block4;
                target.putIntBigEndian(offset, value);
                break block5;
            }
            if (len <= 0) break block5;
            if (len < 4) {
                int i = 0;
                while (len > 0) {
                    target.put(offset + i, (byte)(value >>> (3 - i << 3) & 0xFF));
                    --len;
                    ++i;
                }
            } else {
                target.putIntBigEndian(offset, value);
                for (int i = 4; i < len; ++i) {
                    target.put(offset + i, (byte)0);
                }
            }
        }
    }

    public void writeWithKeyNormalization(IntList record, DataOutputView target) throws IOException {
        target.writeInt(record.getKey() - Integer.MIN_VALUE);
        target.writeInt(record.getValue().length);
        for (int i = 0; i < record.getValue().length; ++i) {
            target.writeInt(record.getValue()[i]);
        }
    }

    public IntList readWithKeyDenormalization(IntList record, DataInputView source) throws IOException {
        record.setKey(source.readInt() + Integer.MIN_VALUE);
        int[] value = new int[source.readInt()];
        for (int i = 0; i < value.length; ++i) {
            value[i] = source.readInt();
        }
        record.setValue(value);
        return record;
    }

    public boolean invertNormalizedKey() {
        return false;
    }

    public TypeComparator<IntList> duplicate() {
        return new IntListComparator();
    }

    public int extractKeys(Object record, Object[] target, int index) {
        target[index] = (Comparable)record;
        return 1;
    }

    public TypeComparator[] getFlatComparators() {
        return this.comparators;
    }
}

